/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hamcrest.matchers;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ResourcePropertiesMatcher
extends TypeSafeMatcher<Resource> {
    private final Map<String, Object> expectedProps;
    private String firstMismatchPropertyName;

    public ResourcePropertiesMatcher(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties is null or empty");
        }
        this.firstMismatchPropertyName = null;
        this.expectedProps = properties;
    }

    public void describeTo(Description description) {
        description.appendText("Resource with properties ").appendValueList("[", ",", "]", this.convertArraysToStrings(this.expectedProps).entrySet());
    }

    protected boolean matchesSafely(Resource item) {
        ValueMap givenProps = item.getValueMap();
        for (Map.Entry<String, Object> prop : this.expectedProps.entrySet()) {
            Object givenValue = givenProps.get((Object)prop.getKey());
            Object expectedValue = prop.getValue();
            if (givenValue != null && expectedValue != null && givenValue.getClass().isArray() && expectedValue.getClass().isArray()) {
                if (this.arrayEquals(expectedValue, givenValue)) continue;
                this.firstMismatchPropertyName = prop.getKey();
                return false;
            }
            if (this.objectEquals(expectedValue, givenValue)) continue;
            this.firstMismatchPropertyName = prop.getKey();
            return false;
        }
        return true;
    }

    private boolean objectEquals(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value2 == null) {
            return value1 == null;
        }
        return value1.equals(value2);
    }

    private boolean arrayEquals(Object array1, Object array2) {
        int length2;
        int length1 = Array.getLength(array1);
        if (length1 != (length2 = Array.getLength(array2))) {
            return false;
        }
        for (int i = 0; i < length1; ++i) {
            if (this.objectEquals(Array.get(array1, i), Array.get(array2, i))) continue;
            return false;
        }
        return true;
    }

    protected void describeMismatchSafely(Resource item, Description mismatchDescription) {
        ValueMap actualProperties = item.getValueMap();
        mismatchDescription.appendText("was Resource with properties ").appendValueList("[", ",", "]", this.convertArraysToStrings((Map<String, Object>)actualProperties).entrySet()).appendText(" (resource: ").appendValue((Object)item).appendText(")");
        if (this.firstMismatchPropertyName != null) {
            Object expectedValue = this.expectedProps.get(this.firstMismatchPropertyName);
            Object actualValue = actualProperties.get(this.firstMismatchPropertyName);
            mismatchDescription.appendText(System.lineSeparator());
            mismatchDescription.appendText("     First mismatch in property ").appendValue((Object)this.firstMismatchPropertyName).appendText(": expected ");
            ResourcePropertiesMatcher.appendValueAndType(mismatchDescription, expectedValue);
            mismatchDescription.appendText(" but was ");
            ResourcePropertiesMatcher.appendValueAndType(mismatchDescription, actualValue);
        }
    }

    private static void appendValueAndType(Description mismatchDescription, Object value) {
        if (value == null) {
            mismatchDescription.appendText("null");
        } else {
            mismatchDescription.appendText("value ").appendValue(value).appendText(" of type ").appendValue((Object)value.getClass().getName());
        }
    }

    private Map<String, Object> convertArraysToStrings(Map<String, Object> props) {
        TreeMap<String, Object> transformedProps = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            Object value = entry.getValue();
            if (value != null && value.getClass().isArray()) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object item;
                    if (i > 0) {
                        sb.append(",");
                    }
                    if ((item = Array.get(value, i)) == null) {
                        sb.append("null");
                        continue;
                    }
                    sb.append(item.toString());
                }
                sb.append("]");
                value = sb.toString();
            }
            transformedProps.put(entry.getKey(), value);
        }
        return transformedProps;
    }
}

