/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.sling.api.request.RequestParameter;

class MockRequestParameter
implements RequestParameter {
    private String name;
    private String encoding = "UTF-8";
    private String value;
    private String contentType;
    private boolean isFormField;
    private String filename;
    private byte[] content;

    public MockRequestParameter(String name, String value) {
        this.name = name;
        this.value = value;
        this.content = null;
        this.contentType = "text/plain";
        this.isFormField = true;
        this.filename = null;
    }

    public MockRequestParameter(String name, byte[] content, String contentType) {
        this.name = name;
        this.value = null;
        this.content = content;
        this.contentType = contentType;
        this.isFormField = false;
        this.filename = null;
    }

    public MockRequestParameter(String name, byte[] content, String contentType, String filename) {
        this.name = name;
        this.value = null;
        this.content = content;
        this.contentType = contentType;
        this.isFormField = false;
        this.filename = filename;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] get() {
        if (this.content == null && this.value != null) {
            try {
                this.content = this.getString().getBytes(this.getEncoding());
            }
            catch (Exception e) {
                this.content = this.getString().getBytes();
            }
        }
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.get());
    }

    public String getFileName() {
        return this.filename;
    }

    public long getSize() {
        return this.get().length;
    }

    public String getString() {
        return this.value == null && this.content != null ? new String(this.content) : this.value;
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public String toString() {
        return this.getString();
    }
}

