/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.wrappers.SlingJakartaHttpServletRequestWrapper;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.apache.sling.i18n.DefaultJakartaLocaleResolver;
import org.apache.sling.i18n.JakartaRequestLocaleResolver;
import org.apache.sling.i18n.LocaleResolver;
import org.apache.sling.i18n.RequestLocaleResolver;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.i18n.impl.LocaleResolverWrapper;
import org.apache.sling.i18n.impl.RequestLocaleResolverWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, property={"service.description=Internationalization Support Filter", "service.vendor=The Apache Software Foundation", "service.ranking:Integer=700", "sling.filter.scope=REQUEST", "sling.filter.scope=ERROR", "osgi.http.whiteboard.filter.pattern=/", "osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=*)"})
public class I18NFilter
implements Filter {
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final Logger LOG = LoggerFactory.getLogger((String)I18NFilter.class.getName());
    private final DefaultJakartaLocaleResolver defaultLocaleResolver = new DefaultJakartaLocaleResolver();
    private final JakartaRequestLocaleResolver[] localeResolvers = new JakartaRequestLocaleResolver[]{null, null, null};
    private JakartaRequestLocaleResolver requestLocaleResolver = this.defaultLocaleResolver;
    private final Map<Object, ResourceBundleProvider> providers = new TreeMap<Object, ResourceBundleProvider>();
    private volatile ResourceBundleProvider[] sortedProviders = new ResourceBundleProvider[0];
    private final ResourceBundleProvider combinedProvider = new CombinedBundleProvider();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request = request instanceof SlingJakartaHttpServletRequest ? new I18NSlingJakartaHttpServletRequest((ServletRequest)request, this.combinedProvider, this.requestLocaleResolver) : new I18NHttpServletRequest((ServletRequest)request, this.combinedProvider, this.requestLocaleResolver);
        chain.doFilter(request, response);
    }

    protected JakartaRequestLocaleResolver calculateBestLocaleResolver() {
        return Arrays.stream(this.localeResolvers).filter(Objects::nonNull).findFirst().orElse(this.defaultLocaleResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="3.0.0")
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindLocaleResolver(LocaleResolver resolver) {
        JakartaRequestLocaleResolver[] jakartaRequestLocaleResolverArray = this.localeResolvers;
        synchronized (this.localeResolvers) {
            this.localeResolvers[2] = new LocaleResolverWrapper(resolver);
            this.requestLocaleResolver = this.calculateBestLocaleResolver();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="3.0.0")
    protected void unbindLocaleResolver(LocaleResolver resolver) {
        JakartaRequestLocaleResolver[] jakartaRequestLocaleResolverArray = this.localeResolvers;
        synchronized (this.localeResolvers) {
            this.localeResolvers[2] = null;
            this.requestLocaleResolver = this.calculateBestLocaleResolver();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="3.0.0")
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindRequestLocaleResolver(RequestLocaleResolver resolver) {
        JakartaRequestLocaleResolver[] jakartaRequestLocaleResolverArray = this.localeResolvers;
        synchronized (this.localeResolvers) {
            this.localeResolvers[1] = new RequestLocaleResolverWrapper(resolver);
            this.requestLocaleResolver = this.calculateBestLocaleResolver();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="3.0.0")
    protected void unbindRequestLocaleResolver(RequestLocaleResolver resolver) {
        JakartaRequestLocaleResolver[] jakartaRequestLocaleResolverArray = this.localeResolvers;
        synchronized (this.localeResolvers) {
            this.localeResolvers[1] = null;
            this.requestLocaleResolver = this.calculateBestLocaleResolver();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindJakartaRequestLocaleResolver(JakartaRequestLocaleResolver resolver) {
        JakartaRequestLocaleResolver[] jakartaRequestLocaleResolverArray = this.localeResolvers;
        synchronized (this.localeResolvers) {
            this.localeResolvers[0] = resolver;
            this.requestLocaleResolver = this.calculateBestLocaleResolver();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindJakartaRequestLocaleResolver(JakartaRequestLocaleResolver resolver) {
        JakartaRequestLocaleResolver[] jakartaRequestLocaleResolverArray = this.localeResolvers;
        synchronized (this.localeResolvers) {
            this.localeResolvers[0] = null;
            this.requestLocaleResolver = this.calculateBestLocaleResolver();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=ResourceBundleProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindResourceBundleProvider(ResourceBundleProvider provider, Map<String, Object> props) {
        Map<Object, ResourceBundleProvider> map = this.providers;
        synchronized (map) {
            this.providers.put(ServiceUtil.getComparableForServiceRanking(props, Order.ASCENDING), provider);
            this.sortedProviders = this.providers.values().toArray(new ResourceBundleProvider[this.providers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindResourceBundleProvider(ResourceBundleProvider provider, Map<String, Object> props) {
        Map<Object, ResourceBundleProvider> map = this.providers;
        synchronized (map) {
            this.providers.remove(ServiceUtil.getComparableForServiceRanking(props, Order.ASCENDING), provider);
            this.sortedProviders = this.providers.values().toArray(new ResourceBundleProvider[this.providers.size()]);
        }
    }

    private static Locale defaultLocale(ResourceBundleProvider bundleProvider) {
        Locale defaultLocale = bundleProvider.getDefaultLocale();
        return defaultLocale != null ? defaultLocale : DEFAULT_LOCALE;
    }

    private class CombinedBundleProvider
    implements ResourceBundleProvider {
        private CombinedBundleProvider() {
        }

        @Override
        public Locale getDefaultLocale() {
            ResourceBundleProvider[] providers = I18NFilter.this.sortedProviders;
            for (int i = providers.length - 1; i >= 0; --i) {
                ResourceBundleProvider provider = providers[i];
                Locale locale = provider.getDefaultLocale();
                if (locale == null) continue;
                return locale;
            }
            return null;
        }

        @Override
        public ResourceBundle getResourceBundle(Locale locale) {
            ResourceBundleProvider[] providers = I18NFilter.this.sortedProviders;
            for (int i = providers.length - 1; i >= 0; --i) {
                ResourceBundleProvider provider = providers[i];
                ResourceBundle bundle = provider.getResourceBundle(locale);
                if (bundle == null) continue;
                return bundle;
            }
            return null;
        }

        @Override
        public ResourceBundle getResourceBundle(String baseName, Locale locale) {
            ResourceBundleProvider[] providers = I18NFilter.this.sortedProviders;
            for (int i = providers.length - 1; i >= 0; --i) {
                ResourceBundleProvider provider = providers[i];
                ResourceBundle bundle = provider.getResourceBundle(baseName, locale);
                if (bundle == null) continue;
                return bundle;
            }
            return null;
        }
    }

    private static class I18NSlingJakartaHttpServletRequest
    extends SlingJakartaHttpServletRequestWrapper {
        private final ResourceBundleProvider bundleProvider;
        private final JakartaRequestLocaleResolver localeResolver;
        private Locale locale;
        private List<Locale> localeList;

        I18NSlingJakartaHttpServletRequest(ServletRequest delegatee, ResourceBundleProvider bundleProvider, JakartaRequestLocaleResolver localeResolver) {
            super((SlingJakartaHttpServletRequest)delegatee);
            this.bundleProvider = bundleProvider;
            this.localeResolver = localeResolver;
        }

        public ResourceBundle getResourceBundle(Locale locale) {
            return this.getResourceBundle(null, locale);
        }

        public ResourceBundle getResourceBundle(String baseName, Locale locale) {
            if (this.bundleProvider != null) {
                if (locale == null) {
                    locale = this.getLocale();
                }
                try {
                    return this.bundleProvider.getResourceBundle(baseName, locale);
                }
                catch (MissingResourceException mre) {
                    LOG.warn("getResourceBundle: Cannot get ResourceBundle from provider", (Throwable)mre);
                }
            } else {
                LOG.info("getResourceBundle: ResourceBundleProvider not available, calling default implementation");
            }
            return super.getResourceBundle(baseName, locale);
        }

        public Object getAttribute(String name) {
            if ("org.apache.sling.i18n.resourcebundle".equals(name)) {
                Object superValue = super.getAttribute(name);
                return superValue != null ? superValue : this.getResourceBundle(null);
            }
            return super.getAttribute(name);
        }

        public Locale getLocale() {
            if (this.locale == null) {
                this.locale = this.getLocaleList().get(0);
            }
            return this.locale;
        }

        public Enumeration<Locale> getLocales() {
            return Collections.enumeration(this.getLocaleList());
        }

        private List<Locale> getLocaleList() {
            if (this.localeList == null) {
                List<Locale> resolved = this.localeResolver.resolveLocale((HttpServletRequest)this.getSlingRequest());
                this.localeList = resolved != null && !resolved.isEmpty() ? resolved : Collections.singletonList(I18NFilter.defaultLocale(this.bundleProvider));
            }
            return this.localeList;
        }
    }

    private static class I18NHttpServletRequest
    extends HttpServletRequestWrapper {
        private final ResourceBundleProvider bundleProvider;
        private final JakartaRequestLocaleResolver localeResolver;
        private Locale locale;
        private List<Locale> localeList;
        private ResourceBundle resourceBundle;

        I18NHttpServletRequest(ServletRequest delegatee, ResourceBundleProvider bundleProvider, JakartaRequestLocaleResolver localeResolver) {
            super((HttpServletRequest)delegatee);
            this.bundleProvider = bundleProvider;
            this.localeResolver = localeResolver;
        }

        public Locale getLocale() {
            if (this.locale == null) {
                this.locale = this.getLocaleList().get(0);
            }
            return this.locale;
        }

        public Enumeration<Locale> getLocales() {
            return Collections.enumeration(this.getLocaleList());
        }

        public Object getAttribute(String name) {
            if ("org.apache.sling.i18n.resourcebundle".equals(name)) {
                if (this.resourceBundle == null && this.bundleProvider != null) {
                    this.resourceBundle = this.bundleProvider.getResourceBundle(this.getLocale());
                }
                return this.resourceBundle;
            }
            return super.getAttribute(name);
        }

        private List<Locale> getLocaleList() {
            if (this.localeList == null) {
                List<Locale> resolved = this.localeResolver.resolveLocale((HttpServletRequest)this.getRequest());
                this.localeList = resolved != null && !resolved.isEmpty() ? resolved : Collections.singletonList(I18NFilter.defaultLocale(this.bundleProvider));
            }
            return this.localeList;
        }
    }
}

