/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.lock;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.SessionListener;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.config.CacheBehaviour;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.lock.LockStateManager;
import org.apache.jackrabbit.jcr2spi.operation.LockOperation;
import org.apache.jackrabbit.jcr2spi.operation.LockRefresh;
import org.apache.jackrabbit.jcr2spi.operation.LockRelease;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManagerImpl
implements LockStateManager,
SessionListener {
    private static Logger log = LoggerFactory.getLogger(LockManagerImpl.class);
    private static final long TIMEOUT_EXPIRED = -1L;
    private static final long TIMEOUT_INFINITE = Long.MAX_VALUE;
    private final WorkspaceManager wspManager;
    private final ItemManager itemManager;
    private final CacheBehaviour cacheBehaviour;
    private final Map<NodeState, LockImpl> lockMap;

    public LockManagerImpl(WorkspaceManager wspManager, ItemManager itemManager, CacheBehaviour cacheBehaviour) {
        this.wspManager = wspManager;
        this.itemManager = itemManager;
        this.cacheBehaviour = cacheBehaviour;
        this.lockMap = new HashMap<NodeState, LockImpl>();
    }

    @Override
    public Lock lock(NodeState nodeState, boolean isDeep, boolean isSessionScoped) throws LockException, RepositoryException {
        return this.lock(nodeState, isDeep, isSessionScoped, Long.MAX_VALUE, null);
    }

    @Override
    public Lock lock(NodeState nodeState, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerHint) throws RepositoryException {
        Item item = this.itemManager.getItem(nodeState.getHierarchyEntry());
        if (!item.isNode()) {
            throw new RepositoryException("Internal error: ItemManager returned Property from NodeState");
        }
        Node lhNode = (Node)item;
        LockOperation op = LockOperation.create(nodeState, isDeep, isSessionScoped, timeoutHint, ownerHint);
        this.wspManager.execute(op);
        LockImpl lock = new LockImpl(new LockState(nodeState, op.getLockInfo()), lhNode);
        return lock;
    }

    @Override
    public void unlock(NodeState nodeState) throws LockException, RepositoryException {
        Operation op = LockRelease.create(nodeState);
        this.wspManager.execute(op);
        if (this.lockMap.containsKey(nodeState)) {
            LockImpl l = this.lockMap.remove(nodeState);
            l.lockState.unlocked();
        }
    }

    @Override
    public Lock getLock(NodeState nodeState) throws LockException, RepositoryException {
        LockImpl l = this.getLockImpl(nodeState, false);
        if (l == null) {
            throw new LockException("Node with id '" + nodeState.getNodeId() + "' is not locked.");
        }
        return l;
    }

    @Override
    public boolean isLocked(NodeState nodeState) throws RepositoryException {
        LockImpl l = this.getLockImpl(nodeState, false);
        return l != null;
    }

    @Override
    public void checkLock(NodeState nodeState) throws LockException, RepositoryException {
        if (nodeState.getStatus() == 4) {
            return;
        }
        LockImpl l = this.getLockImpl(nodeState, true);
        if (l != null && !l.isLockOwningSession()) {
            throw new LockException("Node with id '" + nodeState + "' is locked.");
        }
    }

    @Override
    public String[] getLockTokens() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.wspManager.getLockTokens();
    }

    @Override
    public void addLockToken(String lt) throws LockException, RepositoryException {
        this.wspManager.addLockToken(lt);
        this.notifyTokenAdded(lt);
    }

    @Override
    public void removeLockToken(String lt) throws LockException, RepositoryException {
        Iterator<LockImpl> it = this.lockMap.values().iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            LockImpl l = it.next();
            if (!lt.equals(l.getLockToken())) continue;
            found = true;
            if (!l.isSessionScoped()) continue;
            throw new LockException("Cannot remove lock token associated with a session scoped lock.");
        }
        this.wspManager.removeLockToken(lt);
        this.notifyTokenRemoved(lt);
    }

    @Override
    public void loggingOut(Session session) {
        NodeState[] lhStates;
        for (NodeState nState : lhStates = this.lockMap.keySet().toArray(new NodeState[this.lockMap.size()])) {
            LockImpl l = this.lockMap.get(nState);
            if (!l.isSessionScoped() || !l.isLockOwningSession()) continue;
            try {
                this.unlock(nState);
            }
            catch (RepositoryException e) {
                log.warn("Error while unlocking session scoped lock. Cleaning up local lock status.");
                l.lockState.unlocked();
            }
        }
    }

    @Override
    public void loggedOut(Session session) {
        LockImpl[] locks;
        for (LockImpl lock : locks = this.lockMap.values().toArray(new LockImpl[this.lockMap.size()])) {
            lock.lockState.release();
        }
    }

    private NodeState getLockHoldingState(NodeState nodeState) {
        NodeEntry entry = nodeState.getNodeEntry();
        while (!entry.hasPropertyEntry(NameConstants.JCR_LOCKISDEEP)) {
            NodeEntry parent = entry.getParent();
            if (parent == null) {
                return null;
            }
            entry = parent;
        }
        try {
            return entry.getNodeState();
        }
        catch (RepositoryException e) {
            log.warn("Error while accessing lock holding NodeState: {}", (Object)e.getMessage());
            return null;
        }
    }

    private LockState buildLockState(NodeState nodeState) throws RepositoryException {
        NodeState lockHoldingState;
        NodeId nId = nodeState.getNodeId();
        LockInfo lockInfo = this.wspManager.getLockInfo(nId);
        if (lockInfo == null) {
            return null;
        }
        NodeId lockNodeId = lockInfo.getNodeId();
        if (lockNodeId.equals(nId)) {
            lockHoldingState = nodeState;
        } else {
            NodeEntry lockedEntry = this.wspManager.getHierarchyManager().getNodeEntry(lockNodeId);
            try {
                lockHoldingState = lockedEntry.getNodeState();
            }
            catch (RepositoryException e) {
                log.warn("Cannot build LockState");
                throw new RepositoryException("Cannot build LockState", e);
            }
        }
        if (lockHoldingState == null) {
            return null;
        }
        return new LockState(lockHoldingState, lockInfo);
    }

    private LockImpl getLockImpl(NodeState nodeState, boolean lazyLockDiscovery) throws RepositoryException {
        LockState lState;
        NodeState nState = nodeState;
        while (nState.getStatus() == 4) {
            nState = nState.getParent();
        }
        LockImpl l = this.getLockFromMap(nState);
        if (l != null && l.lockState.appliesToNodeState(nodeState)) {
            return l;
        }
        if (lazyLockDiscovery) {
            NodeState lockHoldingState = this.getLockHoldingState(nState);
            if (lockHoldingState == null) {
                return null;
            }
            l = this.getLockFromMap(nState);
            if (l != null) {
                return l;
            }
            lState = this.buildLockState(lockHoldingState);
        } else {
            lState = this.buildLockState(nState);
        }
        if (lState != null) {
            LockImpl lock = this.getLockFromMap(lState.lockHoldingState);
            if (lock != null) {
                lock.lockState.setLockInfo(lState.lockInfo);
            } else {
                Item lockHoldingNode = this.itemManager.getItem(lState.lockHoldingState.getHierarchyEntry());
                lock = new LockImpl(lState, (Node)lockHoldingNode);
            }
            if (lState.appliesToNodeState(nodeState)) {
                return lock;
            }
            return null;
        }
        return null;
    }

    private LockImpl getLockFromMap(NodeState nodeState) {
        try {
            LockImpl l = this.lockMap.get(nodeState);
            if (l != null && l.isLive()) {
                return l;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    private void notifyTokenAdded(String lt) throws RepositoryException {
        LockTokenListener[] listeners;
        for (LockTokenListener listener : listeners = this.lockMap.values().toArray(new LockTokenListener[this.lockMap.size()])) {
            listener.lockTokenAdded(lt);
        }
    }

    private void notifyTokenRemoved(String lt) throws RepositoryException {
        LockTokenListener[] listeners;
        for (LockTokenListener listener : listeners = this.lockMap.values().toArray(new LockTokenListener[this.lockMap.size()])) {
            listener.lockTokenRemoved(lt);
        }
    }

    private static interface LockTokenListener {
        public void lockTokenAdded(String var1) throws RepositoryException;

        public void lockTokenRemoved(String var1) throws RepositoryException;
    }

    private class LockImpl
    implements Lock,
    LockTokenListener {
        private final LockState lockState;
        private final Node node;
        private boolean reloadInfo = false;

        public LockImpl(LockState lockState, Node lockHoldingNode) {
            this.lockState = lockState;
            this.node = lockHoldingNode;
            if (LockManagerImpl.this.cacheBehaviour == CacheBehaviour.OBSERVATION) {
                LockManagerImpl.this.lockMap.put(lockState.lockHoldingState, this);
                lockState.startListening();
            } else if (lockState.lockInfo.isLockOwner()) {
                LockManagerImpl.this.lockMap.put(lockState.lockHoldingState, this);
                lockState.startListening();
                if (!this.isSessionScoped()) {
                    this.reloadInfo = true;
                }
            } else {
                this.reloadInfo = true;
            }
        }

        @Override
        public String getLockOwner() {
            LockInfo info = this.getLockInfo();
            if (info != null) {
                return info.getOwner();
            }
            return null;
        }

        @Override
        public boolean isDeep() {
            LockInfo info = this.getLockInfo();
            return info != null && info.isDeep();
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public String getLockToken() {
            if (this.isSessionScoped()) {
                return null;
            }
            this.updateLockInfo();
            LockInfo info = this.getLockInfo();
            if (info != null) {
                return info.getLockToken();
            }
            return null;
        }

        @Override
        public boolean isLive() throws RepositoryException {
            this.updateLockInfo();
            return this.lockState.isLive();
        }

        @Override
        public boolean isSessionScoped() {
            LockInfo info = this.getLockInfo();
            return info != null && info.isSessionScoped();
        }

        @Override
        public void refresh() throws LockException, RepositoryException {
            if (!this.isLive()) {
                throw new LockException("Lock is not alive any more.");
            }
            if (!this.isLockOwningSession()) {
                throw new LockException("Session does not hold lock.");
            }
            this.lockState.refresh();
        }

        @Override
        public long getSecondsRemaining() throws RepositoryException {
            this.updateLockInfo();
            return this.lockState.getSecondsRemaining();
        }

        @Override
        public boolean isLockOwningSession() {
            LockInfo info = this.getLockInfo();
            return info != null && info.isLockOwner();
        }

        @Override
        public void lockTokenAdded(String lockToken) throws RepositoryException {
            if (!this.isSessionScoped() && !this.isLockOwningSession()) {
                this.lockState.reloadLockInfo();
            }
        }

        @Override
        public void lockTokenRemoved(String lockToken) throws RepositoryException {
            if (lockToken.equals(this.getLockToken())) {
                this.lockState.reloadLockInfo();
            }
        }

        private LockInfo getLockInfo() {
            return this.lockState.lockInfo;
        }

        private void updateLockInfo() {
            if (this.reloadInfo) {
                try {
                    this.lockState.reloadLockInfo();
                }
                catch (RepositoryException e) {
                    log.warn("Unable to determine lock status. {}", (Object)e.getMessage());
                }
            }
        }
    }

    private class LockState
    implements ItemStateLifeCycleListener {
        private final NodeState lockHoldingState;
        private LockInfo lockInfo;
        private boolean isLive = true;
        private long expiration = Long.MAX_VALUE;

        private LockState(NodeState lockHoldingState, LockInfo lockInfo) {
            this.lockHoldingState = lockHoldingState;
            this.setLockInfo(lockInfo);
        }

        private void refresh() throws RepositoryException {
            Operation op = LockRefresh.create(this.lockHoldingState);
            LockManagerImpl.this.wspManager.execute(op);
        }

        private boolean appliesToNodeState(NodeState nodeState) {
            if (nodeState.getStatus() == 4) {
                return this.lockInfo.isDeep();
            }
            if (this.lockHoldingState == nodeState) {
                return true;
            }
            return this.lockInfo != null && this.lockInfo.isDeep();
        }

        private void reloadLockInfo() throws RepositoryException {
            NodeId nId = this.lockHoldingState.getNodeEntry().getWorkspaceId();
            this.lockInfo = LockManagerImpl.this.wspManager.getLockInfo(nId);
            if (this.lockInfo == null) {
                this.unlocked();
            }
        }

        private void setLockInfo(LockInfo lockInfo) {
            this.lockInfo = lockInfo;
            long seconds = lockInfo.getSecondsRemaining();
            if (seconds <= -1L) {
                this.expiration = -1L;
                this.isLive = false;
            } else {
                this.expiration = seconds < Long.MAX_VALUE ? new Date().getTime() / 1000L + lockInfo.getSecondsRemaining() : Long.MAX_VALUE;
            }
        }

        private boolean isLive() {
            if (this.isLive) {
                this.isLive = this.getSecondsRemaining() > 0L;
            }
            return this.isLive;
        }

        private long getSecondsRemaining() {
            if (!this.isLive) {
                return -1L;
            }
            if (this.expiration == Long.MAX_VALUE) {
                return this.expiration;
            }
            long seconds = this.expiration - new Date().getTime() / 1000L;
            if (seconds <= 0L) {
                this.isLive = false;
                return -1L;
            }
            return seconds;
        }

        private void release() {
            if (LockManagerImpl.this.lockMap.containsKey(this.lockHoldingState)) {
                LockManagerImpl.this.lockMap.remove(this.lockHoldingState);
            }
            this.stopListening();
        }

        private void unlocked() {
            if (this.isLive()) {
                this.release();
                this.isLive = false;
            }
        }

        private void startListening() {
            this.lockHoldingState.addListener(this);
            if (LockManagerImpl.this.cacheBehaviour == CacheBehaviour.OBSERVATION) {
                try {
                    if (!this.lockHoldingState.hasPropertyName(NameConstants.JCR_LOCKISDEEP)) {
                        LockManagerImpl.this.itemManager.getItem(this.lockHoldingState.getNodeEntry());
                    }
                    PropertyState ps = this.lockHoldingState.getPropertyState(NameConstants.JCR_LOCKISDEEP);
                    ps.addListener(this);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to retrieve jcr:isDeep property after lock creation. {}", (Object)e.getMessage());
                }
            }
        }

        private void stopListening() {
            this.lockHoldingState.removeListener(this);
            if (LockManagerImpl.this.cacheBehaviour == CacheBehaviour.OBSERVATION) {
                try {
                    if (this.lockHoldingState.hasPropertyName(NameConstants.JCR_LOCKISDEEP)) {
                        PropertyState ps = this.lockHoldingState.getPropertyState(NameConstants.JCR_LOCKISDEEP);
                        ps.removeListener(this);
                    }
                }
                catch (ItemNotFoundException e) {
                    log.debug("jcr:lockIsDeep doesn't exist any more.");
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
            }
        }

        @Override
        public void statusChanged(ItemState state, int previousStatus) {
            if (!this.isLive()) {
                return;
            }
            switch (state.getStatus()) {
                case 8: {
                    this.unlocked();
                    break;
                }
            }
        }
    }
}

