/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.httpclient.v5.wrapper;

import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.skywalking.apm.agent.core.context.ContextManager;

public class FutureCallbackWrapper<T>
implements FutureCallback<T> {
    private FutureCallback<T> callback;

    public FutureCallbackWrapper(FutureCallback<T> callback) {
        this.callback = callback;
    }

    public void completed(T o) {
        if (ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        if (this.callback != null) {
            this.callback.completed(o);
        }
    }

    public void failed(Exception e) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().errorOccurred().log((Throwable)e);
            ContextManager.stopSpan();
        }
        if (this.callback != null) {
            this.callback.failed(e);
        }
    }

    public void cancelled() {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().errorOccurred();
            ContextManager.stopSpan();
        }
        if (this.callback != null) {
            this.callback.cancelled();
        }
    }
}

