/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cache.cache;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.dto.convert.selector.CacheUpstream;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.cache.ICache;
import org.apache.shenyu.plugin.cache.ICacheBuilder;
import org.apache.shenyu.spi.ExtensionLoader;

public class ApplicationConfigCache {
    private static final Map<String, CacheUpstream> UPSTREAM_CACHE_MAP = Maps.newConcurrentMap();
    private static final Map<String, ICache> CONFIG_CACHE_MAP = Maps.newConcurrentMap();

    public ICache init(String selectorId, CacheUpstream cacheUpstream) {
        String config = GsonUtils.getInstance().toJson((Object)cacheUpstream);
        ICacheBuilder cacheBuilder = (ICacheBuilder)ExtensionLoader.getExtensionLoader(ICacheBuilder.class).getJoin(cacheUpstream.getCacheType());
        ICache cache = cacheBuilder.builderCache(config);
        CONFIG_CACHE_MAP.put(selectorId, cache);
        UPSTREAM_CACHE_MAP.put(selectorId, cacheUpstream);
        return cache;
    }

    public ICache get(String path) {
        return CONFIG_CACHE_MAP.get(path);
    }

    public CacheUpstream getUpstream(String path) {
        return UPSTREAM_CACHE_MAP.get(path);
    }

    public void invalidateCache(String path) {
        ICache cache = CONFIG_CACHE_MAP.get(path);
        if (!Objects.isNull(cache)) {
            cache.close();
            CONFIG_CACHE_MAP.remove(path);
            UPSTREAM_CACHE_MAP.remove(path);
        }
    }

    public void invalidateAll() {
        if (CONFIG_CACHE_MAP.isEmpty()) {
            return;
        }
        CONFIG_CACHE_MAP.forEach((key, cache) -> {
            try {
                if (!Objects.isNull(cache)) {
                    cache.close();
                }
            }
            catch (Exception e) {
                ShenyuPlugin.LOG.error("Failed to close upstream {}", key, (Object)e);
            }
        });
        UPSTREAM_CACHE_MAP.clear();
        CONFIG_CACHE_MAP.clear();
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    static final class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

