/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseDataUpdater;
import com.clickhouse.client.ClickHouseFile;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;

public abstract class AbstractByteArrayInputStream
extends ClickHouseInputStream {
    protected byte[] buffer = ClickHouseByteBuffer.EMPTY_BYTES;
    protected int position = 0;
    protected int limit = this.buffer.length;

    protected AbstractByteArrayInputStream(ClickHouseFile file, OutputStream copyTo, Runnable postCloseAction) {
        super(file, copyTo, postCloseAction);
    }

    @Override
    protected void ensureOpen() throws IOException {
        super.ensureOpen();
        if (this.position >= this.limit) {
            this.updateBuffer();
        }
    }

    protected abstract int updateBuffer() throws IOException;

    @Override
    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        int remain = this.limit - this.position;
        return remain > 0 ? remain : this.updateBuffer();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer = ClickHouseByteBuffer.EMPTY_BYTES;
        super.close();
    }

    @Override
    public int peek() throws IOException {
        this.ensureOpen();
        return this.position < this.limit ? 0xFF & this.buffer[this.position] : -1;
    }

    @Override
    public long pipe(ClickHouseOutputStream output) throws IOException {
        long count = 0L;
        if (output == null || output.isClosed()) {
            return count;
        }
        this.ensureOpen();
        byte[] b = this.buffer;
        int l = this.limit;
        int p = this.position;
        int remain = l - p;
        if (remain > 0) {
            output.transferBytes(b, p, remain);
            count += (long)remain;
            while ((remain = this.updateBuffer()) > 0) {
                b = this.buffer;
                output.transferBytes(b, 0, remain);
                count += (long)remain;
            }
        }
        this.close();
        return count;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.position < this.limit ? 0xFF & this.buffer[this.position++] : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Non-null byte array is required");
        }
        if (this.buffer == b) {
            throw new IllegalArgumentException("Please pass a different byte array instead of the same internal buffer for reading");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.ensureOpen();
        int remain = this.limit - this.position;
        if (remain < 1) {
            return -1;
        }
        if (remain >= len) {
            System.arraycopy(this.buffer, this.position, b, off, len);
            this.position += len;
            return len;
        }
        System.arraycopy(this.buffer, this.position, b, off, remain);
        off += remain;
        len -= remain;
        int count = remain;
        while (len > 0 && (remain = this.updateBuffer()) > 0) {
            if (remain >= len) {
                System.arraycopy(this.buffer, this.position, b, off, len);
                this.position += len;
                return count + len;
            }
            System.arraycopy(this.buffer, this.position, b, off, remain);
            off += remain;
            len -= remain;
            count += remain;
        }
        return count;
    }

    @Override
    public ClickHouseByteBuffer readBuffer(int length) throws IOException {
        if (length < 1) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        if (this.position >= this.limit) {
            this.closeQuietly();
            throw new EOFException();
        }
        int newLimit = this.position + length;
        if (this.limit >= newLimit) {
            this.byteBuffer.update(this.buffer, this.position, length);
            this.position = newLimit;
        } else {
            this.byteBuffer.update(this.readBytes(length));
        }
        return this.byteBuffer;
    }

    @Override
    public ClickHouseByteBuffer readCustom(ClickHouseDataUpdater reader) throws IOException {
        if (reader == null) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int offset = this.position;
        int length = 0;
        boolean more = true;
        while (more) {
            int remain = this.limit - this.position;
            if (remain < 1) {
                this.closeQuietly();
                more = false;
                continue;
            }
            int read = reader.update(this.buffer, this.position, this.limit);
            if (read == -1) {
                length += remain;
                this.position = this.limit;
                list.add(this.buffer);
                if (this.updateBuffer() >= 1) continue;
                this.closeQuietly();
                more = false;
                continue;
            }
            if (read > 0) {
                length += read;
                this.position += read;
                list.add(this.buffer);
            }
            more = false;
        }
        return this.byteBuffer.update(list, offset, length);
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureOpen();
        if (this.position >= this.limit) {
            this.closeQuietly();
            throw new EOFException();
        }
        return this.buffer[this.position++];
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        if (length < 1) {
            return ClickHouseByteBuffer.EMPTY_BYTES;
        }
        this.ensureOpen();
        byte[] bytes = new byte[length];
        byte[] b = this.buffer;
        int count = 0;
        int l = this.limit;
        int p = this.position;
        int remain = l - p;
        while (length > 0) {
            if (remain < 1) {
                this.closeQuietly();
                throw count == 0 ? new EOFException() : new IOException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", count, bytes.length));
            }
            if (remain >= length) {
                System.arraycopy(b, p, bytes, count, length);
                this.position = p + length;
                count += length;
                length = 0;
                continue;
            }
            System.arraycopy(b, p, bytes, count, remain);
            count += remain;
            length -= remain;
            remain = this.updateBuffer();
            p = this.position;
            b = this.buffer;
        }
        return bytes;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n == Long.MAX_VALUE) {
            int avail = 0;
            long counter = (long)this.limit - (long)this.position;
            while ((avail = this.updateBuffer()) > 0) {
                counter += (long)avail;
            }
            return counter;
        }
        return super.skip(n);
    }
}

