/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.annotation;

import java.util.List;
import java.util.Set;
import org.apache.dubbo.metadata.rest.ArgInfo;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.rest.annotation.ParamParser;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer.BaseConsumerParamParser;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.consumer.ConsumerParseContext;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider.BaseProviderParamParser;
import org.apache.dubbo.rpc.protocol.rest.annotation.param.parse.provider.ProviderParseContext;

public class ParamParserManager {
    private static final Set<BaseConsumerParamParser> consumerParamParsers = FrameworkModel.defaultModel().getExtensionLoader(BaseConsumerParamParser.class).getSupportedExtensionInstances();
    private static final Set<BaseProviderParamParser> providerParamParsers = FrameworkModel.defaultModel().getExtensionLoader(BaseProviderParamParser.class).getSupportedExtensionInstances();

    public static Object[] providerParamParse(ProviderParseContext parseContext) {
        List<ArgInfo> args = parseContext.getArgInfos();
        for (int i = 0; i < args.size(); ++i) {
            for (ParamParser paramParser : providerParamParsers) {
                paramParser.parse(parseContext, args.get(i));
            }
        }
        return parseContext.getArgs().toArray(new Object[0]);
    }

    public static void consumerParamParse(ConsumerParseContext parseContext) {
        List<ArgInfo> argInfos = parseContext.getArgInfos();
        for (int i = 0; i < argInfos.size(); ++i) {
            for (BaseConsumerParamParser paramParser : consumerParamParsers) {
                ArgInfo argInfoByIndex;
                if (!paramParser.paramTypeMatch(argInfoByIndex = parseContext.getArgInfoByIndex(i))) continue;
                paramParser.parse(parseContext, argInfoByIndex);
            }
        }
    }
}

