/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.polaris;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class PolarisRegistryProperties {
    private final Map<String, String> registryParameters;

    public PolarisRegistryProperties(Map<String, String> registryParameters) {
        if (registryParameters == null) {
            registryParameters = Collections.emptyMap();
        }
        this.registryParameters = registryParameters;
    }

    public String getConnectorProtocol() {
        return this.getString("connector.protocol", "grpc");
    }

    public int getHealthCheckTTL() {
        return this.getInt("healthCheck.ttl", 10);
    }

    public int getHeartbeatInterval() {
        return this.getInt("heartbeat.interval", 3000);
    }

    public int getHeartbeatCoreSize() {
        return this.getInt("heartbeat.coreSize", 1);
    }

    public int getLookupInterval() {
        return this.getInt("lookup.interval", 1000);
    }

    private int getInt(String key, int defaultValue) {
        return this.get(key, Integer::parseInt, defaultValue);
    }

    private String getString(String key, String defaultValue) {
        return this.get(key, Function.identity(), defaultValue);
    }

    private <T> T get(String key, Function<String, T> transform, T defaultValue) {
        String value = this.registryParameters.get(key);
        if (value != null) {
            return transform.apply(value);
        }
        return defaultValue;
    }
}

