/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.message.bolt;

import com.alipay.remoting.RejectedExecutionPolicy;
import com.alipay.remoting.RejectionProcessableInvokeCallback;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.BaggageResolver;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;

public abstract class AbstractInvokeCallback
implements RejectionProcessableInvokeCallback {
    protected final ConsumerConfig consumerConfig;
    protected final ProviderInfo providerInfo;
    protected final SofaRequest request;
    protected ClassLoader classLoader;
    protected RpcInternalContext context;
    protected RejectedExecutionPolicy rejectedExecutionPolicy;

    protected AbstractInvokeCallback(ConsumerConfig consumerConfig, ProviderInfo providerInfo, SofaRequest request, RpcInternalContext context, ClassLoader classLoader) {
        this.consumerConfig = consumerConfig;
        this.providerInfo = providerInfo;
        this.request = request;
        this.context = context;
        this.classLoader = classLoader;
        this.setRejectedExecutionPolicy(consumerConfig);
    }

    private void setRejectedExecutionPolicy(ConsumerConfig consumerConfig) {
        if (null == consumerConfig || consumerConfig.getRejectedExecutionPolicy() == null) {
            this.rejectedExecutionPolicy = RejectedExecutionPolicy.DISCARD;
            return;
        }
        String policy = consumerConfig.getRejectedExecutionPolicy();
        this.rejectedExecutionPolicy = RejectedExecutionPolicy.valueOf((String)policy);
    }

    protected void recordClientElapseTime() {
        Long startTime;
        if (this.context != null && (startTime = (Long)this.context.removeAttachment("_client_send_time")) != null) {
            this.context.setAttachment("_client_elapse", RpcRuntimeContext.now() - startTime);
        }
    }

    protected void pickupBaggage(SofaResponse response) {
        if (RpcInvokeContext.isBaggageEnable()) {
            RpcInvokeContext old = null;
            RpcInvokeContext newContext = null;
            if (this.context != null) {
                old = (RpcInvokeContext)this.context.getAttachment(".invoke_ctx");
            }
            if (old == null) {
                newContext = RpcInvokeContext.getContext();
            } else {
                RpcInvokeContext.setContext(old);
                newContext = RpcInvokeContext.getContext();
            }
            BaggageResolver.pickupFromResponse(newContext, response);
            if (old != null) {
                old.getAllResponseBaggage().putAll(newContext.getAllResponseBaggage());
                old.getAllRequestBaggage().putAll(newContext.getAllRequestBaggage());
            }
        }
    }

    public RejectedExecutionPolicy rejectedExecutionPolicy() {
        return this.rejectedExecutionPolicy;
    }
}

