/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.register.AbstractContextPathRegisterService;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.convert.rule.impl.WebSocketRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.WebSocketUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.PluginNameAdapter;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class ShenyuClientRegisterWebSocketServiceImpl
extends AbstractContextPathRegisterService {
    @Override
    public String rpcType() {
        return RpcTypeEnum.WEB_SOCKET.getName();
    }

    @Override
    protected String selectorHandler(MetaDataRegisterDTO metaDataDTO) {
        return "";
    }

    @Override
    protected String ruleHandler() {
        return new WebSocketRuleHandle().toJson();
    }

    @Override
    protected void registerMetadata(MetaDataRegisterDTO dto) {
        if (dto.isRegisterMetaData()) {
            MetaDataService metaDataService = this.getMetaDataService();
            MetaDataDO exist = metaDataService.findByPathAndNamespaceId(dto.getPath(), dto.getNamespaceId());
            metaDataService.saveOrUpdateMetaData(exist, dto);
        }
    }

    @Override
    protected String buildHandle(List<URIRegisterDTO> uriList, SelectorDO selectorDO) {
        String handleAdd;
        List<WebSocketUpstream> addList = this.buildWebSocketUpstreamList(uriList);
        List<Object> canAddList = new CopyOnWriteArrayList();
        List existList = GsonUtils.getInstance().fromCurrentList(selectorDO.getHandle(), WebSocketUpstream.class);
        if (CollectionUtils.isEmpty((Collection)existList)) {
            handleAdd = GsonUtils.getInstance().toJson(addList);
            canAddList = addList;
        } else {
            List diffList = addList.stream().filter(divideUpstream -> !existList.contains(divideUpstream)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(diffList)) {
                canAddList.addAll(diffList);
                existList.addAll(diffList);
            }
            handleAdd = GsonUtils.getInstance().toJson((Object)existList);
        }
        this.doSubmit(selectorDO.getId(), canAddList);
        return handleAdd;
    }

    private List<WebSocketUpstream> buildWebSocketUpstreamList(List<URIRegisterDTO> uriList) {
        return uriList.stream().map(dto -> CommonUpstreamUtils.buildWebSocketUpstream(dto.getProtocol(), dto.getHost(), dto.getPort(), dto.getNamespaceId())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }

    @Override
    public String offline(String selectorName, List<URIRegisterDTO> offlineList, String namespaceId) {
        String pluginName = PluginNameAdapter.rpcTypeAdapter((String)this.rpcType());
        SelectorService selectorService = this.getSelectorService();
        SelectorDO selectorDO = selectorService.findByNameAndPluginNameAndNamespaceId(selectorName, pluginName, namespaceId);
        if (Objects.isNull(selectorDO)) {
            return "success";
        }
        List validOfflineUrl = offlineList.stream().filter(dto -> Objects.nonNull(dto.getPort()) && StringUtils.isNotBlank((CharSequence)dto.getHost())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(validOfflineUrl)) {
            for (URIRegisterDTO offlineUrl : validOfflineUrl) {
                WebSocketUpstream webSocketUpstream = CommonUpstreamUtils.buildWebSocketUpstream(offlineUrl.getProtocol(), offlineUrl.getHost(), offlineUrl.getPort(), offlineUrl.getNamespaceId());
                this.removeDiscoveryUpstream(selectorDO.getId(), webSocketUpstream.getUrl());
            }
            DiscoverySyncData discoverySyncData = this.fetch(selectorDO.getId(), selectorDO.getSelectorName(), pluginName, selectorDO.getNamespaceId());
            this.getEventPublisher().publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.UPDATE, Collections.singletonList(discoverySyncData)));
        }
        return "success";
    }
}

