/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.sbom;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.sbom.SbomProperties;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

@Endpoint(id="sbom")
@ImportRuntimeHints(value={SbomEndpointRuntimeHints.class})
public class SbomEndpoint {
    private static final List<String> DEFAULT_APPLICATION_SBOM_LOCATIONS = List.of("classpath:META-INF/sbom/bom.json", "classpath:META-INF/sbom/application.cdx.json");
    static final String APPLICATION_SBOM_ID = "application";
    private final SbomProperties properties;
    private final ResourceLoader resourceLoader;
    private final Map<String, Resource> sboms;

    public SbomEndpoint(SbomProperties properties, ResourceLoader resourceLoader) {
        this.properties = properties;
        this.resourceLoader = resourceLoader;
        this.sboms = Collections.unmodifiableMap(this.getSboms());
    }

    private Map<String, Resource> getSboms() {
        HashMap<String, Resource> result = new HashMap<String, Resource>();
        this.addKnownSboms(result);
        this.addAdditionalSboms(result);
        return result;
    }

    private void addAdditionalSboms(Map<String, Resource> result) {
        this.properties.getAdditional().forEach((id, sbom) -> {
            Resource resource = this.loadResource(sbom.getLocation());
            if (resource != null && result.putIfAbsent((String)id, resource) != null) {
                throw new IllegalStateException("Duplicate SBOM registration with id '%s'".formatted(id));
            }
        });
    }

    private void addKnownSboms(Map<String, Resource> result) {
        Resource applicationSbom = this.getApplicationSbom();
        if (applicationSbom != null) {
            result.put(APPLICATION_SBOM_ID, applicationSbom);
        }
    }

    @ReadOperation
    Sboms sboms() {
        return new Sboms(new TreeSet<String>(this.sboms.keySet()));
    }

    @ReadOperation
    Resource sbom(@Selector String id) {
        return this.sboms.get(id);
    }

    private Resource getApplicationSbom() {
        if (StringUtils.hasLength((String)this.properties.getApplication().getLocation())) {
            return this.loadResource(this.properties.getApplication().getLocation());
        }
        for (String location : DEFAULT_APPLICATION_SBOM_LOCATIONS) {
            Resource resource = this.resourceLoader.getResource(location);
            if (!resource.exists()) continue;
            return resource;
        }
        return null;
    }

    private Resource loadResource(String location) {
        if (location == null) {
            return null;
        }
        Location parsedLocation = Location.of(location);
        Resource resource = this.resourceLoader.getResource(parsedLocation.location());
        if (resource.exists()) {
            return resource;
        }
        if (parsedLocation.optional()) {
            return null;
        }
        throw new IllegalStateException("Resource '%s' doesn't exist and it's not marked optional".formatted(location));
    }

    record Sboms(Collection<String> ids) implements OperationResponseBody
    {
    }

    private record Location(String location, boolean optional) {
        private static final String OPTIONAL_PREFIX = "optional:";

        static Location of(String location) {
            boolean optional = Location.isOptional(location);
            return new Location(optional ? Location.stripOptionalPrefix(location) : location, optional);
        }

        private static boolean isOptional(String location) {
            return location.startsWith(OPTIONAL_PREFIX);
        }

        private static String stripOptionalPrefix(String location) {
            return location.substring(OPTIONAL_PREFIX.length());
        }
    }

    static class SbomEndpointRuntimeHints
    implements RuntimeHintsRegistrar {
        SbomEndpointRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            for (String defaultLocation : DEFAULT_APPLICATION_SBOM_LOCATIONS) {
                hints.resources().registerPattern(this.stripClasspathPrefix(defaultLocation));
            }
        }

        private String stripClasspathPrefix(String location) {
            return location.substring("classpath:".length());
        }
    }
}

