/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugin.location.base;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.IdAwarePlugin;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.location.LocationProvider;
import com.tencent.polaris.factory.config.global.LocationConfigImpl;
import com.tencent.polaris.factory.config.global.LocationProviderConfigImpl;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import shade.polaris.com.google.gson.Gson;

public abstract class BaseLocationProvider<T>
extends Destroyable
implements LocationProvider,
IdAwarePlugin {
    protected LocationProviderConfigImpl providerConfig;
    private int id;
    protected ModelProto.Location cache;
    private final Class<T> typeClass;
    protected Configuration configuration;

    protected BaseLocationProvider(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.getProviderType().getName();
    }

    @Override
    public PluginType getType() {
        return PluginTypes.LOCAL_PROVIDER.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
        this.configuration = ctx.getConfig();
        LocationConfigImpl config = (LocationConfigImpl)ctx.getConfig().getGlobal().getLocation();
        this.providerConfig = config.getByType(this.getName());
    }

    @Override
    public void postContextInit(Extensions ctx) throws PolarisException {
    }

    @Override
    public ModelProto.Location getLocation() {
        if (this.cache == null) {
            if (this.providerConfig == null) {
                return null;
            }
            Gson gson = new Gson();
            T option = gson.fromJson(gson.toJson(this.providerConfig.getOptions()), this.typeClass);
            this.cache = this.doGet(option);
        }
        return this.cache;
    }

    public abstract ModelProto.Location doGet(T var1);

    public static class GetOption {
        private String region;
        private String zone;
        private String campus;

        public String getRegion() {
            return this.region;
        }

        void setRegion(String region) {
            this.region = region;
        }

        public String getZone() {
            return this.zone;
        }

        void setZone(String zone) {
            this.zone = zone;
        }

        public String getCampus() {
            return this.campus;
        }

        void setCampus(String campus) {
            this.campus = campus;
        }
    }
}

