/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.DiscoveryUpstreamVO;
import org.apache.shenyu.admin.service.DiscoveryUpstreamService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class DiscoveryUpstreamDataConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final DiscoveryUpstreamService discoveryUpstreamService;

    public DiscoveryUpstreamDataConfigsExportImportHandler(DiscoveryUpstreamService discoveryUpstreamService) {
        this.discoveryUpstreamService = discoveryUpstreamService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.DiscoveryUpstream;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<DiscoveryUpstreamVO> discoveryUpstreamList = this.discoveryUpstreamService.listAllDataByNamespaceId(namespaceId);
        if (CollectionUtils.isNotEmpty(discoveryUpstreamList)) {
            return Optional.of(JsonUtils.toJson(discoveryUpstreamList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List discoveryUpstreamList = GsonUtils.getInstance().fromList(data, DiscoveryUpstreamDTO.class);
        ConfigImportResult configImportResult = this.discoveryUpstreamService.importData(namespaceId, discoveryUpstreamList, context);
        context.getResult().put("discoveryUpstreamImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("discoveryUpstreamImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

