/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.websocket;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.ClusterProperties;
import org.apache.shenyu.admin.listener.websocket.WebsocketConfigurator;
import org.apache.shenyu.admin.mode.cluster.service.ClusterSelectMasterService;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.admin.spring.SpringBeanUtils;
import org.apache.shenyu.admin.utils.ThreadLocalUtils;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.RunningModeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/websocket", configurator=WebsocketConfigurator.class)
public class WebsocketCollector {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketCollector.class);
    private static final Set<Session> SESSION_SET = new CopyOnWriteArraySet<Session>();
    private static final Map<String, Set<Session>> NAMESPACE_SESSION_MAP = Maps.newConcurrentMap();
    private static final String SESSION_KEY = "sessionKey";

    @OnOpen
    public void onOpen(Session session) {
        String clientIp = WebsocketCollector.getClientIp(session);
        LOG.info("websocket on client[{}] open successful, maxTextMessageBufferSize: {}", (Object)clientIp, (Object)session.getMaxTextMessageBufferSize());
        SESSION_SET.add(session);
        String namespaceId = WebsocketCollector.getNamespaceId(session);
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            throw new ShenyuException("websocket on client open failed, namespaceId is null");
        }
        LOG.info("websocket on client[{}] open successful, namespaceId: {}", (Object)clientIp, (Object)namespaceId);
        NAMESPACE_SESSION_MAP.computeIfAbsent(namespaceId, k -> Sets.newConcurrentHashSet()).add(session);
    }

    private static String getClientIp(Session session) {
        if (!session.isOpen()) {
            return "";
        }
        Map userProperties = session.getUserProperties();
        if (MapUtils.isEmpty((Map)userProperties)) {
            return "";
        }
        return Optional.ofNullable(userProperties.get("ClientIP")).map(Object::toString).orElse("");
    }

    private static String getNamespaceId(Session session) {
        if (!session.isOpen()) {
            LOG.warn("websocket session is closed, can not get namespaceId");
            return null;
        }
        Map userProperties = session.getUserProperties();
        if (MapUtils.isEmpty((Map)userProperties)) {
            LOG.warn("websocket session userProperties is empty, can not get namespaceId");
            return null;
        }
        return Optional.ofNullable(userProperties.get("namespaceId")).map(Object::toString).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void onMessage(String message, Session session) {
        if (!Objects.equals(message, DataEventTypeEnum.MYSELF.name()) && !Objects.equals(message, DataEventTypeEnum.RUNNING_MODE.name())) {
            return;
        }
        if (Objects.equals(message, DataEventTypeEnum.RUNNING_MODE.name())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("websocket fetching running mode info...");
            }
            boolean isMaster = true;
            String runningMode = RunningModeEnum.STANDALONE.name();
            String masterUrl = "";
            ClusterProperties clusterProperties = SpringBeanUtils.getInstance().getBean(ClusterProperties.class);
            if (clusterProperties.isEnabled()) {
                ClusterSelectMasterService clusterSelectMasterService = SpringBeanUtils.getInstance().getBean(ClusterSelectMasterService.class);
                runningMode = RunningModeEnum.CLUSTER.name();
                isMaster = clusterSelectMasterService.isMaster();
                masterUrl = clusterSelectMasterService.getMasterUrl();
            }
            HashMap map = Maps.newHashMap();
            map.put("eventType", DataEventTypeEnum.RUNNING_MODE.name());
            map.put("isMaster", isMaster);
            map.put("runningMode", runningMode);
            map.put("masterUrl", masterUrl.replace("http", "ws").replace("https", "ws").concat("/websocket"));
            if (isMaster) {
                ThreadLocalUtils.put(SESSION_KEY, session);
            }
            WebsocketCollector.sendMessageBySession(session, JsonUtils.toJson((Object)map));
            return;
        }
        if (Objects.equals(message, DataEventTypeEnum.MYSELF.name())) {
            try {
                ThreadLocalUtils.put(SESSION_KEY, session);
                String namespaceId = WebsocketCollector.getNamespaceId(session);
                SpringBeanUtils.getInstance().getBean(SyncDataService.class).syncAllByNamespaceId(DataEventTypeEnum.MYSELF, namespaceId);
            }
            finally {
                ThreadLocalUtils.clear();
            }
        }
    }

    @OnClose
    public void onClose(Session session) {
        this.clearSession(session);
        LOG.warn("websocket close on client[{}]", (Object)WebsocketCollector.getClientIp(session));
    }

    @OnError
    public void onError(Session session, Throwable error) {
        this.clearSession(session);
        LOG.error("websocket collection on client[{}] error: ", (Object)WebsocketCollector.getClientIp(session), (Object)error);
    }

    public static void send(String message, DataEventTypeEnum type) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        if (DataEventTypeEnum.MYSELF == type) {
            Session session2 = (Session)ThreadLocalUtils.get(SESSION_KEY);
            if (Objects.nonNull(session2)) {
                if (session2.isOpen()) {
                    WebsocketCollector.sendMessageBySession(session2, message);
                } else {
                    SESSION_SET.remove(session2);
                }
            }
        } else {
            SESSION_SET.forEach(session -> WebsocketCollector.sendMessageBySession(session, message));
        }
    }

    public static void send(String namespaceId, String message, DataEventTypeEnum type) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            throw new ShenyuException("namespaceId can not be null");
        }
        LOG.info("websocket send message to namespaceId: {}, message: {}", (Object)namespaceId, (Object)message);
        if (DataEventTypeEnum.MYSELF == type) {
            Session session2 = (Session)ThreadLocalUtils.get(SESSION_KEY);
            if (Objects.nonNull(session2)) {
                if (session2.isOpen()) {
                    WebsocketCollector.sendMessageBySession(session2, message);
                } else {
                    NAMESPACE_SESSION_MAP.getOrDefault(namespaceId, Sets.newConcurrentHashSet()).remove(session2);
                }
            }
        } else {
            NAMESPACE_SESSION_MAP.getOrDefault(namespaceId, Sets.newConcurrentHashSet()).forEach(session -> WebsocketCollector.sendMessageBySession(session, message));
        }
    }

    private static synchronized void sendMessageBySession(Session session, String message) {
        try {
            session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            LOG.error("websocket send result is exception: ", (Throwable)e);
        }
    }

    private void clearSession(Session session) {
        SESSION_SET.remove(session);
        String namespaceId = WebsocketCollector.getNamespaceId(session);
        if (StringUtils.isNotBlank((CharSequence)namespaceId)) {
            NAMESPACE_SESSION_MAP.getOrDefault(namespaceId, Sets.newConcurrentHashSet()).remove(session);
        }
        ThreadLocalUtils.clear();
    }
}

