/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.annotation.Resource;
import java.util.Objects;
import org.apache.shenyu.admin.model.vo.NamespaceVO;
import org.apache.shenyu.admin.register.ShenyuClientServerRegisterPublisher;
import org.apache.shenyu.admin.service.NamespaceService;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.dto.DiscoveryConfigRegisterDTO;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/shenyu-client"})
public class ShenyuClientHttpRegistryController {
    @Resource
    private ShenyuClientServerRegisterPublisher publisher;
    @Resource
    private NamespaceService namespaceService;

    @PostMapping(value={"/register-metadata"})
    @ResponseBody
    public String registerMetadata(@RequestBody MetaDataRegisterDTO metaDataRegisterDTO) {
        if (Objects.isNull(metaDataRegisterDTO.getNamespaceId())) {
            metaDataRegisterDTO.setNamespaceId("649330b6-c2d7-4edc-be8e-8a54df9eb385");
        }
        this.publisher.publish((DataTypeParent)metaDataRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/register-uri"})
    @ResponseBody
    public String registerURI(@RequestBody URIRegisterDTO uriRegisterDTO) {
        if (Objects.isNull(uriRegisterDTO.getNamespaceId())) {
            uriRegisterDTO.setNamespaceId("649330b6-c2d7-4edc-be8e-8a54df9eb385");
        }
        this.publisher.publish((DataTypeParent)uriRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/register-apiDoc"})
    @ResponseBody
    public String registerApiDoc(@RequestBody ApiDocRegisterDTO apiDocRegisterDTO) {
        this.publisher.publish((DataTypeParent)apiDocRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/register-discoveryConfig"})
    @ResponseBody
    public String registerDiscoveryConfig(@RequestBody DiscoveryConfigRegisterDTO discoveryConfigRegisterDTO) {
        if (Objects.isNull(discoveryConfigRegisterDTO.getNamespaceId())) {
            discoveryConfigRegisterDTO.setNamespaceId("649330b6-c2d7-4edc-be8e-8a54df9eb385");
        }
        this.publisher.publish((DataTypeParent)discoveryConfigRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/offline"})
    @ResponseBody
    public String offline(@RequestBody URIRegisterDTO offlineDTO) {
        if (Objects.isNull(offlineDTO.getNamespaceId())) {
            offlineDTO.setNamespaceId("649330b6-c2d7-4edc-be8e-8a54df9eb385");
        }
        this.publisher.publish((DataTypeParent)offlineDTO);
        return "success";
    }

    public void checkClientNamespaceExist(String namespaceId) {
        NamespaceVO namespaceVO = this.namespaceService.findByNamespaceId(namespaceId);
        if (Objects.isNull(namespaceVO)) {
            throw new IllegalArgumentException("namespaceId is not exist");
        }
    }
}

