/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.converter.property;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Set;
import org.apache.servicecomb.swagger.converter.ConverterMgr;
import org.apache.servicecomb.swagger.converter.property.AbstractPropertyConverter;

public class ArrayPropertyConverter
extends AbstractPropertyConverter {
    public static JavaType findJavaType(OpenAPI swagger, Schema itemProperty, Boolean uniqueItems) {
        JavaType itemJavaType = ConverterMgr.findJavaType(swagger, itemProperty);
        Class collectionClass = List.class;
        if (Boolean.TRUE.equals(uniqueItems)) {
            collectionClass = Set.class;
        }
        return TypeFactory.defaultInstance().constructCollectionType(collectionClass, itemJavaType);
    }

    @Override
    public JavaType doConvert(OpenAPI swagger, Schema property) {
        ArraySchema arrayProperty = (ArraySchema)property;
        return ArrayPropertyConverter.findJavaType(swagger, arrayProperty.getItems(), arrayProperty.getUniqueItems());
    }
}

