/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.registry.api.DiscoveryInstance;
import org.apache.servicecomb.registry.discovery.StatefulDiscoveryInstance;

public class Endpoint {
    private final String endpoint;
    private final Transport transport;
    private final DiscoveryInstance instance;
    private final Object address;

    public Endpoint(Transport transport, String endpoint) {
        this(transport, endpoint, null);
    }

    public Endpoint(Transport transport, String endpoint, DiscoveryInstance instance) {
        this.transport = transport;
        this.endpoint = endpoint;
        this.instance = instance;
        this.address = transport.parseAddress(this.endpoint);
    }

    public Endpoint(Transport transport, String endpoint, StatefulDiscoveryInstance instance, Object address) {
        this.transport = transport;
        this.endpoint = endpoint;
        this.instance = instance;
        this.address = address;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public DiscoveryInstance getMicroserviceInstance() {
        return this.instance;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Object getAddress() {
        return this.address;
    }

    public String toString() {
        return this.endpoint;
    }

    public boolean equals(Object o) {
        if (o instanceof Endpoint) {
            return this.endpoint.equals(((Endpoint)o).getEndpoint());
        }
        return false;
    }

    public int hashCode() {
        return this.endpoint.hashCode();
    }
}

