/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.faultinjection;

import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.faultinjection.FaultInjectionUtil;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerAbortFaultFilter
extends AbstractFilter
implements ConsumerFilter,
EdgeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerAbortFaultFilter.class);
    private static final String SUCCESS_RESPONSE = "success";
    public static final String ABORTED_ERROR_MSG = "aborted by fault inject";

    public int getOrder() {
        return 1020;
    }

    public String getName() {
        return "consumer-abort-fault";
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (!this.shouldAbort(invocation)) {
            return nextNode.onFilter(invocation);
        }
        int errorCode = FaultInjectionUtil.getFaultInjectionConfig(invocation, "abort.httpStatus");
        if (errorCode == -1) {
            LOGGER.debug("Fault injection: Abort error code is not configured");
            return CompletableFuture.completedFuture(Response.succResp((Object)SUCCESS_RESPONSE));
        }
        CommonExceptionData errorData = new CommonExceptionData(ABORTED_ERROR_MSG);
        return CompletableFuture.failedFuture((Throwable)new InvocationException(errorCode, ABORTED_ERROR_MSG, (Object)errorData));
    }

    private boolean shouldAbort(Invocation invocation) {
        int abortPercent = FaultInjectionUtil.getFaultInjectionConfig(invocation, "abort.percent");
        if (abortPercent == -1) {
            LOGGER.debug("Fault injection: Abort percentage is not configured");
            return false;
        }
        return FaultInjectionUtil.isFaultNeedToInject(abortPercent);
    }
}

