/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.localregistry;

import java.util.List;
import org.apache.servicecomb.localregistry.LocalDiscoveryInstance;
import org.apache.servicecomb.localregistry.LocalRegistryStore;
import org.apache.servicecomb.registry.api.Discovery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class LocalDiscovery
implements Discovery<LocalDiscoveryInstance> {
    public static final String LOCAL_DISCOVERY_ENABLED = "servicecomb.registry.local.%s.%s.enabled";
    private LocalRegistryStore localRegistryStore;
    private Environment environment;

    @Autowired
    public void setLocalRegistryStore(LocalRegistryStore localRegistryStore) {
        this.localRegistryStore = localRegistryStore;
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public int getOrder() {
        return -10000;
    }

    public String name() {
        return "local-registry";
    }

    public boolean enabled(String application, String serviceName) {
        return (Boolean)this.environment.getProperty(String.format(LOCAL_DISCOVERY_ENABLED, application, serviceName), Boolean.TYPE, (Object)true);
    }

    public List<LocalDiscoveryInstance> findServiceInstances(String application, String serviceName) {
        return this.localRegistryStore.findServiceInstances(application, serviceName);
    }

    public List<String> findServices(String application) {
        return this.localRegistryStore.findServices(application);
    }

    public void setInstanceChangedListener(Discovery.InstanceChangedListener<LocalDiscoveryInstance> instanceChangedListener) {
    }

    public void init() {
        this.localRegistryStore.init();
    }

    public void run() {
        this.localRegistryStore.run();
    }

    public void destroy() {
    }

    public boolean enabled() {
        return (Boolean)this.environment.getProperty("servicecomb.registry.local.enabled", Boolean.TYPE, (Object)true);
    }
}

