/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.apache.servicecomb.transport.rest.client.RestClientRequestParameters;

public class LocalPortAccessItem
implements AccessLogItem<RoutingContext> {
    public static final String EMPTY_RESULT = "-";

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        HttpServerRequest request = accessLogEvent.getRoutingContext().request();
        if (null == request || null == request.localAddress()) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(request.localAddress().port());
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        RestClientRequestParameters restRequestImpl = (RestClientRequestParameters)finishEvent.getInvocation().getHandlerContext().get("servicecomb-invocation-handler-requestclient");
        if (null == restRequestImpl || null == restRequestImpl.getHttpClientRequest() || null == restRequestImpl.getHttpClientRequest().connection() || null == restRequestImpl.getHttpClientRequest().connection().localAddress()) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(restRequestImpl.getHttpClientRequest().connection().localAddress().port());
    }
}

