/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.runtime;

import it.geosolutions.jaiext.jiffle.runtime.DaemonThreadFactory;
import it.geosolutions.jaiext.jiffle.runtime.JiffleDirectRuntime;
import it.geosolutions.jaiext.jiffle.runtime.JiffleEvent;
import it.geosolutions.jaiext.jiffle.runtime.JiffleEventListener;
import it.geosolutions.jaiext.jiffle.runtime.JiffleExecutorResult;
import it.geosolutions.jaiext.jiffle.runtime.JiffleExecutorTask;
import it.geosolutions.jaiext.jiffle.runtime.JiffleProgressListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JiffleExecutor {
    private static final Logger LOGGER = Logger.getLogger(JiffleExecutor.class.getName());
    private static final String TASK_SUBMITTED_MSG = "Task {0} submitted";
    private static final String TASK_SUCCESS_MSG = "Task {0} completed";
    private static final String TASK_FAILURE_MSG = "Task {0} failed";
    public static final long DEFAULT_POLLING_INTERVAL = 20L;
    private long pollingInterval = 20L;
    private static final AtomicInteger jobID = new AtomicInteger(0);
    private final Object _lock = new Object();
    private final ExecutorService taskService;
    private final ScheduledExecutorService pollingService;
    private final ScheduledExecutorService shutdownService;
    private final ExecutorCompletionService<JiffleExecutorResult> completionService;
    private final List<JiffleEventListener> listeners;
    private boolean isPolling;
    private int numTasksRunning;

    public JiffleExecutor() {
        this(ThreadPoolType.CACHED, -1);
    }

    public JiffleExecutor(int maxTasks) {
        this(ThreadPoolType.FIXED, maxTasks);
    }

    private JiffleExecutor(ThreadPoolType type, int maxJobs) {
        switch (type) {
            case CACHED: {
                this.taskService = Executors.newCachedThreadPool();
                break;
            }
            case FIXED: {
                this.taskService = Executors.newFixedThreadPool(maxJobs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad arg to private JiffleExecutor constructor");
            }
        }
        this.completionService = new ExecutorCompletionService(this.taskService);
        this.pollingService = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory(5, "executor-poll"));
        this.shutdownService = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory(5, "executor-shutdown"));
        this.listeners = new ArrayList<JiffleEventListener>();
        this.isPolling = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPollingInterval(long millis) {
        Object object = this._lock;
        synchronized (object) {
            if (this.isPolling) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Request to change polling interval ignored");
                }
            } else if (millis < 1L) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Invalid polling interval ignored: {0}", millis);
                }
            } else {
                this.pollingInterval = millis;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPollingInterval() {
        Object object = this._lock;
        synchronized (object) {
            return this.pollingInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(JiffleEventListener listener) {
        Object object = this._lock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEventListener(JiffleEventListener listener) {
        Object object = this._lock;
        synchronized (object) {
            return this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening(JiffleEventListener listener) {
        Object object = this._lock;
        synchronized (object) {
            return this.listeners.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submit(JiffleDirectRuntime runtime, JiffleProgressListener progressListener) {
        Object object = this._lock;
        synchronized (object) {
            if (this.taskService.isShutdown()) {
                throw new IllegalStateException("Submitting task after executor shutdown");
            }
            this.startPolling();
            int id = jobID.getAndIncrement();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, TASK_SUBMITTED_MSG, id);
            }
            ++this.numTasksRunning;
            this.completionService.submit(new JiffleExecutorTask(this, id, runtime, progressListener));
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this._lock;
        synchronized (object) {
            this.taskService.shutdown();
            this.stopPolling(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownAndWait(long timeOut, TimeUnit unit) {
        Object object = this._lock;
        synchronized (object) {
            boolean success = false;
            this.taskService.shutdown();
            this.stopPolling(false);
            try {
                success = this.taskService.awaitTermination(timeOut, unit);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return success;
        }
    }

    public void shutdownNow() {
        this.taskService.shutdownNow();
        this.stopPolling(true);
    }

    private void startPolling() {
        if (!this.isPolling) {
            this.pollingService.scheduleWithFixedDelay(new PollingTask(), this.pollingInterval, this.pollingInterval, TimeUnit.MILLISECONDS);
            this.isPolling = true;
        }
    }

    private void stopPolling(boolean immediate) {
        if (immediate) {
            this.pollingService.shutdown();
            return;
        }
        this.shutdownService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (JiffleExecutor.this.numTasksRunning == 0) {
                    JiffleExecutor.this.pollingService.shutdown();
                    JiffleExecutor.this.shutdownService.shutdown();
                }
            }
        }, this.pollingInterval, this.pollingInterval, TimeUnit.MILLISECONDS);
    }

    private class PollingTask
    implements Runnable {
        private PollingTask() {
        }

        @Override
        public void run() {
            try {
                Future future = JiffleExecutor.this.completionService.poll();
                if (future != null) {
                    JiffleExecutorResult result = (JiffleExecutorResult)future.get();
                    JiffleExecutor.this.numTasksRunning--;
                    if (result.isCompleted()) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.log(Level.INFO, JiffleExecutor.TASK_SUCCESS_MSG, result.getTaskID());
                        }
                        this.notifySuccess(result);
                    } else {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.log(Level.INFO, JiffleExecutor.TASK_FAILURE_MSG, result.getTaskID());
                        }
                        this.notifyFailure(result);
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private void notifySuccess(JiffleExecutorResult result) {
            for (JiffleEventListener listener : JiffleExecutor.this.listeners) {
                listener.onCompletionEvent(new JiffleEvent(result));
            }
        }

        private void notifyFailure(JiffleExecutorResult result) {
            for (JiffleEventListener listener : JiffleExecutor.this.listeners) {
                listener.onFailureEvent(new JiffleEvent(result));
            }
        }
    }

    private static enum ThreadPoolType {
        CACHED,
        FIXED;

    }
}

