/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster.serde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.sun.media.jai.util.DataBufferUtils;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import org.apache.sedona.common.raster.serde.KryoUtil;

public class DataBufferSerializer
extends Serializer<DataBuffer> {
    public void write(Kryo kryo, Output output, DataBuffer dataBuffer) {
        int dataType = dataBuffer.getDataType();
        output.writeInt(dataType);
        KryoUtil.writeIntArray(output, dataBuffer.getOffsets());
        output.writeInt(dataBuffer.getSize());
        switch (dataType) {
            case 0: {
                byte[][] byteDataArray = ((DataBufferByte)dataBuffer).getBankData();
                KryoUtil.writeByteArrays(output, byteDataArray);
                break;
            }
            case 1: {
                short[][] uShortDataArray = ((DataBufferUShort)dataBuffer).getBankData();
                KryoUtil.writeShortArrays(output, uShortDataArray);
                break;
            }
            case 2: {
                short[][] shortDataArray = ((DataBufferShort)dataBuffer).getBankData();
                KryoUtil.writeShortArrays(output, shortDataArray);
                break;
            }
            case 3: {
                int[][] intDataArray = ((DataBufferInt)dataBuffer).getBankData();
                KryoUtil.writeIntArrays(output, intDataArray);
                break;
            }
            case 4: {
                float[][] floatDataArray = DataBufferUtils.getBankDataFloat((DataBuffer)dataBuffer);
                KryoUtil.writeFloatArrays(output, floatDataArray);
                break;
            }
            case 5: {
                double[][] doubleDataArray = DataBufferUtils.getBankDataDouble((DataBuffer)dataBuffer);
                KryoUtil.writeDoubleArrays(output, doubleDataArray);
                break;
            }
            default: {
                throw new RuntimeException("Unknown data type: " + dataType);
            }
        }
    }

    public DataBuffer read(Kryo kryo, Input input, Class<DataBuffer> type) {
        DataBuffer dataBuffer;
        int dataType = input.readInt();
        int[] offsets = KryoUtil.readIntArray(input);
        int size = input.readInt();
        switch (dataType) {
            case 0: {
                byte[][] byteDataArray = KryoUtil.readByteArrays(input);
                dataBuffer = new DataBufferByte(byteDataArray, size, offsets);
                break;
            }
            case 1: {
                short[][] uShortDataArray = KryoUtil.readShortArrays(input);
                dataBuffer = new DataBufferUShort(uShortDataArray, size, offsets);
                break;
            }
            case 2: {
                short[][] shortDataArray = KryoUtil.readShortArrays(input);
                dataBuffer = new DataBufferShort(shortDataArray, size, offsets);
                break;
            }
            case 3: {
                int[][] intDataArray = KryoUtil.readIntArrays(input);
                dataBuffer = new DataBufferInt(intDataArray, size, offsets);
                break;
            }
            case 4: {
                float[][] floatDataArray = KryoUtil.readFloatArrays(input);
                dataBuffer = DataBufferUtils.createDataBufferFloat((float[][])floatDataArray, (int)size, (int[])offsets);
                break;
            }
            case 5: {
                double[][] doubleDataArray = KryoUtil.readDoubleArrays(input);
                dataBuffer = DataBufferUtils.createDataBufferDouble((double[][])doubleDataArray, (int)size, (int[])offsets);
                break;
            }
            default: {
                throw new RuntimeException("Unknown data type: " + dataType);
            }
        }
        return dataBuffer;
    }
}

