/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.replace;

import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.SeaTunnelRowAccessor;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.transform.common.SingleFieldOutputTransform;
import org.apache.seatunnel.transform.exception.TransformCommonError;
import org.apache.seatunnel.transform.replace.ReplaceTransformConfig;

public class ReplaceTransform
extends SingleFieldOutputTransform {
    private final ReadonlyConfig config;
    private int inputFieldIndex;

    public ReplaceTransform(@NonNull ReadonlyConfig config, @NonNull CatalogTable inputCatalogTable) {
        super(inputCatalogTable);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (inputCatalogTable == null) {
            throw new NullPointerException("inputCatalogTable is marked non-null but is null");
        }
        this.config = config;
        this.initOutputFields(inputCatalogTable.getTableSchema().toPhysicalRowDataType(), (String)this.config.get(ReplaceTransformConfig.KEY_REPLACE_FIELD));
    }

    public String getPluginName() {
        return "Replace";
    }

    private void initOutputFields(SeaTunnelRowType inputRowType, String replaceField) {
        try {
            this.inputFieldIndex = inputRowType.indexOf(replaceField);
        }
        catch (IllegalArgumentException e) {
            throw TransformCommonError.cannotFindInputFieldError(this.getPluginName(), replaceField);
        }
    }

    @Override
    protected Object getOutputFieldValue(SeaTunnelRowAccessor inputRow) {
        boolean isRegex;
        Object inputFieldValue = inputRow.getField(this.inputFieldIndex);
        if (inputFieldValue == null) {
            return null;
        }
        boolean bl = isRegex = this.config.get(ReplaceTransformConfig.KEY_IS_REGEX) != null && (Boolean)this.config.get(ReplaceTransformConfig.KEY_IS_REGEX) != false;
        if (isRegex) {
            if (((Boolean)this.config.get(ReplaceTransformConfig.KEY_REPLACE_FIRST)).booleanValue()) {
                return inputFieldValue.toString().replaceFirst((String)this.config.get(ReplaceTransformConfig.KEY_PATTERN), (String)this.config.get(ReplaceTransformConfig.KEY_REPLACEMENT));
            }
            return inputFieldValue.toString().replaceAll((String)this.config.get(ReplaceTransformConfig.KEY_PATTERN), (String)this.config.get(ReplaceTransformConfig.KEY_REPLACEMENT));
        }
        return inputFieldValue.toString().replace((CharSequence)this.config.get(ReplaceTransformConfig.KEY_PATTERN), (CharSequence)this.config.get(ReplaceTransformConfig.KEY_REPLACEMENT));
    }

    @Override
    protected Column getOutputColumn() {
        List columns = this.inputCatalogTable.getTableSchema().getColumns();
        List collect = columns.stream().filter(column -> column.getName().equals(this.config.get(ReplaceTransformConfig.KEY_REPLACE_FIELD))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            throw TransformCommonError.cannotFindInputFieldError(this.getPluginName(), (String)this.config.get(ReplaceTransformConfig.KEY_REPLACE_FIELD));
        }
        return ((Column)collect.get(0)).copy();
    }
}

