/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.semantics;

import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.royale.abc.ABCConstants;

public class ECMASupport {
    private static final long MASK_32_BIT_UINT = 0xFFFFFFFFL;
    private static final double TWO_TO_THE_31ST = Math.pow(2.0, 31.0);
    private static final double TWO_TO_THE_32ND = Math.pow(2.0, 32.0);

    public static int toInt32(double number) {
        long int32bit = ECMASupport.toUInt32(number);
        if ((double)int32bit >= TWO_TO_THE_31ST) {
            return (int)((double)int32bit - TWO_TO_THE_32ND);
        }
        return (int)int32bit;
    }

    public static int toInt32(Number number) {
        return ECMASupport.toInt32(number.doubleValue());
    }

    public static int toInt32(Object value) {
        return ECMASupport.toInt32(ECMASupport.toNumeric(value));
    }

    public static long toUInt32(double number) {
        double posInt = ECMASupport.toInteger(number);
        double int32bit = posInt % TWO_TO_THE_32ND;
        return (long)int32bit & 0xFFFFFFFFL;
    }

    public static long toUInt32(Number value) {
        return ECMASupport.toUInt32(value.doubleValue());
    }

    public static long toUInt32(Object value) {
        return ECMASupport.toUInt32(ECMASupport.toNumeric(value));
    }

    public static double toInteger(double number) {
        if (ECMASupport.isNan(number) || 0.0 == number || Double.isInfinite(number)) {
            return 0.0;
        }
        double posInt = Math.signum(number) * Math.floor(Math.abs(number));
        return posInt;
    }

    public static <T> boolean toBoolean(T value) {
        assert (value != null) : "to pass null use ABCConstants.NULL_VALUE";
        if (value == ABCConstants.NULL_VALUE) {
            return false;
        }
        if (value == ABCConstants.UNDEFINED_VALUE) {
            return false;
        }
        if (value instanceof Number) {
            return ECMASupport.toBoolean((Number)value);
        }
        if (value instanceof String) {
            return ECMASupport.toBoolean((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public static boolean toBoolean(Number value) {
        if (ECMASupport.isNan(value.doubleValue())) {
            return false;
        }
        return value.doubleValue() != 0.0;
    }

    public static boolean toBoolean(String value) {
        return !value.isEmpty();
    }

    public static boolean isNan(double number) {
        return Double.isNaN(number);
    }

    public static int leftShiftOperation(Number left, Number right) {
        double lval = left.doubleValue();
        double rval = right.doubleValue();
        int lnum = ECMASupport.toInt32(lval);
        long rnum = ECMASupport.toUInt32(rval);
        long shiftCount = rnum & 0x1FL;
        return lnum << (int)shiftCount;
    }

    public static int signedRightShiftOperation(Number left, Number right) {
        double lval = left.doubleValue();
        double rval = right.doubleValue();
        int lnum = ECMASupport.toInt32(lval);
        long rnum = ECMASupport.toUInt32(rval);
        long shiftCount = rnum & 0x1FL;
        return lnum >> (int)shiftCount;
    }

    public static long unsignedRightShiftOperation(Number left, Number right) {
        double lval = left.doubleValue();
        double rval = right.doubleValue();
        long lnum = ECMASupport.toUInt32(lval);
        long rnum = ECMASupport.toUInt32(rval);
        long shiftCount = rnum & 0x1FL;
        return lnum >>> (int)shiftCount;
    }

    public static <T> T logicalAnd(T left, T right) {
        boolean b = ECMASupport.toBoolean(left);
        return b ? right : left;
    }

    public static <T> T logicalOr(T left, T right) {
        boolean b = ECMASupport.toBoolean(left);
        return b ? left : right;
    }

    public static <T> boolean logicalNot(T e) {
        return !ECMASupport.toBoolean(e);
    }

    public static <T> Number toNumeric(T value) {
        if (value == ABCConstants.UNDEFINED_VALUE) {
            return Double.NaN;
        }
        if (value == ABCConstants.NULL_VALUE) {
            return 0;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Boolean) {
            return ECMASupport.toNumeric((Boolean)value);
        }
        if (value instanceof String) {
            return ECMASupport.toNumeric((String)value);
        }
        return null;
    }

    private static int toNumeric(Boolean value) {
        return value != false ? 1 : 0;
    }

    private static String numberTrim(String str) {
        Character c;
        int i;
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < str.length(); ++i) {
            c = Character.valueOf(str.charAt(i));
            if (Character.isWhitespace(c.charValue())) continue;
            buf.append(c);
        }
        str = new String(buf);
        buf = new StringBuilder();
        for (i = str.length() - 1; i >= 0; --i) {
            c = Character.valueOf(str.charAt(i));
            if (Character.isWhitespace(c.charValue())) continue;
            buf.append(c);
        }
        str = new String(buf.reverse());
        return str;
    }

    private static Number toNumeric(String str) {
        double num;
        double[] sign = new double[1];
        str = ECMASupport.numberTrim(str);
        if ((str = ECMASupport.numberSign(str, sign)).equals("")) {
            num = 0.0;
        } else if (str.equals("Infinity")) {
            num = sign[0] > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        } else if (str.equals("NaN")) {
            num = Double.NaN;
        } else if (str.startsWith("0x") || str.startsWith("0X")) {
            try {
                num = sign[0] * (double)Long.valueOf(str.substring(2), 16).longValue();
            }
            catch (NumberFormatException e) {
                num = Double.NaN;
            }
        } else if (!Character.isDigit(str.charAt(str.length() - 1)) && str.charAt(str.length() - 1) != '.') {
            num = Double.NaN;
        } else {
            try {
                num = sign[0] * Double.valueOf(str);
            }
            catch (NumberFormatException e) {
                num = Double.NaN;
            }
        }
        return num;
    }

    private static String numberSign(String str, double[] num) {
        if (str.length() == 0) {
            num[0] = 1.0;
        } else if (str.equals("-") || str.equals("+")) {
            num[0] = 0.0;
        } else if (str.startsWith("-")) {
            num[0] = -1.0;
            str = str.substring(1);
        } else if (str.startsWith("+")) {
            num[0] = 1.0;
            str = str.substring(1);
        } else {
            num[0] = 1.0;
        }
        return str;
    }

    public static boolean equals(Number l, Number r) {
        double lDouble = l.doubleValue();
        if (Double.isNaN(lDouble)) {
            return false;
        }
        return lDouble == r.doubleValue();
    }

    public static boolean equals(String l, String r) {
        return l.equals(r);
    }

    public static boolean equals(Boolean l, Boolean r) {
        return l.equals(r);
    }

    public static boolean equals(Object l, Object r) {
        ECMAType rightType;
        ECMAType leftType = ECMASupport.getType(l);
        if (leftType == (rightType = ECMASupport.getType(r))) {
            switch (leftType) {
                case Boolean: {
                    return ECMASupport.equals((Boolean)l, (Boolean)r);
                }
                case Number: {
                    return ECMASupport.equals((Number)l, (Number)r);
                }
                case String: {
                    return ECMASupport.equals((String)l, (String)r);
                }
                case Null: {
                    return true;
                }
                case Undefined: {
                    return true;
                }
            }
        }
        if (l == r) {
            return true;
        }
        switch (leftType) {
            case Boolean: {
                return ECMASupport.equals((Object)ECMASupport.toNumeric((Boolean)l), r);
            }
            case Number: {
                if (rightType != ECMAType.String) break;
                return ECMASupport.equals((Number)l, ECMASupport.toNumeric((String)r));
            }
            case String: {
                if (rightType != ECMAType.Number) break;
                return ECMASupport.equals(ECMASupport.toNumeric((String)l), (Number)r);
            }
            case Null: {
                if (rightType != ECMAType.Undefined) break;
                return true;
            }
            case Undefined: {
                if (rightType != ECMAType.Null) break;
                return true;
            }
        }
        if (rightType == ECMAType.Boolean) {
            return ECMASupport.equals(l, (Object)ECMASupport.toNumeric((Boolean)r));
        }
        return false;
    }

    public static boolean strictEquals(Object l, Object r) {
        ECMAType rightType;
        ECMAType leftType = ECMASupport.getType(l);
        if (leftType == (rightType = ECMASupport.getType(r))) {
            switch (leftType) {
                case Boolean: {
                    return ECMASupport.equals((Boolean)l, (Boolean)r);
                }
                case Number: {
                    return ECMASupport.equals((Number)l, (Number)r);
                }
                case String: {
                    return ECMASupport.equals((String)l, (String)r);
                }
                case Null: {
                    return true;
                }
                case Undefined: {
                    return true;
                }
            }
        }
        return false;
    }

    private static ECMAType getType(Object o) {
        if (o instanceof String) {
            return ECMAType.String;
        }
        if (o instanceof Number) {
            return ECMAType.Number;
        }
        if (o instanceof Boolean) {
            return ECMAType.Boolean;
        }
        if (o == ABCConstants.NULL_VALUE) {
            return ECMAType.Null;
        }
        if (o == ABCConstants.UNDEFINED_VALUE) {
            return ECMAType.Undefined;
        }
        assert (false) : "unknown constant type";
        return null;
    }

    private static Boolean relationalCompare(Object l, Object r) {
        ECMAType lType = ECMASupport.getType(l);
        ECMAType rType = ECMASupport.getType(r);
        if (lType == ECMAType.String && rType == ECMAType.String) {
            return ECMASupport.relationalCompare((String)l, (String)r);
        }
        return ECMASupport.relationalCompare(ECMASupport.toNumeric(l), ECMASupport.toNumeric(r));
    }

    private static Boolean relationalCompare(String l, String r) {
        if (l.compareTo(r) < 0) {
            return true;
        }
        return false;
    }

    private static Boolean relationalCompare(Number l, Number r) {
        double lVal = l.doubleValue();
        double rVal = r.doubleValue();
        if (ECMASupport.isNan(lVal) || ECMASupport.isNan(rVal)) {
            return null;
        }
        return lVal < rVal;
    }

    public static boolean lessThan(Number l, Number r) {
        Boolean res = ECMASupport.relationalCompare(l, r);
        if (res == null) {
            return false;
        }
        return res;
    }

    public static boolean lessThan(Object l, Object r) {
        Boolean res = ECMASupport.relationalCompare(l, r);
        if (res == null) {
            return false;
        }
        return res;
    }

    public static boolean lessThanEquals(Number l, Number r) {
        Boolean res = ECMASupport.relationalCompare(r, l);
        return res != null && res != true;
    }

    public static boolean lessThanEquals(Object l, Object r) {
        Boolean res = ECMASupport.relationalCompare(r, l);
        return res != null && res != true;
    }

    public static boolean greaterThan(Number l, Number r) {
        Boolean res = ECMASupport.relationalCompare(r, l);
        if (res == null) {
            return false;
        }
        return res;
    }

    public static boolean greaterThan(Object l, Object r) {
        Boolean res = ECMASupport.relationalCompare(r, l);
        if (res == null) {
            return false;
        }
        return res;
    }

    public static boolean greaterThanEquals(Number l, Number r) {
        Boolean res = ECMASupport.relationalCompare(l, r);
        return res != null && res != true;
    }

    public static boolean greaterThanEquals(Object l, Object r) {
        Boolean res = ECMASupport.relationalCompare(l, r);
        return res != null && res != true;
    }

    public static String toString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Double) {
            return ECMASupport.toString((Double)o);
        }
        if (o instanceof Integer) {
            return ECMASupport.toString((Integer)o);
        }
        if (o instanceof Long) {
            return ECMASupport.toString((Long)o);
        }
        if (o instanceof Boolean) {
            return ECMASupport.toString((Boolean)o);
        }
        if (o == ABCConstants.NULL_VALUE) {
            return "null";
        }
        if (o == ABCConstants.UNDEFINED_VALUE) {
            return "undefined";
        }
        return null;
    }

    public static String toString(Double d) {
        String str = "";
        if (d.isNaN() || d.isInfinite()) {
            str = "" + d;
        } else {
            BigDecimal bd = new BigDecimal(d).round(MathContext.DECIMAL64).stripTrailingZeros();
            if (bd.scale() < 0 && bd.scale() > -21) {
                bd = bd.setScale(0);
            }
            str = "" + bd;
            str = str.replaceFirst("E", "e");
        }
        return str;
    }

    public static String toString(Integer i) {
        return "" + new BigDecimal(i);
    }

    public static String toString(Long i) {
        return "" + new BigDecimal(i);
    }

    public static String toString(Boolean b) {
        if (b.booleanValue()) {
            return "true";
        }
        return "false";
    }

    private static enum ECMAType {
        Boolean,
        Number,
        String,
        Null,
        Undefined;

    }
}

