/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.impl.LoggingSupport;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.Transport;
import java.io.IOException;
import java.time.Duration;

class TransportLogger
implements Transport {
    private final Transport transport;

    TransportLogger(Transport transport) {
        this.transport = transport;
    }

    @Override
    public void send(JsonObject message) {
        String messageString = Serialization.gson().toJson((JsonElement)message);
        LoggingSupport.logWithTimestamp("SEND \u25ba " + messageString);
        this.transport.send(message);
    }

    @Override
    public JsonObject poll(Duration timeout) {
        JsonObject message = this.transport.poll(timeout);
        if (message != null) {
            String messageString = Serialization.gson().toJson((JsonElement)message);
            LoggingSupport.logWithTimestamp("\u25c0 RECV " + messageString);
        }
        return message;
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }
}

