/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasArrayType
extends AtlasType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasArrayType.class);
    private final String elementTypeName;
    private int minCount;
    private int maxCount;
    private AtlasStructDef.AtlasAttributeDef.Cardinality cardinality;
    private AtlasType elementType;

    public AtlasArrayType(AtlasType elementType) {
        this(elementType, -1, -1, AtlasStructDef.AtlasAttributeDef.Cardinality.LIST);
    }

    public AtlasArrayType(AtlasType elementType, int minCount, int maxCount, AtlasStructDef.AtlasAttributeDef.Cardinality cardinality) {
        super(AtlasBaseTypeDef.getArrayTypeName(elementType.getTypeName()), TypeCategory.ARRAY, "atlas_core");
        this.elementTypeName = elementType.getTypeName();
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.cardinality = cardinality;
        this.elementType = elementType;
    }

    public AtlasArrayType(String elementTypeName, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        this(elementTypeName, -1, -1, AtlasStructDef.AtlasAttributeDef.Cardinality.LIST, typeRegistry);
    }

    public AtlasArrayType(String elementTypeName, int minCount, int maxCount, AtlasStructDef.AtlasAttributeDef.Cardinality cardinality, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(AtlasBaseTypeDef.getArrayTypeName(elementTypeName), TypeCategory.ARRAY, "atlas_core");
        this.elementTypeName = elementTypeName;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.cardinality = cardinality;
        this.resolveReferences(typeRegistry);
    }

    public String getElementTypeName() {
        return this.elementTypeName;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality cardinality) {
        this.cardinality = cardinality;
    }

    public AtlasStructDef.AtlasAttributeDef.Cardinality getCardinality() {
        return this.cardinality;
    }

    public AtlasType getElementType() {
        return this.elementType;
    }

    @Override
    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        this.elementType = typeRegistry.getType(this.elementTypeName);
    }

    @Override
    public Collection<?> createDefaultValue() {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(this.elementType.createDefaultValue());
        if (this.minCount != -1) {
            for (int i = 1; i < this.minCount; ++i) {
                ret.add(this.elementType.createDefaultValue());
            }
        }
        return ret;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            if (obj instanceof List || obj instanceof Set) {
                Collection objList = (Collection)obj;
                if (!this.isValidElementCount(objList.size())) {
                    return false;
                }
                for (Object element : objList) {
                    if (this.elementType.isValidValue(element)) continue;
                    return false;
                }
            } else if (obj.getClass().isArray()) {
                int arrayLen = Array.getLength(obj);
                if (!this.isValidElementCount(arrayLen)) {
                    return false;
                }
                for (int i = 0; i < arrayLen; ++i) {
                    if (this.elementType.isValidValue(Array.get(obj, i))) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean areEqualValues(Object val1, Object val2, Map<String, String> guidAssignments) {
        boolean ret = this.cardinality == AtlasStructDef.AtlasAttributeDef.Cardinality.SET ? this.areEqualSets(val1, val2, guidAssignments) : this.areEqualLists(val1, val2, guidAssignments);
        return ret;
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            if (obj instanceof List || obj instanceof Set) {
                Collection objList = (Collection)obj;
                if (!this.isValidElementCount(objList.size())) {
                    return false;
                }
                for (Object element : objList) {
                    if (this.elementType.isValidValueForUpdate(element)) continue;
                    return false;
                }
            } else if (obj.getClass().isArray()) {
                int arrayLen = Array.getLength(obj);
                if (!this.isValidElementCount(arrayLen)) {
                    return false;
                }
                for (int i = 0; i < arrayLen; ++i) {
                    if (this.elementType.isValidValueForUpdate(Array.get(obj, i))) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Collection<?> getNormalizedValue(Object obj) {
        ArrayList<Object> ret;
        block8: {
            int arrayLen;
            block9: {
                ret = null;
                if (obj instanceof String) {
                    obj = AtlasType.fromJson(obj.toString(), List.class);
                }
                if (!(obj instanceof List) && !(obj instanceof Set)) break block9;
                Collection collObj = (Collection)obj;
                if (!this.isValidElementCount(collObj.size())) break block8;
                ret = new ArrayList<Object>(collObj.size());
                for (Object element : collObj) {
                    if (element != null) {
                        Object normalizedValue = this.elementType.getNormalizedValue(element);
                        if (normalizedValue != null) {
                            ret.add(normalizedValue);
                            continue;
                        }
                        ret = null;
                        break block8;
                    }
                    ret.add(element);
                }
                break block8;
            }
            if (obj != null && obj.getClass().isArray() && this.isValidElementCount(arrayLen = Array.getLength(obj))) {
                ret = new ArrayList(arrayLen);
                for (int i = 0; i < arrayLen; ++i) {
                    Object element = Array.get(obj, i);
                    if (element != null) {
                        Object normalizedValue = this.elementType.getNormalizedValue(element);
                        if (normalizedValue != null) {
                            ret.add(normalizedValue);
                            continue;
                        }
                        ret = null;
                        break;
                    }
                    ret.add(element);
                }
            }
        }
        return ret;
    }

    @Override
    public Collection<?> getNormalizedValueForUpdate(Object obj) {
        ArrayList<Object> ret;
        block8: {
            int arrayLen;
            block9: {
                ret = null;
                if (obj instanceof String) {
                    obj = AtlasType.fromJson(obj.toString(), List.class);
                }
                if (!(obj instanceof List) && !(obj instanceof Set)) break block9;
                Collection objList = (Collection)obj;
                if (!this.isValidElementCount(objList.size())) break block8;
                ret = new ArrayList<Object>(objList.size());
                for (Object element : objList) {
                    if (element != null) {
                        Object normalizedValue = this.elementType.getNormalizedValueForUpdate(element);
                        if (normalizedValue != null) {
                            ret.add(normalizedValue);
                            continue;
                        }
                        ret = null;
                        break block8;
                    }
                    ret.add(element);
                }
                break block8;
            }
            if (obj != null && obj.getClass().isArray() && this.isValidElementCount(arrayLen = Array.getLength(obj))) {
                ret = new ArrayList(arrayLen);
                for (int i = 0; i < arrayLen; ++i) {
                    Object element = Array.get(obj, i);
                    if (element != null) {
                        Object normalizedValue = this.elementType.getNormalizedValueForUpdate(element);
                        if (normalizedValue != null) {
                            ret.add(normalizedValue);
                            continue;
                        }
                        ret = null;
                        break;
                    }
                    ret.add(element);
                }
            }
        }
        return ret;
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof List || obj instanceof Set) {
                Collection objList = (Collection)obj;
                if (!this.isValidElementCount(objList.size())) {
                    ret = false;
                    messages.add(objName + ": incorrect number of values. found=" + objList.size() + "; expected: minCount=" + this.minCount + ", maxCount=" + this.maxCount);
                }
                int idx = 0;
                for (Object element : objList) {
                    ret = this.elementType.validateValue(element, objName + "[" + idx + "]", messages) && ret;
                    ++idx;
                }
            } else if (obj.getClass().isArray()) {
                int arrayLen = Array.getLength(obj);
                if (!this.isValidElementCount(arrayLen)) {
                    ret = false;
                    messages.add(objName + ": incorrect number of values. found=" + arrayLen + "; expected: minCount=" + this.minCount + ", maxCount=" + this.maxCount);
                }
                for (int i = 0; i < arrayLen; ++i) {
                    ret = this.elementType.validateValue(Array.get(obj, i), objName + "[" + i + "]", messages) && ret;
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof List || obj instanceof Set) {
                Collection objList = (Collection)obj;
                if (!this.isValidElementCount(objList.size())) {
                    ret = false;
                    messages.add(objName + ": incorrect number of values. found=" + objList.size() + "; expected: minCount=" + this.minCount + ", maxCount=" + this.maxCount);
                }
                int idx = 0;
                for (Object element : objList) {
                    ret = this.elementType.validateValueForUpdate(element, objName + "[" + idx + "]", messages) && ret;
                    ++idx;
                }
            } else if (obj.getClass().isArray()) {
                int arrayLen = Array.getLength(obj);
                if (!this.isValidElementCount(arrayLen)) {
                    ret = false;
                    messages.add(objName + ": incorrect number of values. found=" + arrayLen + "; expected: minCount=" + this.minCount + ", maxCount=" + this.maxCount);
                }
                for (int i = 0; i < arrayLen; ++i) {
                    ret = this.elementType.validateValueForUpdate(Array.get(obj, i), objName + "[" + i + "]", messages) && ret;
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    @Override
    public AtlasType getTypeForAttribute() {
        AtlasType elementAttributeType = this.elementType.getTypeForAttribute();
        if (elementAttributeType == this.elementType) {
            return this;
        }
        AtlasArrayType attributeType = new AtlasArrayType(elementAttributeType, this.minCount, this.maxCount, this.cardinality);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getTypeForAttribute(): {} ==> {}", (Object)this.getTypeName(), (Object)attributeType.getTypeName());
        }
        return attributeType;
    }

    private boolean isValidElementCount(int count) {
        if (this.minCount != -1 && count < this.minCount) {
            return false;
        }
        return this.maxCount == -1 || count <= this.maxCount;
    }

    private boolean isEmptyArrayValue(Object val) {
        if (val instanceof Collection) {
            return ((Collection)val).isEmpty();
        }
        if (val.getClass().isArray()) {
            return Array.getLength(val) == 0;
        }
        if (val instanceof String) {
            List list = AtlasType.fromJson(val.toString(), List.class);
            return list == null || list.isEmpty();
        }
        return false;
    }

    private boolean areEqualSets(Object val1, Object val2, Map<String, String> guidAssignments) {
        boolean ret = true;
        if (val1 == null) {
            ret = val2 == null;
        } else if (val2 == null) {
            ret = false;
        } else if (val1 == val2) {
            ret = true;
        } else {
            Set set1 = this.getSetFromValue(val1);
            Set set2 = this.getSetFromValue(val2);
            if (set1.size() != set2.size()) {
                ret = false;
            } else {
                for (Object elem1 : set1) {
                    boolean foundInSet2 = false;
                    for (Object elem2 : set2) {
                        if (!this.elementType.areEqualValues(elem1, elem2, guidAssignments)) continue;
                        foundInSet2 = true;
                        break;
                    }
                    if (foundInSet2) continue;
                    ret = false;
                    break;
                }
            }
        }
        return ret;
    }

    private boolean areEqualLists(Object val1, Object val2, Map<String, String> guidAssignments) {
        boolean ret = true;
        if (val1 == null) {
            ret = val2 == null;
        } else if (val2 == null) {
            ret = false;
        } else if (val1 == val2) {
            ret = true;
        } else if (val1.getClass().isArray() && val2.getClass().isArray()) {
            int len = Array.getLength(val1);
            if (len != Array.getLength(val2)) {
                ret = false;
            } else {
                for (int i = 0; i < len; ++i) {
                    if (this.elementType.areEqualValues(Array.get(val1, i), Array.get(val2, i), guidAssignments)) continue;
                    ret = false;
                    break;
                }
            }
        } else {
            List list1 = this.getListFromValue(val1);
            List list2 = this.getListFromValue(val2);
            if (list1.size() != list2.size()) {
                ret = false;
            } else {
                int len = list1.size();
                for (int i = 0; i < len; ++i) {
                    if (this.elementType.areEqualValues(list1.get(i), list2.get(i), guidAssignments)) continue;
                    ret = false;
                    break;
                }
            }
        }
        return ret;
    }

    private List getListFromValue(Object val) {
        List ret;
        if (val instanceof List) {
            ret = (ArrayList)val;
        } else if (val instanceof Collection) {
            ret = new ArrayList((Collection)val);
        } else if (val.getClass().isArray()) {
            int len = Array.getLength(val);
            ret = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                ret.add(Array.get(val, i));
            }
        } else {
            ret = val instanceof String ? AtlasType.fromJson(val.toString(), List.class) : null;
        }
        return ret;
    }

    private Set getSetFromValue(Object val) {
        Set ret;
        if (val instanceof Set) {
            ret = (HashSet)val;
        } else if (val instanceof Collection) {
            ret = new HashSet((Collection)val);
        } else if (val.getClass().isArray()) {
            int len = Array.getLength(val);
            ret = new HashSet(len);
            for (int i = 0; i < len; ++i) {
                ret.add(Array.get(val, i));
            }
        } else {
            ret = val instanceof String ? AtlasType.fromJson(val.toString(), Set.class) : null;
        }
        return ret;
    }
}

