/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.ResourceIdentityType;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetIdentity;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetUpdate;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentHelper;
import com.microsoft.azure.management.msi.Identity;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@LangDefinition
class VirtualMachineScaleSetMsiHandler
extends RoleAssignmentHelper {
    private final VirtualMachineScaleSetImpl scaleSet;
    private List<String> creatableIdentityKeys;
    private Map<String, VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue> userAssignedIdentities;

    VirtualMachineScaleSetMsiHandler(GraphRbacManager rbacManager, VirtualMachineScaleSetImpl scaleSet) {
        super(rbacManager, scaleSet.taskGroup(), scaleSet.idProvider());
        this.scaleSet = scaleSet;
        this.creatableIdentityKeys = new ArrayList<String>();
        this.userAssignedIdentities = new HashMap<String, VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue>();
    }

    VirtualMachineScaleSetMsiHandler withLocalManagedServiceIdentity() {
        this.initVMSSIdentity(ResourceIdentityType.SYSTEM_ASSIGNED);
        return this;
    }

    VirtualMachineScaleSetMsiHandler withoutLocalManagedServiceIdentity() {
        if (((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity() == null || ((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity().type() == null || ((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity().type().equals((Object)ResourceIdentityType.NONE) || ((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity().type().equals((Object)ResourceIdentityType.USER_ASSIGNED)) {
            return this;
        }
        if (((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity().type().equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED)) {
            ((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity().withType(ResourceIdentityType.NONE);
        } else if (((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity().type().equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
            ((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity().withType(ResourceIdentityType.USER_ASSIGNED);
        }
        return this;
    }

    VirtualMachineScaleSetMsiHandler withNewExternalManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.initVMSSIdentity(ResourceIdentityType.USER_ASSIGNED);
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)creatableIdentity;
        Objects.requireNonNull(dependency);
        this.scaleSet.taskGroup().addDependency(dependency);
        this.creatableIdentityKeys.add(creatableIdentity.key());
        return this;
    }

    VirtualMachineScaleSetMsiHandler withExistingExternalManagedServiceIdentity(Identity identity) {
        this.initVMSSIdentity(ResourceIdentityType.USER_ASSIGNED);
        this.userAssignedIdentities.put(identity.id(), new VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue());
        return this;
    }

    VirtualMachineScaleSetMsiHandler withoutExternalManagedServiceIdentity(String identityId) {
        this.userAssignedIdentities.put(identityId, null);
        return this;
    }

    void processCreatedExternalIdentities() {
        for (String key : this.creatableIdentityKeys) {
            Identity identity = (Identity)this.scaleSet.taskGroup().taskResult(key);
            Objects.requireNonNull(identity);
            this.userAssignedIdentities.put(identity.id(), new VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue());
        }
        this.creatableIdentityKeys.clear();
    }

    void handleExternalIdentities() {
        if (!this.userAssignedIdentities.isEmpty()) {
            ((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity().withUserAssignedIdentities(this.userAssignedIdentities);
        }
    }

    void handleExternalIdentities(VirtualMachineScaleSetUpdate vmssUpdate) {
        if (this.handleRemoveAllExternalIdentitiesCase(vmssUpdate)) {
            return;
        }
        VirtualMachineScaleSetIdentity currentIdentity = ((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity();
        vmssUpdate.withIdentity(currentIdentity);
        if (!this.userAssignedIdentities.isEmpty()) {
            vmssUpdate.identity().withUserAssignedIdentities(this.userAssignedIdentities);
        } else if (currentIdentity != null) {
            currentIdentity.withUserAssignedIdentities(null);
        }
    }

    void clear() {
        this.userAssignedIdentities = new HashMap<String, VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue>();
    }

    private boolean handleRemoveAllExternalIdentitiesCase(VirtualMachineScaleSetUpdate vmssUpdate) {
        if (!this.userAssignedIdentities.isEmpty()) {
            boolean containsRemoveOnly;
            int rmCount = 0;
            for (VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue v : this.userAssignedIdentities.values()) {
                if (v != null) break;
                ++rmCount;
            }
            boolean bl = containsRemoveOnly = rmCount > 0 && rmCount == this.userAssignedIdentities.size();
            if (containsRemoveOnly) {
                boolean bl2;
                HashSet<String> currentIds = new HashSet<String>();
                VirtualMachineScaleSetIdentity currentIdentity = ((VirtualMachineScaleSetInner)((Object)this.scaleSet.inner())).identity();
                if (currentIdentity != null && currentIdentity.userAssignedIdentities() != null) {
                    for (String string : currentIdentity.userAssignedIdentities().keySet()) {
                        currentIds.add(string.toLowerCase());
                    }
                }
                HashSet<String> removeIds = new HashSet<String>();
                for (Map.Entry<String, VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue> entrySet : this.userAssignedIdentities.entrySet()) {
                    if (entrySet.getValue() != null) continue;
                    removeIds.add(entrySet.getKey().toLowerCase());
                }
                boolean bl3 = bl2 = currentIds.size() == removeIds.size() && currentIds.containsAll(removeIds);
                if (bl2) {
                    if (currentIdentity == null || currentIdentity.type() == null) {
                        vmssUpdate.withIdentity(new VirtualMachineScaleSetIdentity().withType(ResourceIdentityType.NONE));
                    } else if (currentIdentity.type().equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
                        vmssUpdate.withIdentity(currentIdentity);
                        vmssUpdate.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED);
                    } else if (currentIdentity.type().equals((Object)ResourceIdentityType.USER_ASSIGNED)) {
                        vmssUpdate.withIdentity(currentIdentity);
                        vmssUpdate.identity().withType(ResourceIdentityType.NONE);
                    }
                    vmssUpdate.identity().withUserAssignedIdentities(null);
                    return true;
                }
                if (currentIds.size() == 0 && removeIds.size() != 0 && currentIdentity == null) {
                    vmssUpdate.withIdentity(new VirtualMachineScaleSetIdentity().withType(ResourceIdentityType.NONE));
                    vmssUpdate.identity().withUserAssignedIdentities(null);
                    return true;
                }
            }
        }
        return false;
    }

    private void initVMSSIdentity(ResourceIdentityType identityType) {
        if (!identityType.equals((Object)ResourceIdentityType.USER_ASSIGNED) && !identityType.equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED)) {
            throw new IllegalArgumentException("Invalid argument: " + (Object)((Object)identityType));
        }
        VirtualMachineScaleSetInner scaleSetInner = (VirtualMachineScaleSetInner)((Object)this.scaleSet.inner());
        if (scaleSetInner.identity() == null) {
            scaleSetInner.withIdentity(new VirtualMachineScaleSetIdentity());
        }
        if (scaleSetInner.identity().type() == null || scaleSetInner.identity().type().equals((Object)ResourceIdentityType.NONE) || scaleSetInner.identity().type().equals((Object)identityType)) {
            scaleSetInner.identity().withType(identityType);
        } else {
            scaleSetInner.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED);
        }
    }
}

