/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.apache.solr.common.util.FastWriter;
import org.apache.solr.common.util.JsonTextWriter;

public class SolrJSONWriter
implements JsonTextWriter {
    static final char[] indentChars = new char[81];
    protected final String namedListStyle;
    final FastWriter writer;
    protected int level;
    protected boolean doIndent;

    public SolrJSONWriter(Writer writer) {
        this(writer, "map");
    }

    public SolrJSONWriter(Writer writer, String namedListStyle) {
        this.writer = writer == null ? null : FastWriter.wrap(writer);
        this.namedListStyle = namedListStyle;
    }

    public SolrJSONWriter writeObj(Object o) throws IOException {
        this.writeVal(null, o);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flushBuffer();
        }
    }

    @Override
    public String getNamedListStyle() {
        return this.namedListStyle;
    }

    @Override
    public void _writeChar(char c) throws IOException {
        this.writer.write(c);
    }

    @Override
    public void _writeStr(String s) throws IOException {
        this.writer.write(s);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public int incLevel() {
        return ++this.level;
    }

    @Override
    public int decLevel() {
        return --this.level;
    }

    @Override
    public SolrJSONWriter setIndent(boolean doIndent) {
        this.doIndent = doIndent;
        return this;
    }

    @Override
    public boolean doIndent() {
        return this.doIndent;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    static {
        Arrays.fill(indentChars, ' ');
        SolrJSONWriter.indentChars[0] = 10;
    }
}

