/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authentication.unix.jaas;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ConsolePromptCallbackHandler
implements CallbackHandler {
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        for (Callback cb : callbacks) {
            String line;
            if (cb instanceof NameCallback) {
                NameCallback nc = (NameCallback)cb;
                System.out.print(nc.getPrompt());
                System.out.flush();
                line = null;
                while (line == null) {
                    line = reader.readLine();
                }
                nc.setName(line);
                continue;
            }
            if (cb instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)cb;
                System.out.print(pc.getPrompt());
                System.out.flush();
                line = null;
                while (line == null) {
                    line = reader.readLine();
                }
                pc.setPassword(line.toCharArray());
                continue;
            }
            System.out.println("Unknown callback [" + cb.getClass().getName() + "]");
        }
    }
}

