/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.cli.converters.picocli.ByteUnitToLongConverter;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.testclient.CmdBase;
import org.apache.pulsar.testclient.ProxyProtocolConverter;
import picocli.CommandLine;

public abstract class PerformanceBaseArguments
extends CmdBase {
    @CommandLine.Option(names={"-u", "--service-url"}, description={"Pulsar Service URL"}, descriptionKey="brokerServiceUrl")
    public String serviceURL;
    @CommandLine.Option(names={"--auth-plugin"}, description={"Authentication plugin class name"}, descriptionKey="authPlugin")
    public String authPluginClassName;
    @CommandLine.Option(names={"--auth-params"}, description={"Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}\"."}, descriptionKey="authParams")
    public String authParams;
    @CommandLine.Option(names={"--ssl-factory-plugin"}, description={"Pulsar SSL Factory plugin class name"}, descriptionKey="sslFactoryPlugin")
    public String sslfactoryPlugin;
    @CommandLine.Option(names={"--ssl-factory-plugin-params"}, description={"Pulsar SSL Factory Plugin parameters in the format: \"{\"key1\":\"val1\",\"key2\":\"val2\"}\"."}, descriptionKey="sslFactoryPluginParams")
    public String sslFactoryPluginParams;
    @CommandLine.Option(names={"--trust-cert-file"}, description={"Path for the trusted TLS certificate file"}, descriptionKey="tlsTrustCertsFilePath")
    public String tlsTrustCertsFilePath = "";
    @CommandLine.Option(names={"--tls-allow-insecure"}, description={"Allow insecure TLS connection"}, descriptionKey="tlsAllowInsecureConnection")
    public Boolean tlsAllowInsecureConnection = null;
    @CommandLine.Option(names={"--tls-enable-hostname-verification"}, description={"Enable TLS hostname verification"}, descriptionKey="tlsEnableHostnameVerification")
    public Boolean tlsHostnameVerificationEnable = null;
    @CommandLine.Option(names={"-c", "--max-connections"}, description={"Max number of TCP connections to a single broker"})
    public int maxConnections = 1;
    @CommandLine.Option(names={"-i", "--stats-interval-seconds"}, description={"Statistics Interval Seconds. If 0, statistics will be disabled"})
    public long statsIntervalSeconds = 0L;
    @CommandLine.Option(names={"-ioThreads", "--num-io-threads"}, description={"Set the number of threads to be used for handling connections to brokers. The default value is 1."})
    public int ioThreads = 1;
    @CommandLine.Option(names={"-bw", "--busy-wait"}, description={"Enable Busy-Wait on the Pulsar client"})
    public boolean enableBusyWait = false;
    @CommandLine.Option(names={"--listener-name"}, description={"Listener name for the broker."})
    public String listenerName = null;
    @CommandLine.Option(names={"-lt", "--num-listener-threads"}, description={"Set the number of threads to be used for message listeners"})
    public int listenerThreads = 1;
    @CommandLine.Option(names={"-mlr", "--max-lookup-request"}, description={"Maximum number of lookup requests allowed on each broker connection to prevent overloading a broker"})
    public int maxLookupRequest = 50000;
    @CommandLine.Option(names={"--proxy-url"}, description={"Proxy-server URL to which to connect."}, descriptionKey="proxyServiceUrl")
    String proxyServiceURL = null;
    @CommandLine.Option(names={"--proxy-protocol"}, description={"Proxy protocol to select type of routing at proxy."}, descriptionKey="proxyProtocol", converter={ProxyProtocolConverter.class})
    ProxyProtocol proxyProtocol = null;
    @CommandLine.Option(names={"--auth_plugin"}, description={"Authentication plugin class name"}, hidden=true)
    public String deprecatedAuthPluginClassName;
    @CommandLine.Option(names={"-ml", "--memory-limit"}, description={"Configure the Pulsar client memory limit (eg: 32M, 64M)"}, converter={ByteUnitToLongConverter.class})
    public long memoryLimit;

    public PerformanceBaseArguments(String cmdName) {
        super(cmdName);
    }

    @Override
    public void validate() throws Exception {
        this.parseCLI();
    }

    public void parseCLI() {
        if (StringUtils.isBlank((CharSequence)this.authPluginClassName) && !StringUtils.isBlank((CharSequence)this.deprecatedAuthPluginClassName)) {
            this.authPluginClassName = this.deprecatedAuthPluginClassName;
        }
    }
}

