//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.19.4
// source: Function.proto

package api

import (
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type ProcessingGuarantees int32

const (
	ProcessingGuarantees_ATLEAST_ONCE     ProcessingGuarantees = 0 // [default value]
	ProcessingGuarantees_ATMOST_ONCE      ProcessingGuarantees = 1
	ProcessingGuarantees_EFFECTIVELY_ONCE ProcessingGuarantees = 2
	ProcessingGuarantees_MANUAL           ProcessingGuarantees = 3
)

// Enum value maps for ProcessingGuarantees.
var (
	ProcessingGuarantees_name = map[int32]string{
		0: "ATLEAST_ONCE",
		1: "ATMOST_ONCE",
		2: "EFFECTIVELY_ONCE",
		3: "MANUAL",
	}
	ProcessingGuarantees_value = map[string]int32{
		"ATLEAST_ONCE":     0,
		"ATMOST_ONCE":      1,
		"EFFECTIVELY_ONCE": 2,
		"MANUAL":           3,
	}
)

func (x ProcessingGuarantees) Enum() *ProcessingGuarantees {
	p := new(ProcessingGuarantees)
	*p = x
	return p
}

func (x ProcessingGuarantees) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProcessingGuarantees) Descriptor() protoreflect.EnumDescriptor {
	return file_Function_proto_enumTypes[0].Descriptor()
}

func (ProcessingGuarantees) Type() protoreflect.EnumType {
	return &file_Function_proto_enumTypes[0]
}

func (x ProcessingGuarantees) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProcessingGuarantees.Descriptor instead.
func (ProcessingGuarantees) EnumDescriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{0}
}

type SubscriptionType int32

const (
	SubscriptionType_SHARED     SubscriptionType = 0
	SubscriptionType_FAILOVER   SubscriptionType = 1
	SubscriptionType_KEY_SHARED SubscriptionType = 2
)

// Enum value maps for SubscriptionType.
var (
	SubscriptionType_name = map[int32]string{
		0: "SHARED",
		1: "FAILOVER",
		2: "KEY_SHARED",
	}
	SubscriptionType_value = map[string]int32{
		"SHARED":     0,
		"FAILOVER":   1,
		"KEY_SHARED": 2,
	}
)

func (x SubscriptionType) Enum() *SubscriptionType {
	p := new(SubscriptionType)
	*p = x
	return p
}

func (x SubscriptionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubscriptionType) Descriptor() protoreflect.EnumDescriptor {
	return file_Function_proto_enumTypes[1].Descriptor()
}

func (SubscriptionType) Type() protoreflect.EnumType {
	return &file_Function_proto_enumTypes[1]
}

func (x SubscriptionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubscriptionType.Descriptor instead.
func (SubscriptionType) EnumDescriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{1}
}

type SubscriptionPosition int32

const (
	SubscriptionPosition_LATEST   SubscriptionPosition = 0
	SubscriptionPosition_EARLIEST SubscriptionPosition = 1
)

// Enum value maps for SubscriptionPosition.
var (
	SubscriptionPosition_name = map[int32]string{
		0: "LATEST",
		1: "EARLIEST",
	}
	SubscriptionPosition_value = map[string]int32{
		"LATEST":   0,
		"EARLIEST": 1,
	}
)

func (x SubscriptionPosition) Enum() *SubscriptionPosition {
	p := new(SubscriptionPosition)
	*p = x
	return p
}

func (x SubscriptionPosition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubscriptionPosition) Descriptor() protoreflect.EnumDescriptor {
	return file_Function_proto_enumTypes[2].Descriptor()
}

func (SubscriptionPosition) Type() protoreflect.EnumType {
	return &file_Function_proto_enumTypes[2]
}

func (x SubscriptionPosition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubscriptionPosition.Descriptor instead.
func (SubscriptionPosition) EnumDescriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{2}
}

type CompressionType int32

const (
	CompressionType_LZ4    CompressionType = 0
	CompressionType_NONE   CompressionType = 1
	CompressionType_ZLIB   CompressionType = 2
	CompressionType_ZSTD   CompressionType = 3
	CompressionType_SNAPPY CompressionType = 4
)

// Enum value maps for CompressionType.
var (
	CompressionType_name = map[int32]string{
		0: "LZ4",
		1: "NONE",
		2: "ZLIB",
		3: "ZSTD",
		4: "SNAPPY",
	}
	CompressionType_value = map[string]int32{
		"LZ4":    0,
		"NONE":   1,
		"ZLIB":   2,
		"ZSTD":   3,
		"SNAPPY": 4,
	}
)

func (x CompressionType) Enum() *CompressionType {
	p := new(CompressionType)
	*p = x
	return p
}

func (x CompressionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompressionType) Descriptor() protoreflect.EnumDescriptor {
	return file_Function_proto_enumTypes[3].Descriptor()
}

func (CompressionType) Type() protoreflect.EnumType {
	return &file_Function_proto_enumTypes[3]
}

func (x CompressionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompressionType.Descriptor instead.
func (CompressionType) EnumDescriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{3}
}

type FunctionState int32

const (
	FunctionState_RUNNING FunctionState = 0
	FunctionState_STOPPED FunctionState = 1
)

// Enum value maps for FunctionState.
var (
	FunctionState_name = map[int32]string{
		0: "RUNNING",
		1: "STOPPED",
	}
	FunctionState_value = map[string]int32{
		"RUNNING": 0,
		"STOPPED": 1,
	}
)

func (x FunctionState) Enum() *FunctionState {
	p := new(FunctionState)
	*p = x
	return p
}

func (x FunctionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FunctionState) Descriptor() protoreflect.EnumDescriptor {
	return file_Function_proto_enumTypes[4].Descriptor()
}

func (FunctionState) Type() protoreflect.EnumType {
	return &file_Function_proto_enumTypes[4]
}

func (x FunctionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FunctionState.Descriptor instead.
func (FunctionState) EnumDescriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{4}
}

type FunctionDetails_Runtime int32

const (
	FunctionDetails_JAVA   FunctionDetails_Runtime = 0
	FunctionDetails_PYTHON FunctionDetails_Runtime = 1
	FunctionDetails_GO     FunctionDetails_Runtime = 3
)

// Enum value maps for FunctionDetails_Runtime.
var (
	FunctionDetails_Runtime_name = map[int32]string{
		0: "JAVA",
		1: "PYTHON",
		3: "GO",
	}
	FunctionDetails_Runtime_value = map[string]int32{
		"JAVA":   0,
		"PYTHON": 1,
		"GO":     3,
	}
)

func (x FunctionDetails_Runtime) Enum() *FunctionDetails_Runtime {
	p := new(FunctionDetails_Runtime)
	*p = x
	return p
}

func (x FunctionDetails_Runtime) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FunctionDetails_Runtime) Descriptor() protoreflect.EnumDescriptor {
	return file_Function_proto_enumTypes[5].Descriptor()
}

func (FunctionDetails_Runtime) Type() protoreflect.EnumType {
	return &file_Function_proto_enumTypes[5]
}

func (x FunctionDetails_Runtime) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FunctionDetails_Runtime.Descriptor instead.
func (FunctionDetails_Runtime) EnumDescriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{2, 0}
}

type FunctionDetails_ComponentType int32

const (
	FunctionDetails_UNKNOWN  FunctionDetails_ComponentType = 0
	FunctionDetails_FUNCTION FunctionDetails_ComponentType = 1
	FunctionDetails_SOURCE   FunctionDetails_ComponentType = 2
	FunctionDetails_SINK     FunctionDetails_ComponentType = 3
)

// Enum value maps for FunctionDetails_ComponentType.
var (
	FunctionDetails_ComponentType_name = map[int32]string{
		0: "UNKNOWN",
		1: "FUNCTION",
		2: "SOURCE",
		3: "SINK",
	}
	FunctionDetails_ComponentType_value = map[string]int32{
		"UNKNOWN":  0,
		"FUNCTION": 1,
		"SOURCE":   2,
		"SINK":     3,
	}
)

func (x FunctionDetails_ComponentType) Enum() *FunctionDetails_ComponentType {
	p := new(FunctionDetails_ComponentType)
	*p = x
	return p
}

func (x FunctionDetails_ComponentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FunctionDetails_ComponentType) Descriptor() protoreflect.EnumDescriptor {
	return file_Function_proto_enumTypes[6].Descriptor()
}

func (FunctionDetails_ComponentType) Type() protoreflect.EnumType {
	return &file_Function_proto_enumTypes[6]
}

func (x FunctionDetails_ComponentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FunctionDetails_ComponentType.Descriptor instead.
func (FunctionDetails_ComponentType) EnumDescriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{2, 1}
}

type CryptoSpec_FailureAction int32

const (
	CryptoSpec_FAIL    CryptoSpec_FailureAction = 0
	CryptoSpec_DISCARD CryptoSpec_FailureAction = 1
	CryptoSpec_CONSUME CryptoSpec_FailureAction = 2
	CryptoSpec_SEND    CryptoSpec_FailureAction = 10
)

// Enum value maps for CryptoSpec_FailureAction.
var (
	CryptoSpec_FailureAction_name = map[int32]string{
		0:  "FAIL",
		1:  "DISCARD",
		2:  "CONSUME",
		10: "SEND",
	}
	CryptoSpec_FailureAction_value = map[string]int32{
		"FAIL":    0,
		"DISCARD": 1,
		"CONSUME": 2,
		"SEND":    10,
	}
)

func (x CryptoSpec_FailureAction) Enum() *CryptoSpec_FailureAction {
	p := new(CryptoSpec_FailureAction)
	*p = x
	return p
}

func (x CryptoSpec_FailureAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CryptoSpec_FailureAction) Descriptor() protoreflect.EnumDescriptor {
	return file_Function_proto_enumTypes[7].Descriptor()
}

func (CryptoSpec_FailureAction) Type() protoreflect.EnumType {
	return &file_Function_proto_enumTypes[7]
}

func (x CryptoSpec_FailureAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CryptoSpec_FailureAction.Descriptor instead.
func (CryptoSpec_FailureAction) EnumDescriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{5, 0}
}

type Resources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cpu  float64 `protobuf:"fixed64,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	Ram  int64   `protobuf:"varint,2,opt,name=ram,proto3" json:"ram,omitempty"`
	Disk int64   `protobuf:"varint,3,opt,name=disk,proto3" json:"disk,omitempty"`
}

func (x *Resources) Reset() {
	*x = Resources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{0}
}

func (x *Resources) GetCpu() float64 {
	if x != nil {
		return x.Cpu
	}
	return 0
}

func (x *Resources) GetRam() int64 {
	if x != nil {
		return x.Ram
	}
	return 0
}

func (x *Resources) GetDisk() int64 {
	if x != nil {
		return x.Disk
	}
	return 0
}

type RetryDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxMessageRetries int32  `protobuf:"varint,1,opt,name=maxMessageRetries,proto3" json:"maxMessageRetries,omitempty"`
	DeadLetterTopic   string `protobuf:"bytes,2,opt,name=deadLetterTopic,proto3" json:"deadLetterTopic,omitempty"`
}

func (x *RetryDetails) Reset() {
	*x = RetryDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryDetails) ProtoMessage() {}

func (x *RetryDetails) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryDetails.ProtoReflect.Descriptor instead.
func (*RetryDetails) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{1}
}

func (x *RetryDetails) GetMaxMessageRetries() int32 {
	if x != nil {
		return x.MaxMessageRetries
	}
	return 0
}

func (x *RetryDetails) GetDeadLetterTopic() string {
	if x != nil {
		return x.DeadLetterTopic
	}
	return ""
}

type FunctionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Tenant               string                  `protobuf:"bytes,1,opt,name=tenant,proto3" json:"tenant,omitempty"`
	Namespace            string                  `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Name                 string                  `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	ClassName            string                  `protobuf:"bytes,4,opt,name=className,proto3" json:"className,omitempty"`
	LogTopic             string                  `protobuf:"bytes,5,opt,name=logTopic,proto3" json:"logTopic,omitempty"`
	ProcessingGuarantees ProcessingGuarantees    `protobuf:"varint,6,opt,name=processingGuarantees,proto3,enum=proto.ProcessingGuarantees" json:"processingGuarantees,omitempty"`
	UserConfig           string                  `protobuf:"bytes,7,opt,name=userConfig,proto3" json:"userConfig,omitempty"`
	SecretsMap           string                  `protobuf:"bytes,16,opt,name=secretsMap,proto3" json:"secretsMap,omitempty"`
	Runtime              FunctionDetails_Runtime `protobuf:"varint,8,opt,name=runtime,proto3,enum=proto.FunctionDetails_Runtime" json:"runtime,omitempty"`
	// Deprecated since, see https://github.com/apache/pulsar/issues/15560
	//
	AutoAck              bool                          `protobuf:"varint,9,opt,name=autoAck,proto3" json:"autoAck,omitempty"`
	Parallelism          int32                         `protobuf:"varint,10,opt,name=parallelism,proto3" json:"parallelism,omitempty"`
	Source               *SourceSpec                   `protobuf:"bytes,11,opt,name=source,proto3" json:"source,omitempty"`
	Sink                 *SinkSpec                     `protobuf:"bytes,12,opt,name=sink,proto3" json:"sink,omitempty"`
	Resources            *Resources                    `protobuf:"bytes,13,opt,name=resources,proto3" json:"resources,omitempty"`
	PackageUrl           string                        `protobuf:"bytes,14,opt,name=packageUrl,proto3" json:"packageUrl,omitempty"` //present only if function submitted with package-url
	RetryDetails         *RetryDetails                 `protobuf:"bytes,15,opt,name=retryDetails,proto3" json:"retryDetails,omitempty"`
	RuntimeFlags         string                        `protobuf:"bytes,17,opt,name=runtimeFlags,proto3" json:"runtimeFlags,omitempty"`
	ComponentType        FunctionDetails_ComponentType `protobuf:"varint,18,opt,name=componentType,proto3,enum=proto.FunctionDetails_ComponentType" json:"componentType,omitempty"`
	CustomRuntimeOptions string                        `protobuf:"bytes,19,opt,name=customRuntimeOptions,proto3" json:"customRuntimeOptions,omitempty"`
	// If specified, this will refer to an archive that is
	// already present in the server
	Builtin              string               `protobuf:"bytes,20,opt,name=builtin,proto3" json:"builtin,omitempty"`
	RetainOrdering       bool                 `protobuf:"varint,21,opt,name=retainOrdering,proto3" json:"retainOrdering,omitempty"`
	RetainKeyOrdering    bool                 `protobuf:"varint,22,opt,name=retainKeyOrdering,proto3" json:"retainKeyOrdering,omitempty"`
	SubscriptionPosition SubscriptionPosition `protobuf:"varint,23,opt,name=subscriptionPosition,proto3,enum=proto.SubscriptionPosition" json:"subscriptionPosition,omitempty"`
}

func (x *FunctionDetails) Reset() {
	*x = FunctionDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionDetails) ProtoMessage() {}

func (x *FunctionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionDetails.ProtoReflect.Descriptor instead.
func (*FunctionDetails) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{2}
}

func (x *FunctionDetails) GetTenant() string {
	if x != nil {
		return x.Tenant
	}
	return ""
}

func (x *FunctionDetails) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *FunctionDetails) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FunctionDetails) GetClassName() string {
	if x != nil {
		return x.ClassName
	}
	return ""
}

func (x *FunctionDetails) GetLogTopic() string {
	if x != nil {
		return x.LogTopic
	}
	return ""
}

func (x *FunctionDetails) GetProcessingGuarantees() ProcessingGuarantees {
	if x != nil {
		return x.ProcessingGuarantees
	}
	return ProcessingGuarantees_ATLEAST_ONCE
}

func (x *FunctionDetails) GetUserConfig() string {
	if x != nil {
		return x.UserConfig
	}
	return ""
}

func (x *FunctionDetails) GetSecretsMap() string {
	if x != nil {
		return x.SecretsMap
	}
	return ""
}

func (x *FunctionDetails) GetRuntime() FunctionDetails_Runtime {
	if x != nil {
		return x.Runtime
	}
	return FunctionDetails_JAVA
}

// Deprecated: Do not use.
func (x *FunctionDetails) GetAutoAck() bool {
	if x != nil {
		return x.AutoAck
	}
	return false
}

func (x *FunctionDetails) GetParallelism() int32 {
	if x != nil {
		return x.Parallelism
	}
	return 0
}

func (x *FunctionDetails) GetSource() *SourceSpec {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *FunctionDetails) GetSink() *SinkSpec {
	if x != nil {
		return x.Sink
	}
	return nil
}

func (x *FunctionDetails) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *FunctionDetails) GetPackageUrl() string {
	if x != nil {
		return x.PackageUrl
	}
	return ""
}

func (x *FunctionDetails) GetRetryDetails() *RetryDetails {
	if x != nil {
		return x.RetryDetails
	}
	return nil
}

func (x *FunctionDetails) GetRuntimeFlags() string {
	if x != nil {
		return x.RuntimeFlags
	}
	return ""
}

func (x *FunctionDetails) GetComponentType() FunctionDetails_ComponentType {
	if x != nil {
		return x.ComponentType
	}
	return FunctionDetails_UNKNOWN
}

func (x *FunctionDetails) GetCustomRuntimeOptions() string {
	if x != nil {
		return x.CustomRuntimeOptions
	}
	return ""
}

func (x *FunctionDetails) GetBuiltin() string {
	if x != nil {
		return x.Builtin
	}
	return ""
}

func (x *FunctionDetails) GetRetainOrdering() bool {
	if x != nil {
		return x.RetainOrdering
	}
	return false
}

func (x *FunctionDetails) GetRetainKeyOrdering() bool {
	if x != nil {
		return x.RetainKeyOrdering
	}
	return false
}

func (x *FunctionDetails) GetSubscriptionPosition() SubscriptionPosition {
	if x != nil {
		return x.SubscriptionPosition
	}
	return SubscriptionPosition_LATEST
}

type ConsumerSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SchemaType         string                          `protobuf:"bytes,1,opt,name=schemaType,proto3" json:"schemaType,omitempty"`
	SerdeClassName     string                          `protobuf:"bytes,2,opt,name=serdeClassName,proto3" json:"serdeClassName,omitempty"`
	IsRegexPattern     bool                            `protobuf:"varint,3,opt,name=isRegexPattern,proto3" json:"isRegexPattern,omitempty"`
	ReceiverQueueSize  *ConsumerSpec_ReceiverQueueSize `protobuf:"bytes,4,opt,name=receiverQueueSize,proto3" json:"receiverQueueSize,omitempty"`
	SchemaProperties   map[string]string               `protobuf:"bytes,5,rep,name=schemaProperties,proto3" json:"schemaProperties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ConsumerProperties map[string]string               `protobuf:"bytes,6,rep,name=consumerProperties,proto3" json:"consumerProperties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	CryptoSpec         *CryptoSpec                     `protobuf:"bytes,7,opt,name=cryptoSpec,proto3" json:"cryptoSpec,omitempty"`
	PoolMessages       bool                            `protobuf:"varint,8,opt,name=poolMessages,proto3" json:"poolMessages,omitempty"`
}

func (x *ConsumerSpec) Reset() {
	*x = ConsumerSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConsumerSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsumerSpec) ProtoMessage() {}

func (x *ConsumerSpec) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsumerSpec.ProtoReflect.Descriptor instead.
func (*ConsumerSpec) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{3}
}

func (x *ConsumerSpec) GetSchemaType() string {
	if x != nil {
		return x.SchemaType
	}
	return ""
}

func (x *ConsumerSpec) GetSerdeClassName() string {
	if x != nil {
		return x.SerdeClassName
	}
	return ""
}

func (x *ConsumerSpec) GetIsRegexPattern() bool {
	if x != nil {
		return x.IsRegexPattern
	}
	return false
}

func (x *ConsumerSpec) GetReceiverQueueSize() *ConsumerSpec_ReceiverQueueSize {
	if x != nil {
		return x.ReceiverQueueSize
	}
	return nil
}

func (x *ConsumerSpec) GetSchemaProperties() map[string]string {
	if x != nil {
		return x.SchemaProperties
	}
	return nil
}

func (x *ConsumerSpec) GetConsumerProperties() map[string]string {
	if x != nil {
		return x.ConsumerProperties
	}
	return nil
}

func (x *ConsumerSpec) GetCryptoSpec() *CryptoSpec {
	if x != nil {
		return x.CryptoSpec
	}
	return nil
}

func (x *ConsumerSpec) GetPoolMessages() bool {
	if x != nil {
		return x.PoolMessages
	}
	return false
}

type ProducerSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxPendingMessages                 int32           `protobuf:"varint,1,opt,name=maxPendingMessages,proto3" json:"maxPendingMessages,omitempty"`
	MaxPendingMessagesAcrossPartitions int32           `protobuf:"varint,2,opt,name=maxPendingMessagesAcrossPartitions,proto3" json:"maxPendingMessagesAcrossPartitions,omitempty"`
	UseThreadLocalProducers            bool            `protobuf:"varint,3,opt,name=useThreadLocalProducers,proto3" json:"useThreadLocalProducers,omitempty"`
	CryptoSpec                         *CryptoSpec     `protobuf:"bytes,4,opt,name=cryptoSpec,proto3" json:"cryptoSpec,omitempty"`
	BatchBuilder                       string          `protobuf:"bytes,5,opt,name=batchBuilder,proto3" json:"batchBuilder,omitempty"`
	CompressionType                    CompressionType `protobuf:"varint,6,opt,name=compressionType,proto3,enum=proto.CompressionType" json:"compressionType,omitempty"`
}

func (x *ProducerSpec) Reset() {
	*x = ProducerSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProducerSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProducerSpec) ProtoMessage() {}

func (x *ProducerSpec) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProducerSpec.ProtoReflect.Descriptor instead.
func (*ProducerSpec) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{4}
}

func (x *ProducerSpec) GetMaxPendingMessages() int32 {
	if x != nil {
		return x.MaxPendingMessages
	}
	return 0
}

func (x *ProducerSpec) GetMaxPendingMessagesAcrossPartitions() int32 {
	if x != nil {
		return x.MaxPendingMessagesAcrossPartitions
	}
	return 0
}

func (x *ProducerSpec) GetUseThreadLocalProducers() bool {
	if x != nil {
		return x.UseThreadLocalProducers
	}
	return false
}

func (x *ProducerSpec) GetCryptoSpec() *CryptoSpec {
	if x != nil {
		return x.CryptoSpec
	}
	return nil
}

func (x *ProducerSpec) GetBatchBuilder() string {
	if x != nil {
		return x.BatchBuilder
	}
	return ""
}

func (x *ProducerSpec) GetCompressionType() CompressionType {
	if x != nil {
		return x.CompressionType
	}
	return CompressionType_LZ4
}

type CryptoSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CryptoKeyReaderClassName string `protobuf:"bytes,1,opt,name=cryptoKeyReaderClassName,proto3" json:"cryptoKeyReaderClassName,omitempty"`
	CryptoKeyReaderConfig    string `protobuf:"bytes,2,opt,name=cryptoKeyReaderConfig,proto3" json:"cryptoKeyReaderConfig,omitempty"`
	// key names used by producer to encrypt data
	ProducerEncryptionKeyName []string `protobuf:"bytes,3,rep,name=producerEncryptionKeyName,proto3" json:"producerEncryptionKeyName,omitempty"`
	// define the action if producer fail to encrypt data
	// one of FAIL, SEND
	ProducerCryptoFailureAction CryptoSpec_FailureAction `protobuf:"varint,4,opt,name=producerCryptoFailureAction,proto3,enum=proto.CryptoSpec_FailureAction" json:"producerCryptoFailureAction,omitempty"`
	// define the action if consumer fail to decrypt data
	// one of FAIL, DISCARD, CONSUME
	ConsumerCryptoFailureAction CryptoSpec_FailureAction `protobuf:"varint,5,opt,name=consumerCryptoFailureAction,proto3,enum=proto.CryptoSpec_FailureAction" json:"consumerCryptoFailureAction,omitempty"`
}

func (x *CryptoSpec) Reset() {
	*x = CryptoSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CryptoSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoSpec) ProtoMessage() {}

func (x *CryptoSpec) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoSpec.ProtoReflect.Descriptor instead.
func (*CryptoSpec) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{5}
}

func (x *CryptoSpec) GetCryptoKeyReaderClassName() string {
	if x != nil {
		return x.CryptoKeyReaderClassName
	}
	return ""
}

func (x *CryptoSpec) GetCryptoKeyReaderConfig() string {
	if x != nil {
		return x.CryptoKeyReaderConfig
	}
	return ""
}

func (x *CryptoSpec) GetProducerEncryptionKeyName() []string {
	if x != nil {
		return x.ProducerEncryptionKeyName
	}
	return nil
}

func (x *CryptoSpec) GetProducerCryptoFailureAction() CryptoSpec_FailureAction {
	if x != nil {
		return x.ProducerCryptoFailureAction
	}
	return CryptoSpec_FAIL
}

func (x *CryptoSpec) GetConsumerCryptoFailureAction() CryptoSpec_FailureAction {
	if x != nil {
		return x.ConsumerCryptoFailureAction
	}
	return CryptoSpec_FAIL
}

type SourceSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClassName string `protobuf:"bytes,1,opt,name=className,proto3" json:"className,omitempty"`
	// map in json format
	Configs       string `protobuf:"bytes,2,opt,name=configs,proto3" json:"configs,omitempty"`
	TypeClassName string `protobuf:"bytes,5,opt,name=typeClassName,proto3" json:"typeClassName,omitempty"`
	// configs used only when source feeds into functions
	SubscriptionType SubscriptionType `protobuf:"varint,3,opt,name=subscriptionType,proto3,enum=proto.SubscriptionType" json:"subscriptionType,omitempty"`
	// @deprecated -- use topicsToSchema
	//
	// Deprecated: Do not use.
	TopicsToSerDeClassName map[string]string `protobuf:"bytes,4,rep,name=topicsToSerDeClassName,proto3" json:"topicsToSerDeClassName,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// *
	InputSpecs map[string]*ConsumerSpec `protobuf:"bytes,10,rep,name=inputSpecs,proto3" json:"inputSpecs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	TimeoutMs  uint64                   `protobuf:"varint,6,opt,name=timeoutMs,proto3" json:"timeoutMs,omitempty"`
	// Deprecated: Do not use.
	TopicsPattern string `protobuf:"bytes,7,opt,name=topicsPattern,proto3" json:"topicsPattern,omitempty"`
	// If specified, this will refer to an archive that is
	// already present in the server
	Builtin                      string               `protobuf:"bytes,8,opt,name=builtin,proto3" json:"builtin,omitempty"`
	SubscriptionName             string               `protobuf:"bytes,9,opt,name=subscriptionName,proto3" json:"subscriptionName,omitempty"`
	CleanupSubscription          bool                 `protobuf:"varint,11,opt,name=cleanupSubscription,proto3" json:"cleanupSubscription,omitempty"`
	SubscriptionPosition         SubscriptionPosition `protobuf:"varint,12,opt,name=subscriptionPosition,proto3,enum=proto.SubscriptionPosition" json:"subscriptionPosition,omitempty"`
	NegativeAckRedeliveryDelayMs uint64               `protobuf:"varint,13,opt,name=negativeAckRedeliveryDelayMs,proto3" json:"negativeAckRedeliveryDelayMs,omitempty"`
	SkipToLatest                 bool                 `protobuf:"varint,14,opt,name=skipToLatest,proto3" json:"skipToLatest,omitempty"`
}

func (x *SourceSpec) Reset() {
	*x = SourceSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceSpec) ProtoMessage() {}

func (x *SourceSpec) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceSpec.ProtoReflect.Descriptor instead.
func (*SourceSpec) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{6}
}

func (x *SourceSpec) GetClassName() string {
	if x != nil {
		return x.ClassName
	}
	return ""
}

func (x *SourceSpec) GetConfigs() string {
	if x != nil {
		return x.Configs
	}
	return ""
}

func (x *SourceSpec) GetTypeClassName() string {
	if x != nil {
		return x.TypeClassName
	}
	return ""
}

func (x *SourceSpec) GetSubscriptionType() SubscriptionType {
	if x != nil {
		return x.SubscriptionType
	}
	return SubscriptionType_SHARED
}

// Deprecated: Do not use.
func (x *SourceSpec) GetTopicsToSerDeClassName() map[string]string {
	if x != nil {
		return x.TopicsToSerDeClassName
	}
	return nil
}

func (x *SourceSpec) GetInputSpecs() map[string]*ConsumerSpec {
	if x != nil {
		return x.InputSpecs
	}
	return nil
}

func (x *SourceSpec) GetTimeoutMs() uint64 {
	if x != nil {
		return x.TimeoutMs
	}
	return 0
}

// Deprecated: Do not use.
func (x *SourceSpec) GetTopicsPattern() string {
	if x != nil {
		return x.TopicsPattern
	}
	return ""
}

func (x *SourceSpec) GetBuiltin() string {
	if x != nil {
		return x.Builtin
	}
	return ""
}

func (x *SourceSpec) GetSubscriptionName() string {
	if x != nil {
		return x.SubscriptionName
	}
	return ""
}

func (x *SourceSpec) GetCleanupSubscription() bool {
	if x != nil {
		return x.CleanupSubscription
	}
	return false
}

func (x *SourceSpec) GetSubscriptionPosition() SubscriptionPosition {
	if x != nil {
		return x.SubscriptionPosition
	}
	return SubscriptionPosition_LATEST
}

func (x *SourceSpec) GetNegativeAckRedeliveryDelayMs() uint64 {
	if x != nil {
		return x.NegativeAckRedeliveryDelayMs
	}
	return 0
}

func (x *SourceSpec) GetSkipToLatest() bool {
	if x != nil {
		return x.SkipToLatest
	}
	return false
}

type SinkSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClassName string `protobuf:"bytes,1,opt,name=className,proto3" json:"className,omitempty"`
	// map in json format
	Configs       string `protobuf:"bytes,2,opt,name=configs,proto3" json:"configs,omitempty"`
	TypeClassName string `protobuf:"bytes,5,opt,name=typeClassName,proto3" json:"typeClassName,omitempty"`
	// configs used only when functions output to sink
	Topic          string        `protobuf:"bytes,3,opt,name=topic,proto3" json:"topic,omitempty"`
	ProducerSpec   *ProducerSpec `protobuf:"bytes,11,opt,name=producerSpec,proto3" json:"producerSpec,omitempty"`
	SerDeClassName string        `protobuf:"bytes,4,opt,name=serDeClassName,proto3" json:"serDeClassName,omitempty"`
	// If specified, this will refer to an archive that is
	// already present in the server
	Builtin string `protobuf:"bytes,6,opt,name=builtin,proto3" json:"builtin,omitempty"`
	// *
	// Builtin schema type or custom schema class name
	SchemaType                   string            `protobuf:"bytes,7,opt,name=schemaType,proto3" json:"schemaType,omitempty"`
	ForwardSourceMessageProperty bool              `protobuf:"varint,8,opt,name=forwardSourceMessageProperty,proto3" json:"forwardSourceMessageProperty,omitempty"`
	SchemaProperties             map[string]string `protobuf:"bytes,9,rep,name=schemaProperties,proto3" json:"schemaProperties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ConsumerProperties           map[string]string `protobuf:"bytes,10,rep,name=consumerProperties,proto3" json:"consumerProperties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SinkSpec) Reset() {
	*x = SinkSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SinkSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SinkSpec) ProtoMessage() {}

func (x *SinkSpec) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SinkSpec.ProtoReflect.Descriptor instead.
func (*SinkSpec) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{7}
}

func (x *SinkSpec) GetClassName() string {
	if x != nil {
		return x.ClassName
	}
	return ""
}

func (x *SinkSpec) GetConfigs() string {
	if x != nil {
		return x.Configs
	}
	return ""
}

func (x *SinkSpec) GetTypeClassName() string {
	if x != nil {
		return x.TypeClassName
	}
	return ""
}

func (x *SinkSpec) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *SinkSpec) GetProducerSpec() *ProducerSpec {
	if x != nil {
		return x.ProducerSpec
	}
	return nil
}

func (x *SinkSpec) GetSerDeClassName() string {
	if x != nil {
		return x.SerDeClassName
	}
	return ""
}

func (x *SinkSpec) GetBuiltin() string {
	if x != nil {
		return x.Builtin
	}
	return ""
}

func (x *SinkSpec) GetSchemaType() string {
	if x != nil {
		return x.SchemaType
	}
	return ""
}

func (x *SinkSpec) GetForwardSourceMessageProperty() bool {
	if x != nil {
		return x.ForwardSourceMessageProperty
	}
	return false
}

func (x *SinkSpec) GetSchemaProperties() map[string]string {
	if x != nil {
		return x.SchemaProperties
	}
	return nil
}

func (x *SinkSpec) GetConsumerProperties() map[string]string {
	if x != nil {
		return x.ConsumerProperties
	}
	return nil
}

type PackageLocationMetaData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PackagePath      string `protobuf:"bytes,1,opt,name=packagePath,proto3" json:"packagePath,omitempty"`
	OriginalFileName string `protobuf:"bytes,2,opt,name=originalFileName,proto3" json:"originalFileName,omitempty"`
}

func (x *PackageLocationMetaData) Reset() {
	*x = PackageLocationMetaData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageLocationMetaData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageLocationMetaData) ProtoMessage() {}

func (x *PackageLocationMetaData) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageLocationMetaData.ProtoReflect.Descriptor instead.
func (*PackageLocationMetaData) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{8}
}

func (x *PackageLocationMetaData) GetPackagePath() string {
	if x != nil {
		return x.PackagePath
	}
	return ""
}

func (x *PackageLocationMetaData) GetOriginalFileName() string {
	if x != nil {
		return x.OriginalFileName
	}
	return ""
}

type FunctionMetaData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FunctionDetails                  *FunctionDetails            `protobuf:"bytes,1,opt,name=functionDetails,proto3" json:"functionDetails,omitempty"`
	PackageLocation                  *PackageLocationMetaData    `protobuf:"bytes,2,opt,name=packageLocation,proto3" json:"packageLocation,omitempty"`
	Version                          uint64                      `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	CreateTime                       uint64                      `protobuf:"varint,4,opt,name=createTime,proto3" json:"createTime,omitempty"`
	InstanceStates                   map[int32]FunctionState     `protobuf:"bytes,5,rep,name=instanceStates,proto3" json:"instanceStates,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=proto.FunctionState"`
	FunctionAuthSpec                 *FunctionAuthenticationSpec `protobuf:"bytes,6,opt,name=functionAuthSpec,proto3" json:"functionAuthSpec,omitempty"`
	TransformFunctionPackageLocation *PackageLocationMetaData    `protobuf:"bytes,7,opt,name=transformFunctionPackageLocation,proto3" json:"transformFunctionPackageLocation,omitempty"`
}

func (x *FunctionMetaData) Reset() {
	*x = FunctionMetaData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionMetaData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionMetaData) ProtoMessage() {}

func (x *FunctionMetaData) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionMetaData.ProtoReflect.Descriptor instead.
func (*FunctionMetaData) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{9}
}

func (x *FunctionMetaData) GetFunctionDetails() *FunctionDetails {
	if x != nil {
		return x.FunctionDetails
	}
	return nil
}

func (x *FunctionMetaData) GetPackageLocation() *PackageLocationMetaData {
	if x != nil {
		return x.PackageLocation
	}
	return nil
}

func (x *FunctionMetaData) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *FunctionMetaData) GetCreateTime() uint64 {
	if x != nil {
		return x.CreateTime
	}
	return 0
}

func (x *FunctionMetaData) GetInstanceStates() map[int32]FunctionState {
	if x != nil {
		return x.InstanceStates
	}
	return nil
}

func (x *FunctionMetaData) GetFunctionAuthSpec() *FunctionAuthenticationSpec {
	if x != nil {
		return x.FunctionAuthSpec
	}
	return nil
}

func (x *FunctionMetaData) GetTransformFunctionPackageLocation() *PackageLocationMetaData {
	if x != nil {
		return x.TransformFunctionPackageLocation
	}
	return nil
}

type FunctionAuthenticationSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// *
	// function authentication related data that the function authentication provider
	// needs to cache/distribute to all workers support function authentication.
	// Depending on the function authentication provider implementation, this can be the actual auth credentials
	// or a pointer to the auth credentials that this function should use
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// *
	// classname of the function auth provicer this data is relevant to
	Provider string `protobuf:"bytes,2,opt,name=provider,proto3" json:"provider,omitempty"`
}

func (x *FunctionAuthenticationSpec) Reset() {
	*x = FunctionAuthenticationSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FunctionAuthenticationSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionAuthenticationSpec) ProtoMessage() {}

func (x *FunctionAuthenticationSpec) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionAuthenticationSpec.ProtoReflect.Descriptor instead.
func (*FunctionAuthenticationSpec) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{10}
}

func (x *FunctionAuthenticationSpec) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *FunctionAuthenticationSpec) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FunctionMetaData *FunctionMetaData `protobuf:"bytes,1,opt,name=functionMetaData,proto3" json:"functionMetaData,omitempty"`
	InstanceId       int32             `protobuf:"varint,2,opt,name=instanceId,proto3" json:"instanceId,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{11}
}

func (x *Instance) GetFunctionMetaData() *FunctionMetaData {
	if x != nil {
		return x.FunctionMetaData
	}
	return nil
}

func (x *Instance) GetInstanceId() int32 {
	if x != nil {
		return x.InstanceId
	}
	return 0
}

type Assignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	WorkerId string    `protobuf:"bytes,2,opt,name=workerId,proto3" json:"workerId,omitempty"`
}

func (x *Assignment) Reset() {
	*x = Assignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Assignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Assignment) ProtoMessage() {}

func (x *Assignment) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Assignment.ProtoReflect.Descriptor instead.
func (*Assignment) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{12}
}

func (x *Assignment) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *Assignment) GetWorkerId() string {
	if x != nil {
		return x.WorkerId
	}
	return ""
}

type ConsumerSpec_ReceiverQueueSize struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value int32 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ConsumerSpec_ReceiverQueueSize) Reset() {
	*x = ConsumerSpec_ReceiverQueueSize{}
	if protoimpl.UnsafeEnabled {
		mi := &file_Function_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConsumerSpec_ReceiverQueueSize) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsumerSpec_ReceiverQueueSize) ProtoMessage() {}

func (x *ConsumerSpec_ReceiverQueueSize) ProtoReflect() protoreflect.Message {
	mi := &file_Function_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsumerSpec_ReceiverQueueSize.ProtoReflect.Descriptor instead.
func (*ConsumerSpec_ReceiverQueueSize) Descriptor() ([]byte, []int) {
	return file_Function_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ConsumerSpec_ReceiverQueueSize) GetValue() int32 {
	if x != nil {
		return x.Value
	}
	return 0
}

var File_Function_proto protoreflect.FileDescriptor

var file_Function_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x05, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x43, 0x0a, 0x09, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x61, 0x6d, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x03, 0x72, 0x61, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x69, 0x73, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x22, 0x66, 0x0a, 0x0c,
	0x52, 0x65, 0x74, 0x72, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x11,
	0x6d, 0x61, 0x78, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x0f, 0x64, 0x65,
	0x61, 0x64, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x61, 0x64, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x22, 0xc9, 0x08, 0x0a, 0x0f, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x4f, 0x0a, 0x14,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x47, 0x75, 0x61, 0x72, 0x61, 0x6e,
	0x74, 0x65, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x47, 0x75, 0x61,
	0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x47, 0x75, 0x61, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x12, 0x1e, 0x0a,
	0x0a, 0x75, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a,
	0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x4d, 0x61, 0x70, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x4d, 0x61, 0x70, 0x12, 0x38, 0x0a,
	0x07, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x07,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x61, 0x75, 0x74, 0x6f, 0x41,
	0x63, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x61, 0x75,
	0x74, 0x6f, 0x41, 0x63, 0x6b, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65,
	0x6c, 0x69, 0x73, 0x6d, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x61,
	0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x12, 0x29, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x23, 0x0a, 0x04, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x69, 0x6e, 0x6b, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x04, 0x73, 0x69, 0x6e, 0x6b, 0x12, 0x2e, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x55, 0x72, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x37, 0x0a, 0x0c, 0x72, 0x65, 0x74, 0x72, 0x79,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x52, 0x0c, 0x72, 0x65, 0x74, 0x72, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x22, 0x0a, 0x0c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46,
	0x6c, 0x61, 0x67, 0x73, 0x12, 0x4a, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x32, 0x0a, 0x14, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x69, 0x6e, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x69, 0x6e, 0x12, 0x26,
	0x0a, 0x0e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x2c, 0x0a, 0x11, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e,
	0x4b, 0x65, 0x79, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x12, 0x4f, 0x0a, 0x14, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x14, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x27, 0x0a, 0x07, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x12, 0x08, 0x0a, 0x04, 0x4a, 0x41, 0x56, 0x41, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x59,
	0x54, 0x48, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x47, 0x4f, 0x10, 0x03, 0x22, 0x40,
	0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x49, 0x4e, 0x4b, 0x10, 0x03,
	0x22, 0x95, 0x05, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x54, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x26, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x64, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x64, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x69, 0x73, 0x52,
	0x65, 0x67, 0x65, 0x78, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0e, 0x69, 0x73, 0x52, 0x65, 0x67, 0x65, 0x78, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x6e, 0x12, 0x53, 0x0a, 0x11, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x51, 0x75, 0x65, 0x75, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x52, 0x11, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x55, 0x0a, 0x10, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x5b, 0x0a,
	0x12, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x0a, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x53, 0x70, 0x65, 0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x0a, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x53, 0x70, 0x65, 0x63, 0x12, 0x22, 0x0a,
	0x0c, 0x70, 0x6f, 0x6f, 0x6c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x70, 0x6f, 0x6f, 0x6c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x73, 0x1a, 0x29, 0x0a, 0x11, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x72, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x43, 0x0a, 0x15,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x45, 0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xe1, 0x02, 0x0a, 0x0c, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2e, 0x0a, 0x12, 0x6d, 0x61, 0x78,
	0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x6d, 0x61, 0x78, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x22, 0x6d, 0x61, 0x78,
	0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x41,
	0x63, 0x72, 0x6f, 0x73, 0x73, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x22, 0x6d, 0x61, 0x78, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x41, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x38, 0x0a, 0x17, 0x75, 0x73, 0x65,
	0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x75, 0x73, 0x65, 0x54,
	0x68, 0x72, 0x65, 0x61, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x65, 0x72, 0x73, 0x12, 0x31, 0x0a, 0x0a, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x53, 0x70, 0x65,
	0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0a, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x53, 0x70, 0x65, 0x63, 0x12, 0x22, 0x0a, 0x0c, 0x62, 0x61, 0x74, 0x63, 0x68, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x6f,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0xc1, 0x03, 0x0a,
	0x0a, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3a, 0x0a, 0x18, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x61, 0x64, 0x65, 0x72, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x61, 0x64, 0x65, 0x72, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x15, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x61, 0x64, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x61, 0x64, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a,
	0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x1b, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x1b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61,
	0x0a, 0x1b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1b, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x43, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x3d, 0x0a, 0x0d, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x41, 0x49, 0x4c, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x44, 0x49, 0x53, 0x43, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x4e,
	0x53, 0x55, 0x4d, 0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x45, 0x4e, 0x44, 0x10, 0x0a,
	0x22, 0xf5, 0x06, 0x0a, 0x0a, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x1c, 0x0a, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x74, 0x79, 0x70, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x74, 0x79, 0x70, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a,
	0x10, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x10, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x69, 0x0a, 0x16, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x54, 0x6f, 0x53, 0x65,
	0x72, 0x44, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x54, 0x6f, 0x53, 0x65,
	0x72, 0x44, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x16, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x54, 0x6f, 0x53,
	0x65, 0x72, 0x44, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a,
	0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x70, 0x65, 0x63, 0x73,
	0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x73, 0x12, 0x28,
	0x0a, 0x0d, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x73, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x75, 0x69, 0x6c,
	0x74, 0x69, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x75, 0x69, 0x6c, 0x74,
	0x69, 0x6e, 0x12, 0x2a, 0x0a, 0x10, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30,
	0x0a, 0x13, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x75, 0x70, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x63, 0x6c, 0x65,
	0x61, 0x6e, 0x75, 0x70, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4f, 0x0a, 0x14, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x42, 0x0a, 0x1c, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x41, 0x63, 0x6b,
	0x52, 0x65, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x4d,
	0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x04, 0x52, 0x1c, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x41, 0x63, 0x6b, 0x52, 0x65, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x44, 0x65,
	0x6c, 0x61, 0x79, 0x4d, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x6b, 0x69, 0x70, 0x54, 0x6f, 0x4c,
	0x61, 0x74, 0x65, 0x73, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x73, 0x6b, 0x69,
	0x70, 0x54, 0x6f, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x1a, 0x49, 0x0a, 0x1b, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x73, 0x54, 0x6f, 0x53, 0x65, 0x72, 0x44, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e,
	0x61, 0x6d, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x52, 0x0a, 0x0f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x29, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x95, 0x05, 0x0a, 0x08, 0x53, 0x69, 0x6e,
	0x6b, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x24, 0x0a,
	0x0d, 0x74, 0x79, 0x70, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x79, 0x70, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x37, 0x0a, 0x0c, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x26, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x44, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x44,
	0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x75,
	0x69, 0x6c, 0x74, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x75, 0x69,
	0x6c, 0x74, 0x69, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x54, 0x79,
	0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x42, 0x0a, 0x1c, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1c, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x51, 0x0a, 0x10, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x69, 0x6e, 0x6b, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x12, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x53, 0x69, 0x6e, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65,
	0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x1a, 0x43, 0x0a, 0x15, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x45, 0x0a, 0x17, 0x43, 0x6f, 0x6e,
	0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x67, 0x0a, 0x17, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x12, 0x20, 0x0a, 0x0b, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x50, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x2a, 0x0a,
	0x10, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x46, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xc1, 0x04, 0x0a, 0x10, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x12, 0x40,
	0x0a, 0x0f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52,
	0x0f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x48, 0x0a, 0x0f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x44, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x10, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x75, 0x74, 0x68, 0x53, 0x70, 0x65, 0x63, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x10, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x75, 0x74, 0x68, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6a, 0x0a, 0x20, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x57, 0x0a, 0x13, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2a, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x4c, 0x0a,
	0x1a, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x22, 0x6f, 0x0a, 0x08, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x43, 0x0a, 0x10, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x10, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1e, 0x0a, 0x0a,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x22, 0x55, 0x0a, 0x0a,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x49, 0x64, 0x2a, 0x5b, 0x0a, 0x14, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x47, 0x75, 0x61, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x0c, 0x41,
	0x54, 0x4c, 0x45, 0x41, 0x53, 0x54, 0x5f, 0x4f, 0x4e, 0x43, 0x45, 0x10, 0x00, 0x12, 0x0f, 0x0a,
	0x0b, 0x41, 0x54, 0x4d, 0x4f, 0x53, 0x54, 0x5f, 0x4f, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x14,
	0x0a, 0x10, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x4c, 0x59, 0x5f, 0x4f, 0x4e,
	0x43, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x10, 0x03,
	0x2a, 0x3c, 0x0a, 0x10, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x46, 0x41, 0x49, 0x4c, 0x4f, 0x56, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x4b, 0x45, 0x59, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x10, 0x02, 0x2a, 0x30,
	0x0a, 0x14, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x41, 0x54, 0x45, 0x53, 0x54,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x41, 0x52, 0x4c, 0x49, 0x45, 0x53, 0x54, 0x10, 0x01,
	0x2a, 0x44, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x5a, 0x34, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x5a, 0x4c, 0x49, 0x42, 0x10, 0x02,
	0x12, 0x08, 0x0a, 0x04, 0x5a, 0x53, 0x54, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x4e,
	0x41, 0x50, 0x50, 0x59, 0x10, 0x04, 0x2a, 0x29, 0x0a, 0x0d, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10,
	0x01, 0x42, 0x2d, 0x0a, 0x21, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x70, 0x75, 0x6c, 0x73, 0x61, 0x72, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42, 0x08, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_Function_proto_rawDescOnce sync.Once
	file_Function_proto_rawDescData = file_Function_proto_rawDesc
)

func file_Function_proto_rawDescGZIP() []byte {
	file_Function_proto_rawDescOnce.Do(func() {
		file_Function_proto_rawDescData = protoimpl.X.CompressGZIP(file_Function_proto_rawDescData)
	})
	return file_Function_proto_rawDescData
}

var file_Function_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_Function_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_Function_proto_goTypes = []interface{}{
	(ProcessingGuarantees)(0),              // 0: proto.ProcessingGuarantees
	(SubscriptionType)(0),                  // 1: proto.SubscriptionType
	(SubscriptionPosition)(0),              // 2: proto.SubscriptionPosition
	(CompressionType)(0),                   // 3: proto.CompressionType
	(FunctionState)(0),                     // 4: proto.FunctionState
	(FunctionDetails_Runtime)(0),           // 5: proto.FunctionDetails.Runtime
	(FunctionDetails_ComponentType)(0),     // 6: proto.FunctionDetails.ComponentType
	(CryptoSpec_FailureAction)(0),          // 7: proto.CryptoSpec.FailureAction
	(*Resources)(nil),                      // 8: proto.Resources
	(*RetryDetails)(nil),                   // 9: proto.RetryDetails
	(*FunctionDetails)(nil),                // 10: proto.FunctionDetails
	(*ConsumerSpec)(nil),                   // 11: proto.ConsumerSpec
	(*ProducerSpec)(nil),                   // 12: proto.ProducerSpec
	(*CryptoSpec)(nil),                     // 13: proto.CryptoSpec
	(*SourceSpec)(nil),                     // 14: proto.SourceSpec
	(*SinkSpec)(nil),                       // 15: proto.SinkSpec
	(*PackageLocationMetaData)(nil),        // 16: proto.PackageLocationMetaData
	(*FunctionMetaData)(nil),               // 17: proto.FunctionMetaData
	(*FunctionAuthenticationSpec)(nil),     // 18: proto.FunctionAuthenticationSpec
	(*Instance)(nil),                       // 19: proto.Instance
	(*Assignment)(nil),                     // 20: proto.Assignment
	(*ConsumerSpec_ReceiverQueueSize)(nil), // 21: proto.ConsumerSpec.ReceiverQueueSize
	nil,                                    // 22: proto.ConsumerSpec.SchemaPropertiesEntry
	nil,                                    // 23: proto.ConsumerSpec.ConsumerPropertiesEntry
	nil,                                    // 24: proto.SourceSpec.TopicsToSerDeClassNameEntry
	nil,                                    // 25: proto.SourceSpec.InputSpecsEntry
	nil,                                    // 26: proto.SinkSpec.SchemaPropertiesEntry
	nil,                                    // 27: proto.SinkSpec.ConsumerPropertiesEntry
	nil,                                    // 28: proto.FunctionMetaData.InstanceStatesEntry
}
var file_Function_proto_depIdxs = []int32{
	0,  // 0: proto.FunctionDetails.processingGuarantees:type_name -> proto.ProcessingGuarantees
	5,  // 1: proto.FunctionDetails.runtime:type_name -> proto.FunctionDetails.Runtime
	14, // 2: proto.FunctionDetails.source:type_name -> proto.SourceSpec
	15, // 3: proto.FunctionDetails.sink:type_name -> proto.SinkSpec
	8,  // 4: proto.FunctionDetails.resources:type_name -> proto.Resources
	9,  // 5: proto.FunctionDetails.retryDetails:type_name -> proto.RetryDetails
	6,  // 6: proto.FunctionDetails.componentType:type_name -> proto.FunctionDetails.ComponentType
	2,  // 7: proto.FunctionDetails.subscriptionPosition:type_name -> proto.SubscriptionPosition
	21, // 8: proto.ConsumerSpec.receiverQueueSize:type_name -> proto.ConsumerSpec.ReceiverQueueSize
	22, // 9: proto.ConsumerSpec.schemaProperties:type_name -> proto.ConsumerSpec.SchemaPropertiesEntry
	23, // 10: proto.ConsumerSpec.consumerProperties:type_name -> proto.ConsumerSpec.ConsumerPropertiesEntry
	13, // 11: proto.ConsumerSpec.cryptoSpec:type_name -> proto.CryptoSpec
	13, // 12: proto.ProducerSpec.cryptoSpec:type_name -> proto.CryptoSpec
	3,  // 13: proto.ProducerSpec.compressionType:type_name -> proto.CompressionType
	7,  // 14: proto.CryptoSpec.producerCryptoFailureAction:type_name -> proto.CryptoSpec.FailureAction
	7,  // 15: proto.CryptoSpec.consumerCryptoFailureAction:type_name -> proto.CryptoSpec.FailureAction
	1,  // 16: proto.SourceSpec.subscriptionType:type_name -> proto.SubscriptionType
	24, // 17: proto.SourceSpec.topicsToSerDeClassName:type_name -> proto.SourceSpec.TopicsToSerDeClassNameEntry
	25, // 18: proto.SourceSpec.inputSpecs:type_name -> proto.SourceSpec.InputSpecsEntry
	2,  // 19: proto.SourceSpec.subscriptionPosition:type_name -> proto.SubscriptionPosition
	12, // 20: proto.SinkSpec.producerSpec:type_name -> proto.ProducerSpec
	26, // 21: proto.SinkSpec.schemaProperties:type_name -> proto.SinkSpec.SchemaPropertiesEntry
	27, // 22: proto.SinkSpec.consumerProperties:type_name -> proto.SinkSpec.ConsumerPropertiesEntry
	10, // 23: proto.FunctionMetaData.functionDetails:type_name -> proto.FunctionDetails
	16, // 24: proto.FunctionMetaData.packageLocation:type_name -> proto.PackageLocationMetaData
	28, // 25: proto.FunctionMetaData.instanceStates:type_name -> proto.FunctionMetaData.InstanceStatesEntry
	18, // 26: proto.FunctionMetaData.functionAuthSpec:type_name -> proto.FunctionAuthenticationSpec
	16, // 27: proto.FunctionMetaData.transformFunctionPackageLocation:type_name -> proto.PackageLocationMetaData
	17, // 28: proto.Instance.functionMetaData:type_name -> proto.FunctionMetaData
	19, // 29: proto.Assignment.instance:type_name -> proto.Instance
	11, // 30: proto.SourceSpec.InputSpecsEntry.value:type_name -> proto.ConsumerSpec
	4,  // 31: proto.FunctionMetaData.InstanceStatesEntry.value:type_name -> proto.FunctionState
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_Function_proto_init() }
func file_Function_proto_init() {
	if File_Function_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_Function_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConsumerSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProducerSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CryptoSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SinkSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageLocationMetaData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionMetaData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FunctionAuthenticationSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Assignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_Function_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConsumerSpec_ReceiverQueueSize); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_Function_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_Function_proto_goTypes,
		DependencyIndexes: file_Function_proto_depIdxs,
		EnumInfos:         file_Function_proto_enumTypes,
		MessageInfos:      file_Function_proto_msgTypes,
	}.Build()
	File_Function_proto = out.File
	file_Function_proto_rawDesc = nil
	file_Function_proto_goTypes = nil
	file_Function_proto_depIdxs = nil
}
