/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.FilterHelper;

public class StreamValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        COSDocument cosDocument = ctx.getDocument().getDocument();
        List objectKeys = cosDocument.getXrefTable().entrySet().stream().filter(e -> (Long)e.getValue() > 0L).sorted(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).collect(Collectors.toList());
        for (COSObjectKey objectKey : objectKeys) {
            COSBase cBase = cosDocument.getObjectFromPool(objectKey).getObject();
            if (!(cBase instanceof COSStream)) continue;
            this.validateStreamObject(ctx, cBase);
        }
    }

    public void validateStreamObject(PreflightContext context, COSBase cObj) {
        COSStream streamObj = (COSStream)cObj;
        this.checkDictionaryEntries(context, streamObj);
        this.checkFilters(streamObj, context);
    }

    protected void checkFilters(COSStream stream, PreflightContext context) {
        COSBase bFilter = stream.getDictionaryObject(COSName.FILTER);
        if (bFilter instanceof COSArray) {
            COSArray afName = (COSArray)bFilter;
            for (int i = 0; i < afName.size(); ++i) {
                FilterHelper.isAuthorizedFilter(context, afName.getString(i));
            }
        } else if (bFilter instanceof COSName) {
            String fName = ((COSName)bFilter).getName();
            FilterHelper.isAuthorizedFilter(context, fName);
        } else if (bFilter != null) {
            this.addValidationError(context, new ValidationResult.ValidationError("1.2.7", "Filter should be a Name or an Array"));
        }
    }

    protected void checkDictionaryEntries(PreflightContext context, COSStream streamObj) {
        boolean len = streamObj.containsKey(COSName.LENGTH);
        boolean f = streamObj.containsKey(COSName.F);
        boolean ffilter = streamObj.containsKey(COSName.F_FILTER);
        boolean fdecParams = streamObj.containsKey(COSName.F_DECODE_PARMS);
        if (!len) {
            this.addValidationError(context, new ValidationResult.ValidationError("1.2.4", "Stream length is missing"));
        }
        if (f || ffilter || fdecParams) {
            this.addValidationError(context, new ValidationResult.ValidationError("1.2.6", "F, FFilter or FDecodeParms keys are present in the stream dictionary"));
        }
    }
}

