/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.signer.SignerProperty;
import software.amazon.awssdk.identity.spi.IdentityProperty;
import software.amazon.awssdk.services.s3.S3ServiceClientConfiguration;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeParams;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeProvider;

@SdkProtectedApi
public final class S3OverrideAuthSchemePropertiesPlugin
implements SdkPlugin {
    private final Map<IdentityProperty<?>, Object> identityProperties;
    private final Map<SignerProperty<?>, Object> signerProperties;
    private final Set<String> operationConstraints;

    private S3OverrideAuthSchemePropertiesPlugin(Builder builder) {
        this.identityProperties = builder.identityProperties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(builder.identityProperties));
        this.signerProperties = builder.signerProperties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(builder.signerProperties));
        this.operationConstraints = builder.operationConstraints.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet(builder.operationConstraints));
    }

    public void configureClient(SdkServiceClientConfiguration.Builder config) {
        if (this.identityProperties.isEmpty() && this.signerProperties.isEmpty()) {
            return;
        }
        S3ServiceClientConfiguration.Builder s3Config = (S3ServiceClientConfiguration.Builder)config;
        S3AuthSchemeProvider delegate = s3Config.authSchemeProvider();
        s3Config.authSchemeProvider(params -> {
            List<AuthSchemeOption> options = delegate.resolveAuthScheme(params);
            ArrayList<AuthSchemeOption> result = new ArrayList<AuthSchemeOption>(options.size());
            for (AuthSchemeOption option : options) {
                if (this.addConfiguredProperties(option, params)) {
                    AuthSchemeOption.Builder builder = (AuthSchemeOption.Builder)option.toBuilder();
                    this.identityProperties.forEach((k, v) -> this.putIdentityProperty(builder, (IdentityProperty<?>)k, v));
                    this.signerProperties.forEach((k, v) -> this.putSignerProperty(builder, (SignerProperty<?>)k, v));
                    result.add((AuthSchemeOption)builder.build());
                    continue;
                }
                result.add(option);
            }
            return result;
        });
    }

    private <T> void putIdentityProperty(AuthSchemeOption.Builder builder, IdentityProperty<?> key, Object value) {
        builder.putIdentityProperty(key, value);
    }

    private <T> void putSignerProperty(AuthSchemeOption.Builder builder, SignerProperty<?> key, Object value) {
        builder.putSignerProperty(key, value);
    }

    private boolean addConfiguredProperties(AuthSchemeOption option, S3AuthSchemeParams params) {
        String schemeId = option.schemeId();
        return schemeId.startsWith("aws.auth#sigv4") && (this.operationConstraints.isEmpty() || this.operationConstraints.contains(params.operation()));
    }

    public static SdkPlugin enablePayloadSigningPlugin() {
        return S3OverrideAuthSchemePropertiesPlugin.builder().payloadSigningEnabled(true).build();
    }

    public static SdkPlugin disableChunkEncodingPlugin() {
        return S3OverrideAuthSchemePropertiesPlugin.builder().chunkEncodingEnabled(false).addOperationConstraint("UploadPart").addOperationConstraint("PutObject").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<IdentityProperty<?>, Object> identityProperties = new HashMap();
        private final Map<SignerProperty<?>, Object> signerProperties = new HashMap();
        private final Set<String> operationConstraints = new HashSet<String>();

        public Builder addOperationConstraint(String operation) {
            this.operationConstraints.add(operation);
            return this;
        }

        public <T> Builder putIdentityProperty(IdentityProperty<T> key, T value) {
            this.identityProperties.put(key, value);
            return this;
        }

        public <T> Builder putSignerProperty(SignerProperty<T> key, T value) {
            this.signerProperties.put(key, value);
            return this;
        }

        public Builder normalizePath(Boolean value) {
            return this.putSignerProperty(AwsV4FamilyHttpSigner.NORMALIZE_PATH, value);
        }

        public Builder chunkEncodingEnabled(Boolean value) {
            return this.putSignerProperty(AwsV4FamilyHttpSigner.CHUNK_ENCODING_ENABLED, value);
        }

        public Builder payloadSigningEnabled(Boolean value) {
            return this.putSignerProperty(AwsV4FamilyHttpSigner.PAYLOAD_SIGNING_ENABLED, value);
        }

        public S3OverrideAuthSchemePropertiesPlugin build() {
            return new S3OverrideAuthSchemePropertiesPlugin(this);
        }
    }
}

