<?php
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

class Test {
    public const BAR = 'bar';
    public const BA = 'BA';
    public const A = self::{'BAR'};
    public const B = self::{self::{'BA'} . 'R'};
    public const C = self::{self::BA . self::R};
}

trait TraitTest {
    public const TRAIT_BA = 'BA';
    public const TRAIT_B = self::{self::{'BA'} . 'R'};
    public const TRAIT_C = self::{self::TRAIT_BA . self::TRAIT_R};
}

enum EnumTest: string {
    case BAR = 'bar';
    case BA = 'BA';
    case A = self::{'BAR'};
    case B = self::{self::{'BA'} . 'R'};
    case C = self::{self::BA . self::R};
}

Test::{"BAR"};
$test::{"BAR"};
Test::{test()}::{test($bar)};
Test::{test('foo')}::FOO;

EnumTest::{"BAR"};
EnumTest::{test()}::{test($bar)};
EnumTest::{test('foo')}::FOO;
