/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.common;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.auth.MutableUserHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class ScpLocation
implements MutableUserHolder,
Serializable,
Cloneable {
    public static final String SCHEME = "scp://";
    public static final char HOST_PART_SEPARATOR = ':';
    public static final char USERNAME_PART_SEPARATOR = '@';
    private static final long serialVersionUID = 5450230457030600136L;
    private String host;
    private String username;
    private String path;
    private int port;

    public ScpLocation() {
        this(null);
    }

    public ScpLocation(String locSpec) {
        ScpLocation.update(locSpec, this);
    }

    public ScpLocation(String username, String host, String path) {
        this(username, host, 0, path);
    }

    public ScpLocation(String username, String host, int port, String path) {
        this.username = username;
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isLocal() {
        return GenericUtils.isEmpty((CharSequence)this.getHost());
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int resolvePort() {
        return SshConstants.TO_EFFECTIVE_PORT.applyAsInt(this.getPort());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String resolveUsername() {
        String user = this.getUsername();
        if (GenericUtils.isEmpty((CharSequence)user)) {
            return OsUtils.getCurrentUser();
        }
        return user;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int hashCode() {
        return this.isLocal() ? Objects.hashCode(OsUtils.getComparablePath((String)this.getPath())) : Objects.hash(this.getHost(), this.resolveUsername(), OsUtils.getComparablePath((String)this.getPath())) + 31 * Integer.hashCode(this.resolvePort());
    }

    public boolean equals(Object obj) {
        String otherPath;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScpLocation other = (ScpLocation)obj;
        boolean thisLocal = this.isLocal();
        if (thisLocal != other.isLocal()) {
            return false;
        }
        String thisPath = OsUtils.getComparablePath((String)this.getPath());
        if (!Objects.equals(thisPath, otherPath = OsUtils.getComparablePath((String)other.getPath()))) {
            return false;
        }
        if (thisLocal) {
            return true;
        }
        return Objects.equals(this.resolveUsername(), other.resolveUsername()) && Objects.equals(this.getHost(), other.getHost()) && this.resolvePort() == other.resolvePort();
    }

    public ScpLocation clone() {
        try {
            return (ScpLocation)this.getClass().cast(super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Failed to clone " + this.toString(), e);
        }
    }

    public String toString() {
        String p = this.getPath();
        if (this.isLocal()) {
            return p;
        }
        int portValue = this.resolvePort();
        String userValue = this.resolveUsername();
        StringBuilder sb = new StringBuilder();
        if (portValue != 22) {
            sb.append(SCHEME);
        }
        sb.append(userValue).append('@').append(this.getHost());
        sb.append(':');
        if (portValue != 22) {
            sb.append(portValue);
        }
        sb.append(p);
        return sb.toString();
    }

    public static ScpLocation parse(String locSpec) {
        return GenericUtils.isEmpty((CharSequence)locSpec) ? null : ScpLocation.update(locSpec, new ScpLocation());
    }

    public static <L extends ScpLocation> L update(String spec, L location) {
        String login;
        int pos;
        Objects.requireNonNull(location, "No location to update");
        if (GenericUtils.isEmpty((CharSequence)spec)) {
            return location;
        }
        location.setHost(null);
        location.setUsername(null);
        location.setPort(0);
        if (spec.startsWith(SCHEME)) {
            pos = spec.indexOf(47, SCHEME.length());
            ValidateUtils.checkTrue((pos > 0 ? 1 : 0) != 0, (String)"Invalid remote specification (missing path specification): %s", (Object)spec);
            login = spec.substring(SCHEME.length(), pos);
            location.setPath(spec.substring(pos));
            pos = login.indexOf(58);
            ValidateUtils.checkTrue((pos != 0 ? 1 : 0) != 0, (String)"Invalid remote specification (malformed port specification): %s", (Object)spec);
            if (pos > 0) {
                ValidateUtils.checkTrue((pos < login.length() - 1 ? 1 : 0) != 0, (String)"Invalid remote specification (no port specification): %s", (Object)spec);
                location.setPort(Integer.parseInt(login.substring(pos + 1)));
                login = login.substring(0, pos);
            }
        } else {
            char drive;
            pos = spec.indexOf(58);
            if (pos < 0) {
                location.setPath(spec);
                return location;
            }
            if (pos == 1 && OsUtils.isWin32() && ((drive = spec.charAt(0)) >= 'a' && drive <= 'z' || drive >= 'A' && drive <= 'Z')) {
                location.setPath(spec);
                return location;
            }
            login = spec.substring(0, pos);
            ValidateUtils.checkTrue((pos < spec.length() - 1 ? 1 : 0) != 0, (String)"Invalid remote specification (missing path): %s", (Object)spec);
            location.setPath(spec.substring(pos + 1));
        }
        pos = login.indexOf(64);
        ValidateUtils.checkTrue((pos != 0 ? 1 : 0) != 0, (String)"Invalid remote specification (missing username): %s", (Object)spec);
        if (pos < 0) {
            location.setHost(login);
        } else {
            location.setUsername(login.substring(0, pos));
            ValidateUtils.checkTrue((pos < login.length() - 1 ? 1 : 0) != 0, (String)"Invalid remote specification (missing host): %s", (Object)spec);
            location.setHost(login.substring(pos + 1));
        }
        return location;
    }
}

