/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.client;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.input.LimitInputStream;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.scp.ScpModuleProperties;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.client.ScpRemote2RemoteTransferListener;
import org.apache.sshd.scp.common.helpers.AbstractScpCommandDetails;
import org.apache.sshd.scp.common.helpers.ScpAckInfo;
import org.apache.sshd.scp.common.helpers.ScpDirEndCommandDetails;
import org.apache.sshd.scp.common.helpers.ScpIoUtils;
import org.apache.sshd.scp.common.helpers.ScpPathCommandDetailsSupport;
import org.apache.sshd.scp.common.helpers.ScpReceiveDirCommandDetails;
import org.apache.sshd.scp.common.helpers.ScpReceiveFileCommandDetails;
import org.apache.sshd.scp.common.helpers.ScpTimestampCommandDetails;

public class ScpRemote2RemoteTransferHelper
extends AbstractLoggingBean {
    protected final ScpRemote2RemoteTransferListener listener;
    protected final Charset csIn;
    protected final Charset csOut;
    private final ClientSession sourceSession;
    private final ClientSession destSession;

    public ScpRemote2RemoteTransferHelper(ClientSession sourceSession, ClientSession destSession) {
        this(sourceSession, destSession, null);
    }

    public ScpRemote2RemoteTransferHelper(ClientSession sourceSession, ClientSession destSession, ScpRemote2RemoteTransferListener listener) {
        this.sourceSession = Objects.requireNonNull(sourceSession, "No source session provided");
        this.csIn = (Charset)ScpModuleProperties.SCP_INCOMING_ENCODING.getRequired((PropertyResolver)sourceSession);
        this.destSession = Objects.requireNonNull(destSession, "No destination session provided");
        this.csOut = (Charset)ScpModuleProperties.SCP_OUTGOING_ENCODING.getRequired((PropertyResolver)destSession);
        this.listener = listener;
    }

    public ClientSession getSourceSession() {
        return this.sourceSession;
    }

    public ClientSession getDestinationSession() {
        return this.destSession;
    }

    public void transferFile(String source, String destination, boolean preserveAttributes) throws IOException {
        Set<ScpClient.Option> options = preserveAttributes ? Collections.unmodifiableSet(EnumSet.of(ScpClient.Option.PreserveAttributes)) : Collections.emptySet();
        this.executeTransfer(source, options, destination, options);
    }

    public void transferDirectory(String source, String destination, boolean preserveAttributes) throws IOException {
        Set<ScpClient.Option> options = EnumSet.of(ScpClient.Option.TargetIsDirectory, ScpClient.Option.Recursive);
        if (preserveAttributes) {
            options.add(ScpClient.Option.PreserveAttributes);
        }
        options = Collections.unmodifiableSet(options);
        this.executeTransfer(source, options, destination, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTransfer(String source, Collection<ScpClient.Option> srcOptions, String destination, Collection<ScpClient.Option> dstOptions) throws IOException {
        String srcCmd = ScpClient.createReceiveCommand(source, srcOptions);
        ClientSession srcSession = this.getSourceSession();
        ClientSession dstSession = this.getDestinationSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("executeTransfer({})[srcCmd='{}']) {} => {}", new Object[]{this, srcCmd, source, destination});
        }
        ChannelExec srcChannel = ScpIoUtils.openCommandChannel(srcSession, srcCmd, this.log);
        try (InputStream srcIn = srcChannel.getInvertedOut();
             OutputStream srcOut = srcChannel.getInvertedIn();){
            String dstCmd = ScpClient.createSendCommand(destination, dstOptions);
            if (debugEnabled) {
                this.log.debug("executeTransfer({})[dstCmd='{}'} {} => {}", new Object[]{this, dstCmd, source, destination});
            }
            ChannelExec dstChannel = ScpIoUtils.openCommandChannel(dstSession, dstCmd, this.log);
            try (InputStream dstIn = dstChannel.getInvertedOut();
                 OutputStream dstOut = dstChannel.getInvertedIn();){
                ScpAckInfo ackInfo = this.transferStatusCode("XFER-CMD", dstIn, srcOut);
                ackInfo.validateCommandStatusCode("XFER-CMD", "executeTransfer");
                if (srcOptions.contains((Object)ScpClient.Option.TargetIsDirectory) || dstOptions.contains((Object)ScpClient.Option.TargetIsDirectory)) {
                    this.redirectDirectoryTransfer(source, srcIn, srcOut, destination, dstIn, dstOut, 0);
                } else {
                    this.redirectFileTransfer(source, srcIn, srcOut, destination, dstIn, dstOut);
                }
            }
            finally {
                dstChannel.close(false);
            }
        }
        finally {
            srcChannel.close(false);
        }
    }

    protected long redirectFileTransfer(String source, InputStream srcIn, OutputStream srcOut, String destination, InputStream dstIn, OutputStream dstOut) throws IOException {
        Object data = this.receiveNextCmd("redirectFileTransfer", srcIn);
        if (data instanceof ScpAckInfo) {
            throw new StreamCorruptedException("Unexpected ACK instead of header: " + data);
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        String header = (String)data;
        if (debugEnabled) {
            this.log.debug("redirectFileTransfer({}) {} => {}: header={}", new Object[]{this, source, destination, header});
        }
        ScpTimestampCommandDetails time = null;
        if (header.charAt(0) == 'T') {
            time = new ScpTimestampCommandDetails(header);
            this.signalReceivedCommand(time);
            header = this.transferTimestampCommand(source, srcIn, srcOut, destination, dstIn, dstOut, header);
            if (debugEnabled) {
                this.log.debug("redirectFileTransfer({}) {} => {}: header={}", new Object[]{this, source, destination, header});
            }
        }
        return this.handleFileTransferRequest(source, srcIn, srcOut, destination, dstIn, dstOut, time, header);
    }

    protected long handleFileTransferRequest(String source, InputStream srcIn, OutputStream srcOut, String destination, InputStream dstIn, OutputStream dstOut, ScpTimestampCommandDetails fileTime, String header) throws IOException {
        long xferCount;
        if (header.charAt(0) != 'C') {
            throw new IllegalArgumentException("Invalid file transfer request: " + header);
        }
        ScpIoUtils.writeLine(dstOut, this.csOut, header);
        ScpAckInfo ackInfo = this.transferStatusCode(header, dstIn, srcOut);
        ackInfo.validateCommandStatusCode("[DST] " + header, "handleFileTransferRequest");
        ScpReceiveFileCommandDetails fileDetails = new ScpReceiveFileCommandDetails(header);
        this.signalReceivedCommand(fileDetails);
        ClientSession srcSession = this.getSourceSession();
        ClientSession dstSession = this.getDestinationSession();
        if (this.listener != null) {
            this.listener.startDirectFileTransfer(srcSession, source, dstSession, destination, fileTime, fileDetails);
        }
        try {
            xferCount = this.transferSimpleFile(source, srcIn, srcOut, destination, dstIn, dstOut, header, fileDetails.getLength());
        }
        catch (IOException | Error | RuntimeException e) {
            if (this.listener != null) {
                this.listener.endDirectFileTransfer(srcSession, source, dstSession, destination, fileTime, fileDetails, 0L, e);
            }
            throw e;
        }
        if (this.listener != null) {
            this.listener.endDirectFileTransfer(srcSession, source, dstSession, destination, fileTime, fileDetails, xferCount, null);
        }
        return xferCount;
    }

    protected void redirectDirectoryTransfer(String source, InputStream srcIn, OutputStream srcOut, String destination, InputStream dstIn, OutputStream dstOut, int depth) throws IOException {
        Object data = this.receiveNextCmd("redirectDirectoryTransfer", srcIn);
        if (data instanceof ScpAckInfo) {
            throw new StreamCorruptedException("Unexpected ACK instead of header: " + data);
        }
        String header = (String)data;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("redirectDirectoryTransfer({})[depth={}] {} => {}: header={}", new Object[]{this, depth, source, destination, header});
        }
        ScpTimestampCommandDetails time = null;
        if (header.charAt(0) == 'T') {
            time = new ScpTimestampCommandDetails(header);
            this.signalReceivedCommand(time);
            header = this.transferTimestampCommand(source, srcIn, srcOut, destination, dstIn, dstOut, header);
            if (debugEnabled) {
                this.log.debug("redirectDirectoryTransfer({})[depth={}] {} => {}: header={}", new Object[]{this, depth, source, destination, header});
            }
        }
        this.handleDirectoryTransferRequest(source, srcIn, srcOut, destination, dstIn, dstOut, depth, time, header);
    }

    protected void handleDirectoryTransferRequest(String srcPath, InputStream srcIn, OutputStream srcOut, String dstPath, InputStream dstIn, OutputStream dstOut, int depth, ScpTimestampCommandDetails dirTime, String header) throws IOException {
        if (header.charAt(0) != 'D') {
            throw new IllegalArgumentException("Invalid file transfer request: " + header);
        }
        ScpIoUtils.writeLine(dstOut, this.csOut, header);
        ScpAckInfo ackInfo = this.transferStatusCode(header, dstIn, srcOut);
        ackInfo.validateCommandStatusCode("[DST@" + depth + "] " + header, "handleDirectoryTransferRequest");
        ScpReceiveDirCommandDetails dirDetails = new ScpReceiveDirCommandDetails(header);
        this.signalReceivedCommand(dirDetails);
        String dirName = dirDetails.getName();
        String source = depth == 0 ? srcPath : SelectorUtils.concatPaths((String)srcPath, (String)dirName, (char)'/');
        String destination = depth == 0 ? dstPath : SelectorUtils.concatPaths((String)dstPath, (String)dirName, (char)'/');
        ClientSession srcSession = this.getSourceSession();
        ClientSession dstSession = this.getDestinationSession();
        if (this.listener != null) {
            this.listener.startDirectDirectoryTransfer(srcSession, source, dstSession, destination, dirTime, dirDetails);
        }
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            boolean dirEndSignal = false;
            while (!dirEndSignal) {
                Object data = this.receiveNextCmd("handleDirectoryTransferRequest", srcIn);
                if (data instanceof ScpAckInfo) {
                    throw new StreamCorruptedException("Unexpected ACK instead of header: " + data);
                }
                header = (String)data;
                if (debugEnabled) {
                    this.log.debug("handleDirectoryTransferRequest({})[depth={}] {} => {}: header={}", new Object[]{this, depth, source, destination, header});
                }
                ScpTimestampCommandDetails time = null;
                char cmdName = header.charAt(0);
                if (cmdName == 'T') {
                    time = new ScpTimestampCommandDetails(header);
                    this.signalReceivedCommand(time);
                    header = this.transferTimestampCommand(source, srcIn, srcOut, destination, dstIn, dstOut, header);
                    if (debugEnabled) {
                        this.log.debug("handleDirectoryTransferRequest({})[depth={}] {} => {}: header={}", new Object[]{this, depth, source, destination, header});
                    }
                    cmdName = header.charAt(0);
                }
                switch (cmdName) {
                    case 'C': 
                    case 'D': {
                        ScpPathCommandDetailsSupport subPathDetails = cmdName == 'C' ? new ScpReceiveFileCommandDetails(header) : new ScpReceiveDirCommandDetails(header);
                        String name = subPathDetails.getName();
                        String srcSubPath = SelectorUtils.concatPaths((String)source, (String)name, (char)'/');
                        String dstSubPath = SelectorUtils.concatPaths((String)destination, (String)name, (char)'/');
                        if (cmdName == 'C') {
                            this.handleFileTransferRequest(srcSubPath, srcIn, srcOut, dstSubPath, dstIn, dstOut, time, header);
                            break;
                        }
                        this.handleDirectoryTransferRequest(srcSubPath, srcIn, srcOut, dstSubPath, dstIn, dstOut, depth + 1, time, header);
                        break;
                    }
                    case 'E': {
                        ScpIoUtils.writeLine(dstOut, this.csOut, header);
                        ackInfo = this.transferStatusCode(header, dstIn, srcOut);
                        ackInfo.validateCommandStatusCode("[DST@" + depth + "] " + header, "handleDirectoryTransferRequest");
                        ScpDirEndCommandDetails details = ScpDirEndCommandDetails.parse(header);
                        this.signalReceivedCommand(details);
                        dirEndSignal = true;
                        break;
                    }
                    default: {
                        throw new StreamCorruptedException("Unexpected file command: " + header);
                    }
                }
                debugEnabled = this.log.isDebugEnabled();
            }
        }
        catch (IOException | Error | RuntimeException e) {
            if (this.listener != null) {
                this.listener.endDirectDirectoryTransfer(srcSession, source, dstSession, destination, dirTime, dirDetails, e);
            }
            throw e;
        }
        if (this.listener != null) {
            this.listener.endDirectDirectoryTransfer(srcSession, source, dstSession, destination, dirTime, dirDetails, null);
        }
    }

    protected long transferSimpleFile(String source, InputStream srcIn, OutputStream srcOut, String destination, InputStream dstIn, OutputStream dstOut, String header, long length) throws IOException {
        long xferCount;
        if (length < 0L) {
            this.log.warn("transferSimpleFile({})[{} => {}] bad length in header: {}", new Object[]{this, source, destination, header});
        }
        try (LimitInputStream inputStream = new LimitInputStream(srcIn, length);){
            ScpAckInfo.sendOk(srcOut, this.csOut);
            xferCount = IoUtils.copy((InputStream)inputStream, (OutputStream)dstOut);
            dstOut.flush();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("transferSimpleFile({})[{} => {}] xfer {}/{}", new Object[]{this, source, destination, xferCount, length});
        }
        ScpAckInfo ackInfo = this.transferStatusCode("SRC-EOF", srcIn, dstOut);
        ackInfo.validateCommandStatusCode("[SRC-EOF] " + header, "transferSimpleFile");
        ackInfo = ScpAckInfo.readAck(dstIn, this.csIn, false);
        ackInfo.validateCommandStatusCode("[DST-EOF] " + header, "transferSimpleFile");
        return xferCount;
    }

    protected String transferTimestampCommand(String source, InputStream srcIn, OutputStream srcOut, String destination, InputStream dstIn, OutputStream dstOut, String header) throws IOException {
        ScpIoUtils.writeLine(dstOut, this.csOut, header);
        ScpAckInfo ackInfo = this.transferStatusCode(header, dstIn, srcOut);
        ackInfo.validateCommandStatusCode("[DST] " + header, "transferTimestampCommand");
        Object data = this.receiveNextCmd("transferTimestampCommand", srcIn);
        if (data instanceof ScpAckInfo) {
            throw new StreamCorruptedException("Unexpected ACK instead of header: " + data);
        }
        return (String)data;
    }

    protected ScpAckInfo transferStatusCode(Object logHint, InputStream in, OutputStream out) throws IOException {
        ScpAckInfo ackInfo = ScpAckInfo.readAck(in, this.csIn, false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("transferStatusCode({})[{}] {}", new Object[]{this, logHint, ackInfo});
        }
        ackInfo.send(out, this.csOut);
        return ackInfo;
    }

    protected Object receiveNextCmd(Object logHint, InputStream in) throws IOException {
        int c = in.read();
        if (c == -1) {
            throw new EOFException(logHint + " - premature EOF while waiting for next command");
        }
        if (c == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("receiveNextCmd({})[{}] - ACK={}", new Object[]{this, logHint, c});
            }
            return new ScpAckInfo(c);
        }
        String line = ScpIoUtils.readLine(in, this.csIn, false);
        if (c == 1 || c == 2) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("receiveNextCmd({})[{}] - ACK={}", new Object[]{this, logHint, new ScpAckInfo(c, line)});
            }
            return new ScpAckInfo(c, line);
        }
        return Character.toString((char)c) + line;
    }

    protected void signalReceivedCommand(AbstractScpCommandDetails details) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("signalReceivedCommand({}) {}", (Object)this, (Object)details.toHeader());
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[src=" + this.getSourceSession() + ",dst=" + this.getDestinationSession() + "]";
    }
}

