/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Proxy
extends IdentifiableBase
implements Serializable,
InputLocationTracker {
    final String activeString;
    final String protocol;
    final String username;
    final String password;
    final String portString;
    final String host;
    final String nonProxyHosts;

    protected Proxy(Builder builder) {
        super(builder);
        String string = builder.activeString != null ? builder.activeString : (this.activeString = builder.base != null ? builder.base.activeString : null);
        String string2 = builder.protocol != null ? builder.protocol : (this.protocol = builder.base != null ? builder.base.protocol : null);
        String string3 = builder.username != null ? builder.username : (this.username = builder.base != null ? builder.base.username : null);
        String string4 = builder.password != null ? builder.password : (this.password = builder.base != null ? builder.base.password : null);
        String string5 = builder.portString != null ? builder.portString : (this.portString = builder.base != null ? builder.base.portString : null);
        String string6 = builder.host != null ? builder.host : (this.host = builder.base != null ? builder.base.host : null);
        this.nonProxyHosts = builder.nonProxyHosts != null ? builder.nonProxyHosts : (builder.base != null ? builder.base.nonProxyHosts : null);
    }

    public String getActiveString() {
        return this.activeString;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPortString() {
        return this.portString;
    }

    public String getHost() {
        return this.host;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Proxy.newBuilder(this);
    }

    @Override
    @Nonnull
    public Proxy withId(String id) {
        return Proxy.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Proxy withActiveString(String activeString) {
        return Proxy.newBuilder(this, true).activeString(activeString).build();
    }

    @Nonnull
    public Proxy withProtocol(String protocol) {
        return Proxy.newBuilder(this, true).protocol(protocol).build();
    }

    @Nonnull
    public Proxy withUsername(String username) {
        return Proxy.newBuilder(this, true).username(username).build();
    }

    @Nonnull
    public Proxy withPassword(String password) {
        return Proxy.newBuilder(this, true).password(password).build();
    }

    @Nonnull
    public Proxy withPortString(String portString) {
        return Proxy.newBuilder(this, true).portString(portString).build();
    }

    @Nonnull
    public Proxy withHost(String host) {
        return Proxy.newBuilder(this, true).host(host).build();
    }

    @Nonnull
    public Proxy withNonProxyHosts(String nonProxyHosts) {
        return Proxy.newBuilder(this, true).nonProxyHosts(nonProxyHosts).build();
    }

    @Nonnull
    public static Proxy newInstance() {
        return Proxy.newInstance(true);
    }

    @Nonnull
    public static Proxy newInstance(boolean withDefaults) {
        return Proxy.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Proxy.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Proxy from) {
        return Proxy.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Proxy from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isActive() {
        return this.getActiveString() != null ? Boolean.parseBoolean(this.getActiveString()) : true;
    }

    public int getPort() {
        return this.getPortString() != null ? Integer.parseInt(this.getPortString()) : 8080;
    }

    @NotThreadSafe
    public static class Builder
    extends IdentifiableBase.Builder {
        Proxy base;
        String activeString;
        String protocol;
        String username;
        String password;
        String portString;
        String host;
        String nonProxyHosts;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.activeString = "true";
                this.protocol = "http";
                this.portString = "8080";
            }
        }

        protected Builder(Proxy base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.activeString = base.activeString;
                this.protocol = base.protocol;
                this.username = base.username;
                this.password = base.password;
                this.portString = base.portString;
                this.host = base.host;
                this.nonProxyHosts = base.nonProxyHosts;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder activeString(String activeString) {
            this.activeString = activeString;
            return this;
        }

        @Nonnull
        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Nonnull
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @Nonnull
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Nonnull
        public Builder portString(String portString) {
            this.portString = portString;
            return this;
        }

        @Nonnull
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        @Nonnull
        public Builder nonProxyHosts(String nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Proxy build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.activeString != null && this.activeString != this.base.activeString || this.protocol != null && this.protocol != this.base.protocol || this.username != null && this.username != this.base.username || this.password != null && this.password != this.base.password || this.portString != null && this.portString != this.base.portString || this.host != null && this.host != this.base.host || this.nonProxyHosts != null && this.nonProxyHosts != this.base.nonProxyHosts)) {
                return this.base;
            }
            return new Proxy(this);
        }
    }
}

