/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.Language;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.SourceRoot;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.SessionScoped;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.MappedList;
import org.apache.maven.impl.PropertiesAsMap;
import org.apache.maven.internal.impl.CoreUtils;
import org.apache.maven.internal.impl.DefaultProject;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.Typed;

@Named
@Typed
@SessionScoped
public class DefaultProjectManager
implements ProjectManager {
    private final InternalMavenSession session;
    private final ArtifactManager artifactManager;

    @Inject
    public DefaultProjectManager(InternalMavenSession session, ArtifactManager artifactManager) {
        this.session = session;
        this.artifactManager = artifactManager;
    }

    @Nonnull
    public Optional<Path> getPath(@Nonnull Project project) {
        Objects.requireNonNull(project, "project cannot be null");
        Optional mainArtifact = project.getMainArtifact();
        return mainArtifact.flatMap(arg_0 -> ((ArtifactManager)this.artifactManager).getPath(arg_0));
    }

    @Nonnull
    public Collection<ProducedArtifact> getAttachedArtifacts(@Nonnull Project project) {
        Objects.requireNonNull(project, "project cannot be null");
        List<ProducedArtifact> attached = CoreUtils.map(this.getMavenProject(project).getAttachedArtifacts(), a -> (ProducedArtifact)DefaultProjectManager.getSession(project).getArtifact(ProducedArtifact.class, RepositoryUtils.toArtifact(a)));
        return Collections.unmodifiableCollection(attached);
    }

    @Nonnull
    public Collection<ProducedArtifact> getAllArtifacts(@Nonnull Project project) {
        Objects.requireNonNull(project, "project cannot be null");
        ArrayList<ProducedArtifact> result = new ArrayList<ProducedArtifact>(2);
        result.addAll(project.getArtifacts());
        result.addAll(this.getAttachedArtifacts(project));
        return Collections.unmodifiableCollection(result);
    }

    public void attachArtifact(@Nonnull Project project, @Nonnull ProducedArtifact artifact, @Nonnull Path path) {
        Objects.requireNonNull(project, "project cannot be null");
        Objects.requireNonNull(artifact, "artifact cannot be null");
        Objects.requireNonNull(path, "path cannot be null");
        if (artifact.getGroupId().isEmpty() || artifact.getArtifactId().isEmpty() || artifact.getBaseVersion().toString().isEmpty()) {
            artifact = this.session.createProducedArtifact(artifact.getGroupId().isEmpty() ? project.getGroupId() : artifact.getGroupId(), artifact.getArtifactId().isEmpty() ? project.getArtifactId() : artifact.getArtifactId(), artifact.getBaseVersion().toString().isEmpty() ? this.session.parseVersion(project.getVersion()).toString() : artifact.getBaseVersion().toString(), artifact.getClassifier(), artifact.getExtension(), null);
        }
        if (!(Objects.equals(project.getGroupId(), artifact.getGroupId()) && Objects.equals(project.getArtifactId(), artifact.getArtifactId()) && Objects.equals(project.getVersion(), artifact.getBaseVersion().toString()))) {
            throw new IllegalArgumentException("The produced artifact must have the same groupId/artifactId/version than the project it is attached to. Expecting " + project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion() + " but received " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + String.valueOf(artifact.getBaseVersion()));
        }
        this.getMavenProject(project).addAttachedArtifact(RepositoryUtils.toArtifact(DefaultProjectManager.getSession(project).toArtifact((Artifact)artifact)));
        this.artifactManager.setPath(artifact, path);
    }

    @Nonnull
    public Collection<SourceRoot> getSourceRoots(@Nonnull Project project) {
        MavenProject prj = this.getMavenProject(Objects.requireNonNull(project, "project cannot be null"));
        return prj.getSourceRoots();
    }

    @Nonnull
    public Stream<SourceRoot> getEnabledSourceRoots(@Nonnull Project project, ProjectScope scope, Language language) {
        MavenProject prj = this.getMavenProject(Objects.requireNonNull(project, "project cannot be null"));
        return prj.getEnabledSourceRoots(scope, language);
    }

    public void addSourceRoot(@Nonnull Project project, @Nonnull SourceRoot source) {
        MavenProject prj = this.getMavenProject(Objects.requireNonNull(project, "project cannot be null"));
        prj.addSourceRoot(Objects.requireNonNull(source, "source cannot be null"));
    }

    public void addSourceRoot(@Nonnull Project project, @Nonnull ProjectScope scope, @Nonnull Language language, @Nonnull Path directory) {
        MavenProject prj = this.getMavenProject(Objects.requireNonNull(project, "project cannot be null"));
        prj.addSourceRoot(Objects.requireNonNull(scope, "scope cannot be null"), Objects.requireNonNull(language, "language cannot be null"), Objects.requireNonNull(directory, "directory cannot be null"));
    }

    @Nonnull
    public List<RemoteRepository> getRemoteProjectRepositories(@Nonnull Project project) {
        return Collections.unmodifiableList(new MappedList(this.getMavenProject(project).getRemoteProjectRepositories(), arg_0 -> ((InternalMavenSession)this.session).getRemoteRepository(arg_0)));
    }

    @Nonnull
    public List<RemoteRepository> getRemotePluginRepositories(@Nonnull Project project) {
        return Collections.unmodifiableList(new MappedList(this.getMavenProject(project).getRemotePluginRepositories(), arg_0 -> ((InternalMavenSession)this.session).getRemoteRepository(arg_0)));
    }

    public void setProperty(@Nonnull Project project, @Nonnull String key, String value) {
        Properties properties = this.getMavenProject(project).getProperties();
        if (value == null) {
            properties.remove(key);
        } else {
            properties.setProperty(key, value);
        }
    }

    @Nonnull
    public Map<String, String> getProperties(@Nonnull Project project) {
        return Collections.unmodifiableMap(new PropertiesAsMap((Map)this.getMavenProject(project).getProperties()));
    }

    @Nonnull
    public Optional<Project> getExecutionProject(@Nonnull Project project) {
        return Optional.ofNullable(this.getMavenProject(project).getExecutionProject()).map(p -> new DefaultProject(this.session, (MavenProject)p));
    }

    private MavenProject getMavenProject(Project project) {
        return ((DefaultProject)project).getProject();
    }

    private static InternalSession getSession(Project project) {
        return ((DefaultProject)project).getSession();
    }
}

