/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherArrayProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherPropertyTypes;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.hslf.usermodel.HSLFFreeformShape;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.sl.draw.binding.CTAdjPoint2D;
import org.apache.poi.sl.draw.binding.CTCustomGeometry2D;
import org.apache.poi.sl.draw.binding.CTPath2D;
import org.apache.poi.sl.draw.binding.CTPath2DArcTo;
import org.apache.poi.sl.draw.binding.CTPath2DCubicBezierTo;
import org.apache.poi.sl.draw.binding.CTPath2DLineTo;
import org.apache.poi.sl.draw.binding.CTPath2DList;
import org.apache.poi.sl.draw.binding.CTPath2DMoveTo;
import org.apache.poi.sl.draw.binding.ObjectFactory;
import org.apache.poi.sl.draw.geom.CustomGeometry;
import org.apache.poi.sl.usermodel.AutoShape;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.sl.usermodel.VerticalAlignment;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class HSLFAutoShape
extends HSLFTextShape
implements AutoShape<HSLFShape, HSLFTextParagraph> {
    private static final POILogger LOG = POILogFactory.getLogger(HSLFAutoShape.class);
    static final byte[] SEGMENTINFO_MOVETO = new byte[]{0, 64};
    static final byte[] SEGMENTINFO_LINETO = new byte[]{0, -84};
    static final byte[] SEGMENTINFO_ESCAPE = new byte[]{1, 0};
    static final byte[] SEGMENTINFO_ESCAPE2 = new byte[]{1, 32};
    static final byte[] SEGMENTINFO_CUBICTO = new byte[]{0, -83};
    static final byte[] SEGMENTINFO_CLOSE = new byte[]{1, 96};
    static final byte[] SEGMENTINFO_END = new byte[]{0, -128};
    private static final ObjectFactory OF = new ObjectFactory();
    private static final BitField PATH_INFO = BitFieldFactory.getInstance((int)57344);
    private static final BitField ESCAPE_INFO = BitFieldFactory.getInstance((int)7936);

    protected HSLFAutoShape(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    public HSLFAutoShape(ShapeType type, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(null, parent);
        this.createSpContainer(type, parent instanceof HSLFGroupShape);
    }

    public HSLFAutoShape(ShapeType type) {
        this(type, null);
    }

    protected EscherContainerRecord createSpContainer(ShapeType shapeType, boolean isChild) {
        EscherContainerRecord ecr = super.createSpContainer(isChild);
        this.setShapeType(shapeType);
        this.setEscherProperty(EscherPropertyTypes.PROTECTION__LOCKAGAINSTGROUPING, 262144);
        this.setEscherProperty(EscherPropertyTypes.FILL__FILLCOLOR, 0x8000004);
        this.setEscherProperty(EscherPropertyTypes.FILL__FILLCOLOR, 0x8000004);
        this.setEscherProperty(EscherPropertyTypes.FILL__FILLBACKCOLOR, 0x8000000);
        this.setEscherProperty(EscherPropertyTypes.FILL__NOFILLHITTEST, 0x100010);
        this.setEscherProperty(EscherPropertyTypes.LINESTYLE__COLOR, 0x8000001);
        this.setEscherProperty(EscherPropertyTypes.LINESTYLE__NOLINEDRAWDASH, 524296);
        this.setEscherProperty(EscherPropertyTypes.SHADOWSTYLE__COLOR, 0x8000002);
        return ecr;
    }

    @Override
    protected void setDefaultTextProperties(HSLFTextParagraph _txtrun) {
        this.setVerticalAlignment(VerticalAlignment.MIDDLE);
        this.setHorizontalCentered(true);
        this.setWordWrap(false);
    }

    public int getAdjustmentValue(int idx) {
        if (idx < 0 || idx > 9) {
            throw new IllegalArgumentException("The index of an adjustment value must be in the [0, 9] range");
        }
        return this.getEscherProperty(ADJUST_VALUES[idx]);
    }

    public void setAdjustmentValue(int idx, int val) {
        if (idx < 0 || idx > 9) {
            throw new IllegalArgumentException("The index of an adjustment value must be in the [0, 9] range");
        }
        this.setEscherProperty(ADJUST_VALUES[idx], val);
    }

    @Override
    public CustomGeometry getGeometry() {
        return this.getGeometry(new Path2D.Double());
    }

    CustomGeometry getGeometry(Path2D path2D) {
        CTCustomGeometry2D cusGeo = OF.createCTCustomGeometry2D();
        cusGeo.setAvLst(OF.createCTGeomGuideList());
        cusGeo.setGdLst(OF.createCTGeomGuideList());
        cusGeo.setAhLst(OF.createCTAdjustHandleList());
        cusGeo.setCxnLst(OF.createCTConnectionSiteList());
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherArrayProperty verticesProp = (EscherArrayProperty)HSLFAutoShape.getEscherProperty(opt, EscherPropertyTypes.GEOMETRY__VERTICES);
        EscherArrayProperty segmentsProp = (EscherArrayProperty)HSLFAutoShape.getEscherProperty(opt, EscherPropertyTypes.GEOMETRY__SEGMENTINFO);
        if (verticesProp == null) {
            LOG.log(5, new Object[]{"Freeform is missing GEOMETRY__VERTICES "});
            return super.getGeometry();
        }
        if (segmentsProp == null) {
            LOG.log(5, new Object[]{"Freeform is missing GEOMETRY__SEGMENTINFO "});
            return super.getGeometry();
        }
        Iterator vertIter = verticesProp.iterator();
        Iterator segIter = segmentsProp.iterator();
        int[] xyPoints = new int[2];
        boolean isClosed = false;
        CTPath2DList pathLst = OF.createCTPath2DList();
        CTPath2D pathCT = OF.createCTPath2D();
        List moveLst = pathCT.getCloseOrMoveToOrLnTo();
        pathLst.getPath().add(pathCT);
        cusGeo.setPathLst(pathLst);
        while (segIter.hasNext()) {
            byte[] segElem = (byte[])segIter.next();
            PathInfo pi = HSLFAutoShape.getPathInfo(segElem);
            if (pi == null) continue;
            switch (pi) {
                case escape: {
                    HSLFAutoShape.handleEscapeInfo(pathCT, path2D, segElem, vertIter);
                    break;
                }
                case moveTo: {
                    HSLFAutoShape.handleMoveTo(vertIter, xyPoints, moveLst, path2D);
                    break;
                }
                case lineTo: {
                    HSLFAutoShape.handleLineTo(vertIter, xyPoints, moveLst, path2D);
                    break;
                }
                case curveTo: {
                    HSLFAutoShape.handleCurveTo(vertIter, xyPoints, moveLst, path2D);
                    break;
                }
                case close: {
                    if (path2D.getCurrentPoint() != null) {
                        moveLst.add(OF.createCTPath2DClose());
                        path2D.closePath();
                    }
                    isClosed = true;
                    break;
                }
            }
        }
        if (!isClosed) {
            HSLFAutoShape.handleClosedShape(opt, moveLst, path2D);
        }
        Rectangle2D bounds = HSLFAutoShape.getBounds(opt, path2D);
        pathCT.setW((long)((int)Math.rint(bounds.getWidth())));
        pathCT.setH((long)((int)Math.rint(bounds.getHeight())));
        return new CustomGeometry(cusGeo);
    }

    private static Rectangle2D getBounds(AbstractEscherOptRecord opt, Path2D path2D) {
        EscherSimpleProperty geoLeft = (EscherSimpleProperty)HSLFAutoShape.getEscherProperty(opt, EscherPropertyTypes.GEOMETRY__LEFT);
        EscherSimpleProperty geoRight = (EscherSimpleProperty)HSLFAutoShape.getEscherProperty(opt, EscherPropertyTypes.GEOMETRY__RIGHT);
        EscherSimpleProperty geoTop = (EscherSimpleProperty)HSLFAutoShape.getEscherProperty(opt, EscherPropertyTypes.GEOMETRY__TOP);
        EscherSimpleProperty geoBottom = (EscherSimpleProperty)HSLFAutoShape.getEscherProperty(opt, EscherPropertyTypes.GEOMETRY__BOTTOM);
        if (geoLeft != null && geoRight != null && geoTop != null && geoBottom != null) {
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            bounds.setFrameFromDiagonal(new Point2D.Double(geoLeft.getPropertyValue(), geoTop.getPropertyValue()), new Point2D.Double(geoRight.getPropertyValue(), geoBottom.getPropertyValue()));
            return bounds;
        }
        return path2D.getBounds2D();
    }

    private static void handleClosedShape(AbstractEscherOptRecord opt, List<Object> moveLst, Path2D path2D) {
        EscherSimpleProperty shapePath = (EscherSimpleProperty)HSLFAutoShape.getEscherProperty(opt, EscherPropertyTypes.GEOMETRY__SHAPEPATH);
        HSLFFreeformShape.ShapePath sp = HSLFFreeformShape.ShapePath.valueOf(shapePath == null ? 1 : shapePath.getPropertyValue());
        if (sp == HSLFFreeformShape.ShapePath.LINES_CLOSED || sp == HSLFFreeformShape.ShapePath.CURVES_CLOSED) {
            moveLst.add(OF.createCTPath2DClose());
            path2D.closePath();
        }
    }

    private static void handleMoveTo(Iterator<byte[]> vertIter, int[] xyPoints, List<Object> moveLst, Path2D path2D) {
        if (!vertIter.hasNext()) {
            return;
        }
        CTPath2DMoveTo m = OF.createCTPath2DMoveTo();
        m.setPt(HSLFAutoShape.fillPoint(vertIter.next(), xyPoints));
        moveLst.add(m);
        path2D.moveTo(xyPoints[0], xyPoints[1]);
    }

    private static void handleLineTo(Iterator<byte[]> vertIter, int[] xyPoints, List<Object> moveLst, Path2D path2D) {
        if (!vertIter.hasNext()) {
            return;
        }
        HSLFAutoShape.handleMoveTo0(moveLst, path2D);
        CTPath2DLineTo m = OF.createCTPath2DLineTo();
        m.setPt(HSLFAutoShape.fillPoint(vertIter.next(), xyPoints));
        moveLst.add(m);
        path2D.lineTo(xyPoints[0], xyPoints[1]);
    }

    private static void handleCurveTo(Iterator<byte[]> vertIter, int[] xyPoints, List<Object> moveLst, Path2D path2D) {
        if (!vertIter.hasNext()) {
            return;
        }
        HSLFAutoShape.handleMoveTo0(moveLst, path2D);
        CTPath2DCubicBezierTo m = OF.createCTPath2DCubicBezierTo();
        List mLst = m.getPt();
        int[] pts = new int[6];
        for (int i = 0; vertIter.hasNext() && i < 3; ++i) {
            mLst.add(HSLFAutoShape.fillPoint(vertIter.next(), xyPoints));
            pts[i * 2] = xyPoints[0];
            pts[i * 2 + 1] = xyPoints[1];
            if (i != 2) continue;
            moveLst.add(m);
            path2D.curveTo(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5]);
        }
    }

    private static void handleMoveTo0(List<Object> moveLst, Path2D path2D) {
        if (path2D.getCurrentPoint() == null) {
            CTPath2DMoveTo m = OF.createCTPath2DMoveTo();
            CTAdjPoint2D pt = OF.createCTAdjPoint2D();
            pt.setX("0");
            pt.setY("0");
            m.setPt(pt);
            moveLst.add(m);
            path2D.moveTo(0.0, 0.0);
        }
    }

    private static void handleEscapeInfo(CTPath2D pathCT, Path2D path2D, byte[] segElem, Iterator<byte[]> vertIter) {
        EscapeInfo ei = HSLFAutoShape.getEscapeInfo(segElem);
        if (ei == null) {
            return;
        }
        switch (ei) {
            case EXTENSION: {
                break;
            }
            case ANGLE_ELLIPSE_TO: {
                break;
            }
            case ANGLE_ELLIPSE: {
                break;
            }
            case ARC_TO: {
                int[] r1 = new int[2];
                int[] r2 = new int[2];
                int[] start = new int[2];
                int[] end = new int[2];
                HSLFAutoShape.fillPoint(vertIter.next(), r1);
                HSLFAutoShape.fillPoint(vertIter.next(), r2);
                HSLFAutoShape.fillPoint(vertIter.next(), start);
                HSLFAutoShape.fillPoint(vertIter.next(), end);
                Arc2D.Double arc2D = new Arc2D.Double();
                Rectangle2D.Double bounds = new Rectangle2D.Double();
                bounds.setFrameFromDiagonal(HSLFAutoShape.xy2p(r1), HSLFAutoShape.xy2p(r2));
                arc2D.setFrame(bounds);
                arc2D.setAngles(HSLFAutoShape.xy2p(start), HSLFAutoShape.xy2p(end));
                path2D.append(arc2D, true);
                CTPath2DArcTo arcTo = OF.createCTPath2DArcTo();
                arcTo.setHR(HSLFAutoShape.d2s(bounds.getHeight() / 2.0));
                arcTo.setWR(HSLFAutoShape.d2s(bounds.getWidth() / 2.0));
                arcTo.setStAng(HSLFAutoShape.d2s(-((Arc2D)arc2D).getAngleStart() * 60000.0));
                arcTo.setSwAng(HSLFAutoShape.d2s(-((Arc2D)arc2D).getAngleExtent() * 60000.0));
                pathCT.getCloseOrMoveToOrLnTo().add(arcTo);
                break;
            }
            case ARC: {
                break;
            }
            case CLOCKWISE_ARC_TO: {
                break;
            }
            case CLOCKWISE_ARC: {
                break;
            }
            case ELLIPTICAL_QUADRANT_X: {
                break;
            }
            case ELLIPTICAL_QUADRANT_Y: {
                break;
            }
            case QUADRATIC_BEZIER: {
                break;
            }
            case NO_FILL: {
                break;
            }
            case NO_LINE: {
                break;
            }
            case AUTO_LINE: {
                break;
            }
            case AUTO_CURVE: {
                break;
            }
            case CORNER_LINE: {
                break;
            }
            case CORNER_CURVE: {
                break;
            }
            case SMOOTH_LINE: {
                break;
            }
            case SMOOTH_CURVE: {
                break;
            }
            case SYMMETRIC_LINE: {
                break;
            }
            case SYMMETRIC_CURVE: {
                break;
            }
            case FREEFORM: {
                break;
            }
            case FILL_COLOR: {
                break;
            }
            case LINE_COLOR: {
                break;
            }
        }
    }

    private static String d2s(double d) {
        return Integer.toString((int)Math.rint(d));
    }

    private static Point2D xy2p(int[] xyPoints) {
        return new Point2D.Double(xyPoints[0], xyPoints[1]);
    }

    private static PathInfo getPathInfo(byte[] elem) {
        int elemUS = LittleEndian.getUShort((byte[])elem, (int)0);
        int pathInfo = PATH_INFO.getValue(elemUS);
        return PathInfo.valueOf(pathInfo);
    }

    private static EscapeInfo getEscapeInfo(byte[] elem) {
        int elemUS = LittleEndian.getUShort((byte[])elem, (int)0);
        int escInfo = ESCAPE_INFO.getValue(elemUS);
        return EscapeInfo.valueOf(escInfo);
    }

    private static CTAdjPoint2D fillPoint(byte[] xyMaster, int[] xyPoints) {
        int y;
        int x;
        if (xyMaster == null || xyPoints == null) {
            LOG.log(5, new Object[]{"Master bytes or points not set - ignore point"});
            return null;
        }
        if (xyMaster.length != 4 && xyMaster.length != 8 || xyPoints.length != 2) {
            LOG.log(5, new Object[]{"Invalid number of master bytes for a single point - ignore point"});
            return null;
        }
        if (xyMaster.length == 4) {
            x = LittleEndian.getShort((byte[])xyMaster, (int)0);
            y = LittleEndian.getShort((byte[])xyMaster, (int)2);
        } else {
            x = LittleEndian.getInt((byte[])xyMaster, (int)0);
            y = LittleEndian.getInt((byte[])xyMaster, (int)4);
        }
        xyPoints[0] = x;
        xyPoints[1] = y;
        return HSLFAutoShape.toPoint(xyPoints);
    }

    private static CTAdjPoint2D toPoint(int[] xyPoints) {
        CTAdjPoint2D pt = OF.createCTAdjPoint2D();
        pt.setX(Integer.toString(xyPoints[0]));
        pt.setY(Integer.toString(xyPoints[1]));
        return pt;
    }

    static enum EscapeInfo {
        EXTENSION(0),
        ANGLE_ELLIPSE_TO(1),
        ANGLE_ELLIPSE(2),
        ARC_TO(3),
        ARC(4),
        CLOCKWISE_ARC_TO(5),
        CLOCKWISE_ARC(6),
        ELLIPTICAL_QUADRANT_X(7),
        ELLIPTICAL_QUADRANT_Y(8),
        QUADRATIC_BEZIER(9),
        NO_FILL(10),
        NO_LINE(11),
        AUTO_LINE(12),
        AUTO_CURVE(13),
        CORNER_LINE(14),
        CORNER_CURVE(15),
        SMOOTH_LINE(16),
        SMOOTH_CURVE(17),
        SYMMETRIC_LINE(18),
        SYMMETRIC_CURVE(19),
        FREEFORM(20),
        FILL_COLOR(21),
        LINE_COLOR(22);

        private final int flag;

        private EscapeInfo(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        static EscapeInfo valueOf(int flag) {
            for (EscapeInfo v : EscapeInfo.values()) {
                if (v.flag != flag) continue;
                return v;
            }
            return null;
        }
    }

    static enum PathInfo {
        lineTo(0),
        curveTo(1),
        moveTo(2),
        close(3),
        end(4),
        escape(5),
        clientEscape(6);

        private final int flag;

        private PathInfo(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        static PathInfo valueOf(int flag) {
            for (PathInfo v : PathInfo.values()) {
                if (v.flag != flag) continue;
                return v;
            }
            return null;
        }
    }
}

