/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CyclicBufferList
extends AbstractList
implements List {
    Object[] ea;
    int first;
    int last;
    int numElems;
    int maxSize;

    public CyclicBufferList(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("The maxSize argument (" + maxSize + ") is not a positive integer.");
        }
        this.maxSize = maxSize;
        this.clear();
    }

    public CyclicBufferList() {
        this(5000);
    }

    public Object remove(int index) {
        Object oldValue = this.ea[index];
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(this.ea));
        list.remove(index);
        this.ea = list.toArray(this.ea);
        this.numElems = this.ea.length;
        --this.numElems;
        if (--this.last <= 0) {
            this.last = this.numElems;
        }
        if (this.first == this.maxSize) {
            this.first = 0;
        }
        return oldValue;
    }

    public Object set(int index, Object element) {
        Object previous = this.ea[index];
        this.ea[index] = element;
        return previous;
    }

    @Override
    public boolean add(Object event) {
        this.ea[this.last] = event;
        if (++this.last == this.maxSize) {
            this.last = 0;
        }
        if (this.numElems < this.maxSize) {
            ++this.numElems;
        } else if (++this.first == this.maxSize) {
            this.first = 0;
        }
        return true;
    }

    public Object get(int i) {
        if (i < 0 || i >= this.numElems) {
            return null;
        }
        return this.ea[(this.first + i) % this.maxSize];
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getLast() {
        return this.last;
    }

    public Object get() {
        Object r = null;
        if (this.numElems > 0) {
            --this.numElems;
            r = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first == this.maxSize) {
                this.first = 0;
            }
        }
        return r;
    }

    @Override
    public int size() {
        return this.numElems;
    }

    public void resize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("Negative array size [" + newSize + "] not allowed.");
        }
        if (newSize == this.numElems) {
            return;
        }
        Object[] temp = new Object[newSize];
        int loopLen = newSize < this.numElems ? newSize : this.numElems;
        for (int i = 0; i < loopLen; ++i) {
            temp[i] = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first != this.numElems) continue;
            this.first = 0;
        }
        this.ea = temp;
        this.first = 0;
        this.numElems = loopLen;
        this.maxSize = newSize;
        this.last = loopLen == newSize ? 0 : loopLen;
    }

    @Override
    public void clear() {
        this.ea = new Object[this.maxSize];
        this.first = 0;
        this.last = 0;
        this.numElems = 0;
    }
}

