/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.orm20;

import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.orm20.AccessType;
import org.jboss.shrinkwrap.descriptor.api.orm20.Basic;
import org.jboss.shrinkwrap.descriptor.api.orm20.Column;
import org.jboss.shrinkwrap.descriptor.api.orm20.EnumType;
import org.jboss.shrinkwrap.descriptor.api.orm20.FetchType;
import org.jboss.shrinkwrap.descriptor.api.orm20.TemporalType;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.impl.orm20.ColumnImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicImpl<T>
implements Child<T>,
Basic<T> {
    private T t;
    private Node childNode;

    public BasicImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public BasicImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public Column<Basic<T>> getOrCreateColumn() {
        Node node = this.childNode.getOrCreate("column");
        ColumnImpl<Basic<T>> column = new ColumnImpl<Basic<T>>(this, "column", this.childNode, node);
        return column;
    }

    public Basic<T> removeColumn() {
        this.childNode.removeChildren("column");
        return this;
    }

    public Basic<T> lob() {
        this.childNode.getOrCreate("lob");
        return this;
    }

    public Boolean isLob() {
        return this.childNode.getSingle("lob") != null;
    }

    public Basic<T> removeLob() {
        this.childNode.removeChild("lob");
        return this;
    }

    public Basic<T> temporal(TemporalType temporal) {
        this.childNode.getOrCreate("temporal").text((Object)temporal);
        return this;
    }

    public Basic<T> temporal(String temporal) {
        this.childNode.getOrCreate("temporal").text(temporal);
        return this;
    }

    public TemporalType getTemporal() {
        return TemporalType.getFromStringValue((String)this.childNode.getTextValueForPatternName("temporal"));
    }

    public String getTemporalAsString() {
        return this.childNode.getTextValueForPatternName("temporal");
    }

    public Basic<T> removeTemporal() {
        this.childNode.removeAttribute("temporal");
        return this;
    }

    public Basic<T> enumerated(EnumType enumerated) {
        this.childNode.getOrCreate("enumerated").text((Object)enumerated);
        return this;
    }

    public Basic<T> enumerated(String enumerated) {
        this.childNode.getOrCreate("enumerated").text(enumerated);
        return this;
    }

    public EnumType getEnumerated() {
        return EnumType.getFromStringValue((String)this.childNode.getTextValueForPatternName("enumerated"));
    }

    public String getEnumeratedAsString() {
        return this.childNode.getTextValueForPatternName("enumerated");
    }

    public Basic<T> removeEnumerated() {
        this.childNode.removeAttribute("enumerated");
        return this;
    }

    public Basic<T> name(String name) {
        this.childNode.attribute("name", name);
        return this;
    }

    public String getName() {
        return this.childNode.getAttribute("name");
    }

    public Basic<T> removeName() {
        this.childNode.removeAttribute("name");
        return this;
    }

    public Basic<T> fetch(FetchType fetch) {
        this.childNode.attribute("fetch", (Object)fetch);
        return this;
    }

    public Basic<T> fetch(String fetch) {
        this.childNode.attribute("fetch", fetch);
        return this;
    }

    public FetchType getFetch() {
        return FetchType.getFromStringValue((String)this.childNode.getAttribute("fetch"));
    }

    public String getFetchAsString() {
        return this.childNode.getAttribute("fetch");
    }

    public Basic<T> removeFetch() {
        this.childNode.removeAttribute("fetch");
        return this;
    }

    public Basic<T> optional(Boolean optional) {
        this.childNode.attribute("optional", (Object)optional);
        return this;
    }

    public Boolean isOptional() {
        return Strings.isTrue((String)this.childNode.getAttribute("optional"));
    }

    public Basic<T> removeOptional() {
        this.childNode.removeAttribute("optional");
        return this;
    }

    public Basic<T> access(AccessType access) {
        this.childNode.attribute("access", (Object)access);
        return this;
    }

    public Basic<T> access(String access) {
        this.childNode.attribute("access", access);
        return this;
    }

    public AccessType getAccess() {
        return AccessType.getFromStringValue((String)this.childNode.getAttribute("access"));
    }

    public String getAccessAsString() {
        return this.childNode.getAttribute("access");
    }

    public Basic<T> removeAccess() {
        this.childNode.removeAttribute("access");
        return this;
    }
}

