/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.ldapMessage;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMessageId
extends GrammarAction<LdapMessageContainer<Message>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMessageId.class);

    public StoreMessageId() {
        super("Store MessageID");
    }

    public void action(LdapMessageContainer<Message> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_05100_ZERO_LENGTH_MESSAGE_ID_NOT_ALLOWED, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_05101_NULL_MESSAGE_ID_NOT_ALLOWED, (Object[])new Object[0]));
        }
        BerValue value = tlv.getValue();
        try {
            int messageId = IntegerDecoder.parse((BerValue)value, (int)0, (int)Integer.MAX_VALUE);
            container.setMessageId(messageId);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_05102_LDAP_MESSAGE_ID_DECODED, (Object[])new Object[]{messageId}));
            }
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err((I18n)I18n.ERR_05102_INVALID_MESSAGE_ID, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), ide.getLocalizedMessage()}));
            throw new DecoderException(ide.getMessage(), (Throwable)ide);
        }
    }
}

