/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public enum PunningsMode {
    DL1_COMPATIBLE,
    DL1,
    DL2,
    DL_WEAK,
    FULL;

    private static final Set<Resource> OWL2_ALL_OBJECT_PROPERTIES;
    private static final Set<Resource> OWL1_ALL_OBJECT_PROPERTIES;
    private static final Set<Resource> OWL2_OBJECT_PROPERTIES;
    private static final Set<Resource> DATATYPE_PROPERTIES;
    private static final Set<Resource> ANNOTATION_PROPERTIES;
    private static final Set<Resource> RDF_PROPERTIES;
    private static final Set<Resource> OWL2_CLASSES;
    private static final Set<Resource> OWL1_CLASSES;
    private static final Set<Resource> OWL1_ALL_CLASSES;
    private static final Set<Resource> OWL2_DATATYPES;
    private static final Set<Resource> OWL1_DATATYPES;
    private static final Set<Resource> OWL2_INDIVIDUALS;

    static Map<Class<? extends OntObject>, Set<Node>> toMap(PunningsMode mode) {
        Map<Class<? extends OntObject>, Set<Set<Resource>>> res;
        if (DL1_COMPATIBLE == mode) {
            res = PunningsMode.OWL1_DL(true);
        } else if (DL1 == mode) {
            res = PunningsMode.OWL1_DL(false);
        } else if (DL2 == mode) {
            res = PunningsMode.OWL2_DL();
        } else if (DL_WEAK == mode) {
            res = PunningsMode.OWL2_DL_WEAK();
        } else if (FULL == mode) {
            res = PunningsMode.FULL();
        } else {
            throw new IllegalStateException();
        }
        return res.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, it -> ((Set)it.getValue()).stream().flatMap(Collection::stream).map(FrontsNode::asNode).collect(Collectors.toUnmodifiableSet())));
    }

    private static Map<Class<? extends OntObject>, Set<Set<Resource>>> OWL1_DL(boolean compatible) {
        Set<Resource> classes = compatible ? OWL1_ALL_CLASSES : OWL1_CLASSES;
        return Map.of(OntAnnotationProperty.class, Set.of(OWL1_ALL_OBJECT_PROPERTIES, DATATYPE_PROPERTIES, classes), OntObjectProperty.Named.class, Set.of(DATATYPE_PROPERTIES, ANNOTATION_PROPERTIES, classes), OntDataProperty.class, Set.of(OWL1_ALL_OBJECT_PROPERTIES, ANNOTATION_PROPERTIES, classes), OntDataRange.Named.class, Set.of(OWL1_DATATYPES), OntClass.Named.class, Set.of(ANNOTATION_PROPERTIES, OWL1_ALL_OBJECT_PROPERTIES, DATATYPE_PROPERTIES), OntIndividual.Named.class, Set.of(ANNOTATION_PROPERTIES, OWL1_ALL_OBJECT_PROPERTIES, DATATYPE_PROPERTIES, classes, RDF_PROPERTIES));
    }

    private static Map<Class<? extends OntObject>, Set<Set<Resource>>> OWL2_DL() {
        return Map.of(OntAnnotationProperty.class, Set.of(OWL2_ALL_OBJECT_PROPERTIES, DATATYPE_PROPERTIES), OntObjectProperty.Named.class, Set.of(DATATYPE_PROPERTIES, ANNOTATION_PROPERTIES), OntDataProperty.class, Set.of(OWL2_ALL_OBJECT_PROPERTIES, ANNOTATION_PROPERTIES), OntDataRange.Named.class, Set.of(OWL2_CLASSES), OntClass.Named.class, Set.of(OWL2_DATATYPES), OntIndividual.Named.class, Set.of());
    }

    private static Map<Class<? extends OntObject>, Set<Set<Resource>>> OWL2_DL_WEAK() {
        return Map.of(OntAnnotationProperty.class, Set.of(), OntObjectProperty.Named.class, Set.of(DATATYPE_PROPERTIES), OntDataProperty.class, Set.of(OWL2_OBJECT_PROPERTIES), OntDataRange.Named.class, Set.of(OWL2_CLASSES), OntClass.Named.class, Set.of(OWL2_DATATYPES), OntIndividual.Named.class, Set.of());
    }

    private static Map<Class<? extends OntObject>, Set<Set<Resource>>> FULL() {
        return Map.of(OntAnnotationProperty.class, Set.of(), OntObjectProperty.Named.class, Set.of(), OntDataProperty.class, Set.of(), OntDataRange.Named.class, Set.of(), OntClass.Named.class, Set.of(), OntIndividual.Named.class, Set.of());
    }

    static {
        OWL2_ALL_OBJECT_PROPERTIES = Set.of(OWL2.ObjectProperty, OWL2.InverseFunctionalProperty, OWL2.ReflexiveProperty, OWL2.IrreflexiveProperty, OWL2.SymmetricProperty, OWL2.AsymmetricProperty, OWL2.TransitiveProperty);
        OWL1_ALL_OBJECT_PROPERTIES = Set.of(OWL2.ObjectProperty, OWL2.InverseFunctionalProperty, OWL2.SymmetricProperty, OWL2.TransitiveProperty);
        OWL2_OBJECT_PROPERTIES = Set.of(OWL2.ObjectProperty);
        DATATYPE_PROPERTIES = Set.of(OWL2.DatatypeProperty);
        ANNOTATION_PROPERTIES = Set.of(OWL2.AnnotationProperty);
        RDF_PROPERTIES = Set.of(RDF.Property);
        OWL2_CLASSES = Set.of(OWL2.Class);
        OWL1_CLASSES = Set.of(OWL2.Class);
        OWL1_ALL_CLASSES = Set.of(OWL2.Class, OWL2.Restriction, RDFS.Class, RDFS.Datatype);
        OWL2_DATATYPES = Set.of(RDFS.Datatype);
        OWL1_DATATYPES = Set.of(OWL2.DataRange);
        OWL2_INDIVIDUALS = Set.of(OWL2.NamedIndividual);
    }
}

