/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.simple;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.PrefixEntry;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.PrefixMapZero;

public class StoragePrefixesSimpleMem
implements StoragePrefixes {
    private Map<Node, PrefixMap> map = new HashMap<Node, PrefixMap>();

    @Override
    public String get(Node graphNode, String prefix) {
        PrefixMap pmap = this.map.get(graphNode = PrefixLib.canonicalGraphName((Node)graphNode));
        if (pmap == null) {
            return null;
        }
        return pmap.get(prefix);
    }

    @Override
    public Iterator<PrefixEntry> get(Node graphNode) {
        PrefixMap pmap = this.map.get(graphNode = PrefixLib.canonicalGraphName((Node)graphNode));
        if (pmap == null) {
            return Iter.nullIterator();
        }
        return pmap.getMapping().entrySet().stream().map(e -> PrefixEntry.create((String)((String)e.getKey()), (String)((String)e.getValue()))).iterator();
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.map.keySet().iterator();
    }

    @Override
    public void add(Node graphNode, String prefix, String iriStr) {
        this.accessForUpdate(graphNode).add(prefix, iriStr);
    }

    @Override
    public void delete(Node graphNode, String prefix) {
        this.access(graphNode).delete(prefix);
    }

    @Override
    public void deleteAll(Node graphNode) {
        this.access(graphNode).clear();
    }

    @Override
    public boolean isEmpty() {
        if (this.map.isEmpty()) {
            return true;
        }
        return this.map.entrySet().stream().allMatch(e -> ((PrefixMap)e.getValue()).isEmpty());
    }

    @Override
    public int size() {
        return 0;
    }

    protected PrefixMap createPrefixMap() {
        return PrefixMapFactory.create();
    }

    private PrefixMap accessForUpdate(Node graphName) {
        PrefixMap pmap = this.map.get(graphName = PrefixLib.canonicalGraphName((Node)graphName));
        if (pmap == null) {
            pmap = this.createPrefixMap();
            this.map.put(graphName, pmap);
        }
        return pmap;
    }

    private PrefixMap access(Node graphName) {
        PrefixMap pmap = this.map.get(graphName = PrefixLib.canonicalGraphName((Node)graphName));
        if (pmap == null) {
            return PrefixMapZero.empty;
        }
        return pmap;
    }
}

