/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.replication.slave.SlaveFactory;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.db.BasicDatabase;
import org.apache.derby.impl.store.replication.ReplicationLogger;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;

public class SlaveDatabase
extends BasicDatabase {
    private volatile boolean inReplicationSlaveMode;
    private volatile boolean shutdownInitiated;
    private volatile boolean inBoot;
    private volatile StandardException bootException;
    private String dbname;
    private volatile SlaveFactory slaveFac;

    @Override
    public boolean canSupport(Properties properties) {
        String string;
        boolean bl = Monitor.isDesiredCreateType(properties, this.getEngineType());
        if (bl && ((string = properties.getProperty("replication.slave.mode")) == null || !string.equals("slavemode"))) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        this.inReplicationSlaveMode = true;
        this.inBoot = true;
        this.shutdownInitiated = false;
        this.dbname = properties.getProperty("replication.slave.dbname");
        SlaveDatabaseBootThread slaveDatabaseBootThread = new SlaveDatabaseBootThread(bl, properties);
        Thread thread = new Thread((Runnable)slaveDatabaseBootThread, "derby.slave.boot-" + this.dbname);
        thread.setDaemon(true);
        thread.start();
        this.verifySuccessfulBoot();
        this.inBoot = false;
        this.active = true;
    }

    @Override
    public void stop() {
        if (this.inReplicationSlaveMode && this.slaveFac != null) {
            try {
                this.slaveFac.stopSlave(true);
            }
            catch (StandardException standardException) {
            }
            finally {
                this.slaveFac = null;
            }
        }
        super.stop();
    }

    @Override
    public boolean isInSlaveMode() {
        return this.inReplicationSlaveMode;
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager contextManager, String string, String string2, String string3) throws StandardException {
        if (this.inReplicationSlaveMode) {
            throw StandardException.newException((String)"08004.C.7", (Object[])new Object[]{string3});
        }
        return super.setupConnection(contextManager, string, string2, string3);
    }

    @Override
    public AuthenticationService getAuthenticationService() throws StandardException {
        if (this.inReplicationSlaveMode) {
            throw StandardException.newException((String)"08004.C.7", (Object[])new Object[]{this.dbname});
        }
        return super.getAuthenticationService();
    }

    public void verifyShutdownSlave() throws StandardException {
        if (!this.shutdownInitiated) {
            throw StandardException.newException((String)"XRE43", (Object[])new Object[0]);
        }
        this.pushDbContext(SlaveDatabase.getContextService().getCurrentContextManager());
    }

    @Override
    public void stopReplicationSlave() throws SQLException {
        if (this.shutdownInitiated) {
            return;
        }
        if (!this.inReplicationSlaveMode) {
            StandardException standardException = StandardException.newException((String)"XRE40", (Object[])new Object[0]);
            throw PublicAPI.wrapStandardException((StandardException)standardException);
        }
        try {
            this.slaveFac.stopSlave(false);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException((StandardException)standardException);
        }
        this.slaveFac = null;
    }

    @Override
    public void failover(String string) throws StandardException {
        if (this.inReplicationSlaveMode) {
            this.slaveFac.failover();
            while (this.inReplicationSlaveMode) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
        } else {
            super.failover(string);
        }
    }

    private void verifySuccessfulBoot() throws StandardException {
        while (!this.isSlaveFactorySet() || !this.slaveFac.isStarted()) {
            if (this.bootException != null) {
                throw this.bootException;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                InterruptStatus.setInterrupted();
            }
        }
        if (this.bootException != null) {
            throw this.bootException;
        }
    }

    private boolean isSlaveFactorySet() {
        if (this.slaveFac != null) {
            return true;
        }
        try {
            this.slaveFac = (SlaveFactory)SlaveDatabase.findServiceModule(this, "org.apache.derby.iapi.store.replication.slave.SlaveFactory");
            return true;
        }
        catch (StandardException standardException) {
            return false;
        }
    }

    private void handleShutdown(StandardException standardException) {
        if (this.inBoot) {
            this.bootException = standardException;
            return;
        }
        try {
            this.shutdownInitiated = true;
            String string = "jdbc:derby:" + this.dbname + ";internal_stopslave=true";
            InternalDriver internalDriver = InternalDriver.activeDriver();
            if (internalDriver != null) {
                internalDriver.connect(string, null, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bootBasicDatabase(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Object findServiceModule(Object object, String string) throws StandardException {
        return Monitor.findServiceModule(object, string);
    }

    private class SlaveDatabaseBootThread
    implements Runnable {
        private boolean create;
        private Properties params;

        public SlaveDatabaseBootThread(boolean bl, Properties properties) {
            this.create = bl;
            this.params = properties;
        }

        @Override
        public void run() {
            block3: {
                ContextManager contextManager = null;
                try {
                    contextManager = SlaveDatabase.getContextService().newContextManager();
                    SlaveDatabase.getContextService().setCurrentContextManager(contextManager);
                    SlaveDatabase.this.bootBasicDatabase(this.create, this.params);
                    SlaveDatabase.this.inReplicationSlaveMode = false;
                    if (contextManager != null) {
                        SlaveDatabase.getContextService().resetCurrentContextManager(contextManager);
                        contextManager = null;
                    }
                }
                catch (Exception exception) {
                    ReplicationLogger replicationLogger = new ReplicationLogger(SlaveDatabase.this.dbname);
                    replicationLogger.logError("R005", exception);
                    if (!(exception instanceof StandardException)) break block3;
                    SlaveDatabase.this.handleShutdown((StandardException)((Object)exception));
                }
            }
        }
    }
}

