/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.tsfile;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeRealtimePriorityBlockingQueue;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeSinkSubtaskLifeCycle;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.pipe.api.event.Event;

public class PipeCompactionManager {
    private final Set<PipeSinkSubtaskLifeCycle> pipeSinkSubtaskLifeCycles = new CopyOnWriteArraySet<PipeSinkSubtaskLifeCycle>();

    public void registerPipeConnectorSubtaskLifeCycle(PipeSinkSubtaskLifeCycle pipeSinkSubtaskLifeCycle) {
        this.pipeSinkSubtaskLifeCycles.add(pipeSinkSubtaskLifeCycle);
    }

    public void deregisterPipeConnectorSubtaskLifeCycle(PipeSinkSubtaskLifeCycle pipeSinkSubtaskLifeCycle) {
        this.pipeSinkSubtaskLifeCycles.remove(pipeSinkSubtaskLifeCycle);
    }

    public void emitResult(String storageGroupName, String dataRegionId, long timePartition, List<TsFileResource> seqFileResources, List<TsFileResource> unseqFileResources, List<TsFileResource> targetFileResources) {
        HashSet<TsFileResource> sourceFileResources = new HashSet<TsFileResource>(seqFileResources);
        sourceFileResources.addAll(unseqFileResources);
        for (PipeSinkSubtaskLifeCycle lifeCycle : this.pipeSinkSubtaskLifeCycles) {
            UnboundedBlockingPendingQueue<Event> pendingQueue = lifeCycle.getPendingQueue();
            if (!(pendingQueue instanceof PipeRealtimePriorityBlockingQueue)) continue;
            PipeRealtimePriorityBlockingQueue realtimePriorityBlockingQueue = (PipeRealtimePriorityBlockingQueue)pendingQueue;
            realtimePriorityBlockingQueue.replace(dataRegionId, sourceFileResources, targetFileResources);
        }
    }
}

