/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.factory;

import java.util.List;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.operator.And;
import org.apache.tsfile.read.filter.operator.Not;
import org.apache.tsfile.read.filter.operator.Or;
import org.apache.tsfile.utils.Preconditions;

public class FilterFactory {
    private FilterFactory() {
    }

    public static Filter and(Filter left, Filter right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new And(left, right);
    }

    public static Filter and(List<Filter> filterList) {
        And result = new And(filterList.get(0), filterList.get(1));
        int size = filterList.size();
        for (int i = 2; i < size; ++i) {
            result = new And(result, filterList.get(i));
        }
        return result;
    }

    public static Filter or(Filter left, Filter right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new Or(left, right);
    }

    public static Filter or(List<Filter> filterList) {
        Or result = new Or(filterList.get(0), filterList.get(1));
        int size = filterList.size();
        for (int i = 2; i < size; ++i) {
            result = new Or(result, filterList.get(i));
        }
        return result;
    }

    public static Not not(Filter filter) {
        Preconditions.checkArgument(filter != null, "filter cannot be null");
        return new Not(filter);
    }
}

