/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.bitpacking.LongPacker;
import org.apache.tsfile.encoding.decoder.LongRleDecoder;
import org.apache.tsfile.encoding.decoder.SprintzDecoder;
import org.apache.tsfile.encoding.fire.LongFire;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class LongSprintzDecoder
extends SprintzDecoder {
    LongPacker packer;
    LongFire firePred;
    private long preValue;
    private final long[] currentBuffer;
    private long currentValue;
    private final String predictScheme = TSFileDescriptor.getInstance().getConfig().getSprintzPredictScheme();

    public LongSprintzDecoder() {
        this.firePred = new LongFire(3);
        this.currentBuffer = new long[this.Block_size + 1];
        this.reset();
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        return this.isBlockReaded && this.currentCount < this.Block_size || buffer.remaining() > 0;
    }

    @Override
    public void reset() {
        super.reset();
        this.preValue = 0L;
        this.currentValue = 0L;
        this.currentCount = 0;
        Arrays.fill(this.currentBuffer, 0L);
    }

    @Override
    protected void decodeBlock(ByteBuffer in) throws IOException {
        this.bitWidth = ReadWriteForEncodingUtils.readIntLittleEndianPaddedOnBitWidth(in, 1);
        if ((this.bitWidth & 0x80) != 0) {
            this.decodeSize = this.bitWidth & 0xFFFFFF7F;
            LongRleDecoder decoder = new LongRleDecoder();
            for (int i = 0; i < this.decodeSize; ++i) {
                this.currentBuffer[i] = decoder.readLong(in);
            }
        } else {
            int i;
            this.decodeSize = this.Block_size + 1;
            this.currentBuffer[0] = this.preValue = in.getLong();
            long[] tmpBuffer = new long[8];
            this.packer = new LongPacker(this.bitWidth);
            byte[] packcle = new byte[this.bitWidth];
            for (i = 0; i < this.bitWidth; ++i) {
                packcle[i] = in.get();
            }
            this.packer.unpack8Values(packcle, 0, tmpBuffer);
            for (i = 0; i < 8; ++i) {
                this.currentBuffer[i + 1] = tmpBuffer[i];
            }
            this.recalculate();
        }
        this.isBlockReaded = true;
    }

    @Override
    protected void recalculate() {
        int i;
        for (i = 1; i <= this.Block_size; ++i) {
            this.currentBuffer[i] = this.currentBuffer[i] % 2L == 0L ? -this.currentBuffer[i] / 2L : (this.currentBuffer[i] + 1L) / 2L;
        }
        if (this.predictScheme.equals("delta")) {
            for (i = 1; i < this.currentBuffer.length; ++i) {
                int n = i;
                this.currentBuffer[n] = this.currentBuffer[n] + this.currentBuffer[i - 1];
            }
        } else if (this.predictScheme.equals("fire")) {
            this.firePred.reset();
            for (i = 1; i <= this.Block_size; ++i) {
                long pred = this.firePred.predict(this.currentBuffer[i - 1]);
                long err = this.currentBuffer[i];
                this.currentBuffer[i] = pred + err;
                this.firePred.train(this.currentBuffer[i - 1], this.currentBuffer[i], err);
            }
        } else {
            throw new UnsupportedOperationException("Sprintz predictive method {} is not supported.");
        }
    }

    @Override
    public long readLong(ByteBuffer buffer) {
        if (!this.isBlockReaded) {
            try {
                this.decodeBlock(buffer);
            }
            catch (IOException e) {
                logger.error("Error occured when readInt with Sprintz Decoder.", (Throwable)e);
            }
        }
        this.currentValue = this.currentBuffer[this.currentCount++];
        if (this.currentCount == this.decodeSize) {
            this.isBlockReaded = false;
            this.currentCount = 0;
        }
        return this.currentValue;
    }
}

