<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -->

### 1.0.2-RC1

<details>	
  <summary><mark>Release notes</mark></summary>

  ### Seata-go 1.0.2-RC1

  Seata-go 1.0.2-RC1 Released.	

  Seata-go is an easy-to-use, high-performance, open source distributed transaction solution.

  The version is updated as follows:	

### feature：
- [[#190](https://github.com/apache/incubator-seata-go/pull/190)] add TCC branch report
- [[#158](https://github.com/apache/incubator-seata-go/pull/158)] TCC mode supports grpc call
- [[#213](https://github.com/apache/incubator-seata-go/pull/213)] support data source proxy function
- [[#240](https://github.com/apache/incubator-seata-go/pull/240)] add undo log manager delete
- [[#243](https://github.com/apache/incubator-seata-go/pull/243)] add update sql parser
- [[#191](https://github.com/apache/incubator-seata-go/pull/191)] add fence for TCC, and add fence sample in TCC local mode
- [[#264](https://github.com/apache/incubator-seata-go/pull/264)] add update sql parser and remove tidb parser
- [[#280](https://github.com/apache/incubator-seata-go/pull/280)] TCC supports http calling
- [[#245](https://github.com/apache/incubator-seata-go/pull/245)] support hasLogTable logic
- [[#288](https://github.com/apache/incubator-seata-go/pull/288)] add MySQL update SQL undo log builder
- [[#296](https://github.com/apache/incubator-seata-go/pull/296)] add MySQL delete SQL undo log builder
- [[#303](https://github.com/apache/incubator-seata-go/pull/303)] add sync worker
- [[#289](https://github.com/apache/incubator-seata-go/pull/289)] add MySQL update SQL after undo log builder
- [[#294](https://github.com/apache/incubator-seata-go/pull/294)] add MySQL table meta query
- [[#309](https://github.com/apache/incubator-seata-go/pull/309)] init compressor type
- [[#301](https://github.com/apache/incubator-seata-go/pull/301)] add MySQL multi SQL undo log builder
- [[#321](https://github.com/apache/incubator-seata-go/pull/321)] add deflate compress
- [[#324](https://github.com/apache/incubator-seata-go/pull/324)] add LZ4 compressor
- [[#327](https://github.com/apache/incubator-seata-go/pull/327)] add zstd compressor
- [[#322](https://github.com/apache/incubator-seata-go/pull/322)] add gzip compressor
- [[#307](https://github.com/apache/incubator-seata-go/pull/307)] add flush undo log 
- [[#329](https://github.com/apache/incubator-seata-go/pull/329)] add zip compressor
- [[#325](https://github.com/apache/incubator-seata-go/pull/325)] add MySQL multi update SQL undo log builder
- [[#330](https://github.com/apache/incubator-seata-go/pull/330)] add MySQL multi delete SQL undo log builder
- [[#319](https://github.com/apache/incubator-seata-go/pull/319)] add select for update
- [[#320](https://github.com/apache/incubator-seata-go/pull/320)] add undo logic
- [[#337](https://github.com/apache/incubator-seata-go/pull/337)] add insert undo log 
- [[#355](https://github.com/apache/incubator-seata-go/pull/355)] support judging the number of undo log storage fields according to the configuration
- [[#365](https://github.com/apache/incubator-seata-go/pull/365)] do dirty data check before rolling back AT


### bugfix：

- [[#176](https://github.com/apache/incubator-seata-go/pull/176)] fix unit test bug of message
- [[#237](https://github.com/apache/incubator-seata-go/pull/237)] fix the bug of registering resources when executing the OpenConnector function
- [[#230](https://github.com/apache/incubator-seata-go/pull/230)] fix the bug of remote asynchronous call infinite loop
- [[#258](https://github.com/apache/incubator-seata-go/pull/258)] fix global transation time out bug
- [[#263](https://github.com/apache/incubator-seata-go/pull/263)] fix mock bug
- [[#326](https://github.com/apache/incubator-seata-go/pull/326)] fix fanout test data race
- [[#350](https://github.com/apache/incubator-seata-go/pull/350)] fix panic bug
- [[#359](https://github.com/apache/incubator-seata-go/pull/359)] fix insert undo log bug
- [[#368](https://github.com/apache/incubator-seata-go/pull/368)] fix AT rollback sample bug
- [[#363](https://github.com/apache/incubator-seata-go/pull/363)] fix meta data bug
- [[#365](https://github.com/apache/incubator-seata-go/pull/365)] fix decode undo log bug



### optimize:


- [[#187](https://github.com/apache/incubator-seata-go/pull/187)] optimize way of init seata-go
- [[#196](https://github.com/apache/incubator-seata-go/pull/196)] optimize remoting method's params
- [[#200](https://github.com/apache/incubator-seata-go/pull/200)] add TCC grpc sample and optimize register resource and branch register
- [[#208](https://github.com/apache/incubator-seata-go/pull/208)] optimize remove unnecessary codes
- [[#202](https://github.com/apache/incubator-seata-go/pull/202)] optimize workflow, add condecov and issue, stale robot
- [[#215](https://github.com/apache/incubator-seata-go/pull/215)] optimize the time parameter to improve readability
- [[#179](https://github.com/apache/incubator-seata-go/pull/179)] support instance BusinessActionContext outside the TCC try method
- [[#198](https://github.com/apache/incubator-seata-go/pull/198)] optimize function's parameters into one struct-rm_api.go
- [[#235](https://github.com/apache/incubator-seata-go/pull/235)] adjust MessageType enumeration value naming convention
- [[#238](https://github.com/apache/incubator-seata-go/pull/238)] add some todo comment, add a undo hook sample
- [[#229](https://github.com/apache/incubator-seata-go/pull/229)] add unit testing for common
- [[#261](https://github.com/apache/incubator-seata-go/pull/261)] optimize nested loop retries
- [[#284](https://github.com/apache/incubator-seata-go/pull/284)] optimize retry logic
- [[#286](https://github.com/apache/incubator-seata-go/pull/286)] separate the initialization logic of tm and rm
- [[#287](https://github.com/apache/incubator-seata-go/pull/287)] fefactor seata conn logic
- [[#281](https://github.com/apache/incubator-seata-go/pull/281)] optimize global transaction usage
- [[#295](https://github.com/apache/incubator-seata-go/pull/295)] fefactor seata conn logic
- [[#302](https://github.com/apache/incubator-seata-go/pull/302)] update dubbo-go version
- [[#336](https://github.com/apache/incubator-seata-go/pull/336)] optimize at overall process
- [[#346](https://github.com/apache/incubator-seata-go/pull/346)] optimize AT commit transaction process
- [[#352](https://github.com/apache/incubator-seata-go/pull/352)] optimize get meta data
- [[#354](https://github.com/apache/incubator-seata-go/pull/354)] optimize AT commit transaction process
- [[#353](https://github.com/apache/incubator-seata-go/pull/353)] modify some receiver name
- [[#356](https://github.com/apache/incubator-seata-go/pull/356)] optimize AT rollback transaction process


### test:

- [[#154](https://github.com/apache/incubator-seata-go/pull/154)] add unit test for message
- [[#163](https://github.com/apache/incubator-seata-go/pull/163)] add unit test for tm
- [[#203](https://github.com/apache/incubator-seata-go/pull/203)] add unit test for getty
- [[#204](https://github.com/apache/incubator-seata-go/pull/204)] add unit test for dubbo transtation filter 
- [[#210](https://github.com/apache/incubator-seata-go/pull/210)] add unit test for Tcc branch report
- [[#192](https://github.com/apache/incubator-seata-go/pull/192)] add unit test for rm
- [[#229](https://github.com/apache/incubator-seata-go/pull/229)] add unit test for common
- [[#299](https://github.com/apache/incubator-seata-go/pull/299)] add unit test for SQL Parser
- [[#332](https://github.com/apache/incubator-seata-go/pull/332)] add unit test for multi delete undo log
- [[#358](https://github.com/apache/incubator-seata-go/pull/358)] add AT rollback sample


### doc:

- [[#202](https://github.com/apache/incubator-seata-go/pull/202)] optimize workflow, add condecov and issue
- [[#254](https://github.com/apache/incubator-seata-go/pull/254)] add license automatic check script
- [[#305](https://github.com/apache/incubator-seata-go/pull/305)] config github action not to automatically close pr or issue


### contributors:

Thanks to these contributors for their code commits. Please report an unintended omission.  

- [AlexStocks](https://github.com/AlexStocks)
- [luky116](https://github.com/luky116)
- [106umao](https://github.com/106umao)
- [liiibpm](https://github.com/liiibpm)
- [elrond-g](https://github.com/elrond-g)
- [wang1309](https://github.com/wang1309)
- [iSuperCoder](https://github.com/apache/incubator-seata-go/commits?author=iSuperCoder)
- [a631807682](https://github.com/apache/incubator-seata-go/commits?author=a631807682)
- [betterwinsone](https://github.com/apache/incubator-seata-go/commits?author=betterwinsone) 
- [jasondeng1997](https://github.com/apache/incubator-seata-go/commits?author=jasondeng1997)
- [chuntaojun](https://github.com/apache/incubator-seata-go/commits?author=chuntaojun) 
- [complone](https://github.com/apache/incubator-seata-go/commits?author=complone) 
- [miaoxueyu](https://github.com/apache/incubator-seata-go/commits?author=miaoxueyu)
- [PangXing](https://github.com/apache/incubator-seata-go/commits?author=PangXing)
- [georgehao](https://github.com/apache/incubator-seata-go/commits?author=georgehao)
- [baerwang](https://github.com/apache/incubator-seata-go/commits?author=baerwang)
- [raspberry-hu](https://github.com/apache/incubator-seata-go/commits?author=raspberry-hu)
- [WyattJia](https://github.com/apache/incubator-seata-go/commits?author=WyattJia)
- [Code-Fight](https://github.com/Code-Fight)
- [betterwinsone](https://github.com/betterwinsonet)

Also, we receive many valuable issues, questions and advices from our community. Thanks for you all.	

</detail>